<?php
namespace Aws\Redshift;

use Aws\AwsClient;

/**
 * This client is used to interact with the **Amazon Redshift** service.
 *
 * @method \Aws\Result acceptReservedNodeExchange(array $args = [])
 * @method \GuzzleHttp\Promise\Promise acceptReservedNodeExchangeAsync(array $args = [])
 * @method \Aws\Result authorizeClusterSecurityGroupIngress(array $args = [])
 * @method \GuzzleHttp\Promise\Promise authorizeClusterSecurityGroupIngressAsync(array $args = [])
 * @method \Aws\Result authorizeSnapshotAccess(array $args = [])
 * @method \GuzzleHttp\Promise\Promise authorizeSnapshotAccessAsync(array $args = [])
 * @method \Aws\Result copyClusterSnapshot(array $args = [])
 * @method \GuzzleHttp\Promise\Promise copyClusterSnapshotAsync(array $args = [])
 * @method \Aws\Result createCluster(array $args = [])
 * @method \GuzzleHttp\Promise\Promise createClusterAsync(array $args = [])
 * @method \Aws\Result createClusterParameterGroup(array $args = [])
 * @method \GuzzleHttp\Promise\Promise createClusterParameterGroupAsync(array $args = [])
 * @method \Aws\Result createClusterSecurityGroup(array $args = [])
 * @method \GuzzleHttp\Promise\Promise createClusterSecurityGroupAsync(array $args = [])
 * @method \Aws\Result createClusterSnapshot(array $args = [])
 * @method \GuzzleHttp\Promise\Promise createClusterSnapshotAsync(array $args = [])
 * @method \Aws\Result createClusterSubnetGroup(array $args = [])
 * @method \GuzzleHttp\Promise\Promise createClusterSubnetGroupAsync(array $args = [])
 * @method \Aws\Result createEventSubscription(array $args = [])
 * @method \GuzzleHttp\Promise\Promise createEventSubscriptionAsync(array $args = [])
 * @method \Aws\Result createHsmClientCertificate(array $args = [])
 * @method \GuzzleHttp\Promise\Promise createHsmClientCertificateAsync(array $args = [])
 * @method \Aws\Result createHsmConfiguration(array $args = [])
 * @method \GuzzleHttp\Promise\Promise createHsmConfigurationAsync(array $args = [])
 * @method \Aws\Result createSnapshotCopyGrant(array $args = [])
 * @method \GuzzleHttp\Promise\Promise createSnapshotCopyGrantAsync(array $args = [])
 * @method \Aws\Result createTags(array $args = [])
 * @method \GuzzleHttp\Promise\Promise createTagsAsync(array $args = [])
 * @method \Aws\Result deleteCluster(array $args = [])
 * @method \GuzzleHttp\Promise\Promise deleteClusterAsync(array $args = [])
 * @method \Aws\Result deleteClusterParameterGroup(array $args = [])
 * @method \GuzzleHttp\Promise\Promise deleteClusterParameterGroupAsync(array $args = [])
 * @method \Aws\Result deleteClusterSecurityGroup(array $args = [])
 * @method \GuzzleHttp\Promise\Promise deleteClusterSecurityGroupAsync(array $args = [])
 * @method \Aws\Result deleteClusterSnapshot(array $args = [])
 * @method \GuzzleHttp\Promise\Promise deleteClusterSnapshotAsync(array $args = [])
 * @method \Aws\Result deleteClusterSubnetGroup(array $args = [])
 * @method \GuzzleHttp\Promise\Promise deleteClusterSubnetGroupAsync(array $args = [])
 * @method \Aws\Result deleteEventSubscription(array $args = [])
 * @method \GuzzleHttp\Promise\Promise deleteEventSubscriptionAsync(array $args = [])
 * @method \Aws\Result deleteHsmClientCertificate(array $args = [])
 * @method \GuzzleHttp\Promise\Promise deleteHsmClientCertificateAsync(array $args = [])
 * @method \Aws\Result deleteHsmConfiguration(array $args = [])
 * @method \GuzzleHttp\Promise\Promise deleteHsmConfigurationAsync(array $args = [])
 * @method \Aws\Result deleteSnapshotCopyGrant(array $args = [])
 * @method \GuzzleHttp\Promise\Promise deleteSnapshotCopyGrantAsync(array $args = [])
 * @method \Aws\Result deleteTags(array $args = [])
 * @method \GuzzleHttp\Promise\Promise deleteTagsAsync(array $args = [])
 * @method \Aws\Result describeClusterDbRevisions(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeClusterDbRevisionsAsync(array $args = [])
 * @method \Aws\Result describeClusterParameterGroups(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeClusterParameterGroupsAsync(array $args = [])
 * @method \Aws\Result describeClusterParameters(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeClusterParametersAsync(array $args = [])
 * @method \Aws\Result describeClusterSecurityGroups(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeClusterSecurityGroupsAsync(array $args = [])
 * @method \Aws\Result describeClusterSnapshots(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeClusterSnapshotsAsync(array $args = [])
 * @method \Aws\Result describeClusterSubnetGroups(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeClusterSubnetGroupsAsync(array $args = [])
 * @method \Aws\Result describeClusterVersions(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeClusterVersionsAsync(array $args = [])
 * @method \Aws\Result describeClusters(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeClustersAsync(array $args = [])
 * @method \Aws\Result describeDefaultClusterParameters(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeDefaultClusterParametersAsync(array $args = [])
 * @method \Aws\Result describeEventCategories(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeEventCategoriesAsync(array $args = [])
 * @method \Aws\Result describeEventSubscriptions(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeEventSubscriptionsAsync(array $args = [])
 * @method \Aws\Result describeEvents(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeEventsAsync(array $args = [])
 * @method \Aws\Result describeHsmClientCertificates(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeHsmClientCertificatesAsync(array $args = [])
 * @method \Aws\Result describeHsmConfigurations(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeHsmConfigurationsAsync(array $args = [])
 * @method \Aws\Result describeLoggingStatus(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeLoggingStatusAsync(array $args = [])
 * @method \Aws\Result describeOrderableClusterOptions(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeOrderableClusterOptionsAsync(array $args = [])
 * @method \Aws\Result describeReservedNodeOfferings(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeReservedNodeOfferingsAsync(array $args = [])
 * @method \Aws\Result describeReservedNodes(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeReservedNodesAsync(array $args = [])
 * @method \Aws\Result describeResize(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeResizeAsync(array $args = [])
 * @method \Aws\Result describeSnapshotCopyGrants(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeSnapshotCopyGrantsAsync(array $args = [])
 * @method \Aws\Result describeTableRestoreStatus(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeTableRestoreStatusAsync(array $args = [])
 * @method \Aws\Result describeTags(array $args = [])
 * @method \GuzzleHttp\Promise\Promise describeTagsAsync(array $args = [])
 * @method \Aws\Result disableLogging(array $args = [])
 * @method \GuzzleHttp\Promise\Promise disableLoggingAsync(array $args = [])
 * @method \Aws\Result disableSnapshotCopy(array $args = [])
 * @method \GuzzleHttp\Promise\Promise disableSnapshotCopyAsync(array $args = [])
 * @method \Aws\Result enableLogging(array $args = [])
 * @method \GuzzleHttp\Promise\Promise enableLoggingAsync(array $args = [])
 * @method \Aws\Result enableSnapshotCopy(array $args = [])
 * @method \GuzzleHttp\Promise\Promise enableSnapshotCopyAsync(array $args = [])
 * @method \Aws\Result getClusterCredentials(array $args = [])
 * @method \GuzzleHttp\Promise\Promise getClusterCredentialsAsync(array $args = [])
 * @method \Aws\Result getReservedNodeExchangeOfferings(array $args = [])
 * @method \GuzzleHttp\Promise\Promise getReservedNodeExchangeOfferingsAsync(array $args = [])
 * @method \Aws\Result modifyCluster(array $args = [])
 * @method \GuzzleHttp\Promise\Promise modifyClusterAsync(array $args = [])
 * @method \Aws\Result modifyClusterDbRevision(array $args = [])
 * @method \GuzzleHttp\Promise\Promise modifyClusterDbRevisionAsync(array $args = [])
 * @method \Aws\Result modifyClusterIamRoles(array $args = [])
 * @method \GuzzleHttp\Promise\Promise modifyClusterIamRolesAsync(array $args = [])
 * @method \Aws\Result modifyClusterParameterGroup(array $args = [])
 * @method \GuzzleHttp\Promise\Promise modifyClusterParameterGroupAsync(array $args = [])
 * @method \Aws\Result modifyClusterSubnetGroup(array $args = [])
 * @method \GuzzleHttp\Promise\Promise modifyClusterSubnetGroupAsync(array $args = [])
 * @method \Aws\Result modifyEventSubscription(array $args = [])
 * @method \GuzzleHttp\Promise\Promise modifyEventSubscriptionAsync(array $args = [])
 * @method \Aws\Result modifySnapshotCopyRetentionPeriod(array $args = [])
 * @method \GuzzleHttp\Promise\Promise modifySnapshotCopyRetentionPeriodAsync(array $args = [])
 * @method \Aws\Result purchaseReservedNodeOffering(array $args = [])
 * @method \GuzzleHttp\Promise\Promise purchaseReservedNodeOfferingAsync(array $args = [])
 * @method \Aws\Result rebootCluster(array $args = [])
 * @method \GuzzleHttp\Promise\Promise rebootClusterAsync(array $args = [])
 * @method \Aws\Result resetClusterParameterGroup(array $args = [])
 * @method \GuzzleHttp\Promise\Promise resetClusterParameterGroupAsync(array $args = [])
 * @method \Aws\Result restoreFromClusterSnapshot(array $args = [])
 * @method \GuzzleHttp\Promise\Promise restoreFromClusterSnapshotAsync(array $args = [])
 * @method \Aws\Result restoreTableFromClusterSnapshot(array $args = [])
 * @method \GuzzleHttp\Promise\Promise restoreTableFromClusterSnapshotAsync(array $args = [])
 * @method \Aws\Result revokeClusterSecurityGroupIngress(array $args = [])
 * @method \GuzzleHttp\Promise\Promise revokeClusterSecurityGroupIngressAsync(array $args = [])
 * @method \Aws\Result revokeSnapshotAccess(array $args = [])
 * @method \GuzzleHttp\Promise\Promise revokeSnapshotAccessAsync(array $args = [])
 * @method \Aws\Result rotateEncryptionKey(array $args = [])
 * @method \GuzzleHttp\Promise\Promise rotateEncryptionKeyAsync(array $args = [])
 */
class RedshiftClient extends AwsClient {}
