/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.bib;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.bib.At;
import com.dickimawbooks.texparserlib.bib.BibComment;
import com.dickimawbooks.texparserlib.bib.BibEntry;
import com.dickimawbooks.texparserlib.bib.BibNumber;
import com.dickimawbooks.texparserlib.bib.BibParser;
import com.dickimawbooks.texparserlib.bib.BibPreamble;
import com.dickimawbooks.texparserlib.bib.BibString;
import com.dickimawbooks.texparserlib.bib.BibTeXSyntaxException;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.bib.BibVariable;
import com.dickimawbooks.texparserlib.bib.StringConcat;
import java.io.IOException;

public abstract class BibData {
    public static final byte CASE_NOCHANGE = 0;
    public static final byte CASE_TO_LOWER = 1;
    public static final byte CASE_TO_UPPER = 2;
    public static final byte CASE_INITIAL_CAP = 3;

    public abstract String getEntryType();

    public abstract void parseContents(TeXParser var1, TeXObjectList var2, TeXObject var3) throws IOException;

    public static BibData createBibData(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("preamble")) {
            return new BibPreamble(string);
        }
        if (string2.equals("string")) {
            return new BibString(string);
        }
        if (string2.equals("comment")) {
            return new BibComment(string);
        }
        return new BibEntry(string);
    }

    public TeXObjectList readKeyObject(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        TeXObject teXObject = teXObjectList.popStack(teXParser);
        while (teXObject != null && teXObject instanceof WhiteSpace) {
            teXObject = teXObjectList.popStack(teXParser);
        }
        if (teXObject == null) {
            return null;
        }
        while (teXObject != null && !(teXObject instanceof WhiteSpace)) {
            if (teXObject instanceof At) {
                teXObject = teXParser.getListener().getOther(64);
            }
            if (teXObject instanceof CharObject) {
                int n = ((CharObject)teXObject).getCharCode();
                if (n == 35 || n == 34 || n == 40 || n == 41) {
                    throw new BibTeXSyntaxException(teXParser, "bibtex.error.immediately_follows_field_name", teXObject.format());
                }
                if (n == 44 || n == 61) {
                    teXObjectList.push(teXObject);
                    break;
                }
            } else {
                throw new BibTeXSyntaxException(teXParser, "bibtex.error.immediately_follows_field_name", teXObject.format());
            }
            teXObjectList2.add(teXObject);
            teXObject = teXObjectList.popStack(teXParser);
        }
        return teXObjectList2;
    }

    public String readKey(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = this.readKeyObject(teXParser, teXObjectList);
        if (teXObjectList2 == null) {
            return null;
        }
        String string = teXObjectList2.format();
        if (string.isEmpty()) {
            throw new BibTeXSyntaxException(teXParser, "bibtex.error.missing_field_name", new Object[0]);
        }
        return string;
    }

    public boolean readValue(TeXParser teXParser, TeXObjectList teXObjectList, BibValueList bibValueList, TeXObject teXObject) throws IOException {
        int n;
        BibParser bibParser = (BibParser)teXParser.getListener();
        TeXObject teXObject2 = teXObjectList.popStack(teXParser);
        while (teXObject2 != null && teXObject2 instanceof WhiteSpace) {
            teXObject2 = teXObjectList.popStack(teXParser);
        }
        if (teXObject2 == null) {
            return false;
        }
        if (teXObject2 instanceof CharObject) {
            n = ((CharObject)teXObject2).getCharCode();
            if (n == 44) {
                return true;
            }
            if (n == 35) {
                throw new BibTeXSyntaxException(teXParser, "bibtex.error.missing_field_part", new Object[0]);
            }
        }
        if (teXObject2 instanceof StringConcat) {
            throw new BibTeXSyntaxException(teXParser, "bibtex.error.missing_field_part", new Object[0]);
        }
        if (teXObject2 instanceof Group) {
            bibValueList.add(new BibUserString(teXObject2));
        } else if (teXObject2 instanceof CharObject && ((CharObject)teXObject2).getCharCode() == 34) {
            TeXObjectList teXObjectList2 = new TeXObjectList();
            teXObjectList2.add(teXObject2);
            teXObject2 = teXObjectList.popStack(teXParser);
            while (teXObject2 != null) {
                teXObjectList2.add(teXObject2);
                if (teXObject2 instanceof CharObject && ((CharObject)teXObject2).getCharCode() == 34) break;
                teXObject2 = teXObjectList.popStack(teXParser);
            }
            if (teXObject2 == null) {
                throw new BibTeXSyntaxException(teXParser, "bibtex.error.unbalanced_braces", new Object[0]);
            }
            bibValueList.add(new BibUserString(teXObjectList2));
        } else if (teXObject2 instanceof TeXNumber) {
            bibValueList.add(new BibNumber((TeXNumber)teXObject2));
        } else {
            TeXObjectList teXObjectList3 = new TeXObjectList();
            while (teXObject2 != null && !(teXObject2 instanceof WhiteSpace)) {
                if (teXObject2 instanceof CharObject) {
                    int n2 = ((CharObject)teXObject2).getCharCode();
                    if (n2 == 44) break;
                    if (n2 == 61) {
                        if (teXObjectList3.isEmpty()) {
                            throw new BibTeXSyntaxException(teXParser, "bibtex.error.missing_field_part", new Object[0]);
                        }
                        throw new BibTeXSyntaxException(teXParser, "bibtex.error.expecting_or", ",", teXObject.format());
                    }
                    if (n2 == 35) {
                        teXObject2 = new StringConcat(n2);
                    }
                }
                if (teXObject2 instanceof StringConcat) {
                    teXObjectList.push(teXObject2);
                    break;
                }
                teXObjectList3.add(teXObject2);
                teXObject2 = teXObjectList.popStack(teXParser);
            }
            teXObjectList.push(teXObject2);
            if (teXObjectList3.isEmpty()) {
                throw new BibTeXSyntaxException(teXParser, "bibtex.error.missing_field_part", new Object[0]);
            }
            String string = teXObjectList3.toString(teXParser);
            try {
                bibValueList.add(new BibNumber(new UserNumber(Integer.parseInt(string))));
            }
            catch (NumberFormatException numberFormatException) {
                bibValueList.add(new BibVariable(teXObjectList3, string));
            }
        }
        teXObject2 = teXObjectList.popStack(teXParser);
        while (teXObject2 != null && teXObject2 instanceof WhiteSpace) {
            teXObject2 = teXObjectList.popStack(teXParser);
        }
        if (teXObject2 == null) {
            return false;
        }
        if (teXObject2 instanceof CharObject) {
            n = ((CharObject)teXObject2).getCharCode();
            if (n == 44) {
                return true;
            }
            if (n == 61) {
                throw new BibTeXSyntaxException(teXParser, "bibtex.error.expecting_or", ",", teXObject.format());
            }
            if (n == 35) {
                teXObject2 = new StringConcat(n);
            }
        }
        if (teXObject2 instanceof StringConcat) {
            bibValueList.add((StringConcat)teXObject2);
            n = bibValueList.size();
            boolean bl = this.readValue(teXParser, teXObjectList, bibValueList, teXObject);
            if (bibValueList.size() == n) {
                throw new BibTeXSyntaxException(teXParser, "bibtex.error.expecting_or", ",", teXObject.format());
            }
            return bl;
        }
        throw new BibTeXSyntaxException(teXParser, "bibtex.error.expecting_or", ",", teXObject.format());
    }

    public String format() {
        return this.format((byte)0, '{', '}', (byte)0);
    }

    public static String applyCase(String string, byte by) {
        switch (by) {
            case 0: {
                return string;
            }
            case 1: {
                return string.toLowerCase();
            }
            case 2: {
                return string.toUpperCase();
            }
            case 3: {
                return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
            }
        }
        throw new IllegalArgumentException("Invalid caseChange argument");
    }

    public abstract String format(byte var1, char var2, char var3, byte var4);
}

