/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2010 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_TMO_H_
#define _SOPRANO_TMO_H_

#include <QtCore/QUrl>
#include "nepomuk_export.h"

namespace Nepomuk {
    namespace Vocabulary {
        namespace TMO {
            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#
             */
            NEPOMUK_EXPORT QUrl tmoNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#
             */
            NEPOMUK_EXPORT QUrl nrlOntologyGraph();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#AbilityCarrier 
             * 
             * AbilityCarrier is an abstract class which circumferences 
             * all entities which can take action or which are somehow involved 
             * in tasks. 
             * This is in other task conceptualizations rather named "actor". 
             * But here it is named AbilityCarrier because it is not neccessarily 
             * "active". 
             * 
             * The execution of a task relies on certain abilities. The abstract 
             * concept of 
             * Abilitiy_Carriers circumference all those more concrete 
             * concepts 
             * of which one can think of while working on tasks. Using this abstract 
             * class enables to substitute such Ability Carrier's in the process 
             * of 
             * generating patterns from task instances and vice versa in the 
             * process of 
             * instantiating task instances from patterns without violating 
             * the schema. 
             * With this attribute, a series of ability carrying entities 
             * (Person, Role, 
             * Skill, OrganizationalUnit, InformalDescribedAbility) 
             * and the role of involvement (required, request, used) is enabled. 
             * The role 
             * hereby allows specifying how the ability carrying entity is 
             * or was 
             * involved. 
             */
            NEPOMUK_EXPORT QUrl AbilityCarrier();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#AbilityCarrierInvolvement 
             * 
             * The class AbilityCarrier_Involvement ties together an AbilityCarrier 
             * with an AbilityCarrier_Role. This is a role based modelling 
             * approach. An n-ary relation is realized. 
             */
            NEPOMUK_EXPORT QUrl AbilityCarrierInvolvement();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#AbilityCarrierRole 
             * 
             * Examples instances of AbilityCarrirRoles are e.g. "requested", 
             * "required" and "used" which further specify the type a person 
             * was involved in. 
             */
            NEPOMUK_EXPORT QUrl AbilityCarrierRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#AgentAbilityCarrier 
             */
            NEPOMUK_EXPORT QUrl AgentAbilityCarrier();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#AssociationDependency 
             */
            NEPOMUK_EXPORT QUrl AssociationDependency();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#Attachment 
             * 
             * By means of attachments, references to other resources can 
             * be established. Resources are information objects. Every 
             * Thing, which can be referenced, on the SSD is an information 
             * object. In contrast to the usual SSD references/associations, 
             * here additionally information can be specified. Further metadata 
             * about the role an attachment plays can be stated by means of instances 
             * of AttachmentRole. It can be expressed what the Role of attachment 
             * is e.g., regarding "desired/requested" or "required" or "potentially 
             * useful / somehow related" or "used/produced/achieved". The 
             * reference property models the actual link to the attached piece 
             * of information. 
             */
            NEPOMUK_EXPORT QUrl Attachment();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#AttachmentRole 
             * 
             * AttachmentRoles further specify the type of how an attachment 
             * relates to a task. Example instances of AttachmentRoles are 
             * e.g. "desired_request", "required" and "used". 
             */
            NEPOMUK_EXPORT QUrl AttachmentRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#Delegability 
             */
            NEPOMUK_EXPORT QUrl Delegability();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#Importance 
             */
            NEPOMUK_EXPORT QUrl Importance();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#Interdependence 
             */
            NEPOMUK_EXPORT QUrl Interdependence();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#PersonInvolvement 
             * 
             * PersonInvolvement realizes n-ary associations to Persons 
             * which are realtedd to an task. The involvement is further characterized 
             * by an PersonTaskRole. 
             */
            NEPOMUK_EXPORT QUrl PersonInvolvement();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#PersonInvolvementRole 
             * 
             * They further specify the type a person was related to an task. 
             * Examples instances of AttachmentRoles are e.g. 
             */
            NEPOMUK_EXPORT QUrl PersonInvolvementRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#PredecessorDependency 
             * 
             * In a PredecessorDependency the dependencyMemberA is the task 
             * which is to be executed before dependencyMemberB. 
             */
            NEPOMUK_EXPORT QUrl PredecessorDependency();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#PredecessorSuccessorDependency 
             * 
             * The PredecessorSuccessorDependency enables a directed relation 
             * between task. By means of the concrete sublcasses one can further 
             * distinguish from which point of view this relation is created. 
             */
            NEPOMUK_EXPORT QUrl PredecessorSuccessorDependency();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#Priority 
             */
            NEPOMUK_EXPORT QUrl Priority();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#Role 
             * 
             * examples: Architect, Developer, ... 
             */
            NEPOMUK_EXPORT QUrl Role();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#SimilarityDependence 
             */
            NEPOMUK_EXPORT QUrl SimilarityDependence();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#Skill 
             * 
             * examples are e.g. technologies like Java, XML, ... 
             */
            NEPOMUK_EXPORT QUrl Skill();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#StateTypeRole 
             * 
             * StateTypeRole is an abstract class which subsumes various 
             * other classes which represent "states" or roles e.g. in role 
             * based modelling conpetualisations. 
             */
            NEPOMUK_EXPORT QUrl StateTypeRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#SuccessorDependency 
             * 
             * In a SuccessorrDependency the dependencyMemberA is the task 
             * which is to be executed after dependencyMemberB. 
             */
            NEPOMUK_EXPORT QUrl SuccessorDependency();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#SuperSubTaskDependency 
             * 
             * By means of the SuperSubTaskDependency one can further describe 
             * the subtask-supertask relation .e.g by an descriptin. This 
             * enables an n-ary relation between subtask and supertask. 
             */
            NEPOMUK_EXPORT QUrl SuperSubTaskDependency();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_AbilityCarrierRole_Requested 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_AbilityCarrierRole_Requested();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_AbilityCarrierRole_Required 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_AbilityCarrierRole_Required();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_AbilityCarrierRole_Used 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_AbilityCarrierRole_Used();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_AttachmentRole_Desired_Requested 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_AttachmentRole_Desired_Requested();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_AttachmentRole_Related 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_AttachmentRole_Related();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_AttachmentRole_Required 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_AttachmentRole_Required();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_AttachmentRole_Used 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_AttachmentRole_Used();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Delegability_High 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Delegability_High();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Delegability_Low 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Delegability_Low();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Delegability_Medium 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Delegability_Medium();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Delegability_Never 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Delegability_Never();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Delegability_Unrestricted 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Delegability_Unrestricted();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Importance_01 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Importance_01();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Importance_02 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Importance_02();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Importance_03 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Importance_03();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Importance_04 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Importance_04();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Importance_05 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Importance_05();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Importance_06 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Importance_06();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Importance_07 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Importance_07();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Importance_08 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Importance_08();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Importance_09 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Importance_09();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Importance_10 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Importance_10();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Analyst 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Analyst();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Co-worker 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Coworker();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Collaborator 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Collaborator();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Controller 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Controller();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Creator 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Creator();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Delegate 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Delegate();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Executor 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Executor();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_ExternalObserver 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_ExternalObserver();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Initiator 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Initiator();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_InternalObserver 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_InternalObserver();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Involved 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Involved();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Observer 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Observer();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Owner 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Owner();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Receiver 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Receiver();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Related 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Related();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Reviewer 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Reviewer();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_PersonInvolvementRole_Suggested 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_PersonInvolvementRole_Suggested();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Priority_High 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Priority_High();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Priority_Low 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Priority_Low();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Priority_Medium 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Priority_Medium();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskContainer_activetasks 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskContainer_activetasks();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskContainer_archive 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskContainer_archive();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskContainer_inbox 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskContainer_inbox();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskContainer_outbox 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskContainer_outbox();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskContainer_trashtasks 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskContainer_trashtasks();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskPrivacy_Private 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskPrivacy_Private();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskPrivacy_Professional 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskPrivacy_Professional();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskState_Archived 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskState_Archived();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskState_Completed 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskState_Completed();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskState_Deleted 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskState_Deleted();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskState_Finalized 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskState_Finalized();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskState_New 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskState_New();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskState_Running 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskState_Running();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskState_Suspended 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskState_Suspended();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TaskState_Terminated 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TaskState_Terminated();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TransmissionState_Accepted_NotTransmitted 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TransmissionState_Accepted_NotTransmitted();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TransmissionState_Accepted_Transmitted 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TransmissionState_Accepted_Transmitted();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TransmissionState_NotTransmitted 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TransmissionState_NotTransmitted();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TransmissionState_Rejected_NotTransmitted 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TransmissionState_Rejected_NotTransmitted();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TransmissionState_Rejected_Transmitted 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TransmissionState_Rejected_Transmitted();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TransmissionState_Transmitted 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TransmissionState_Transmitted();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TransmissionType_Delegation 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TransmissionType_Delegation();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TransmissionType_Join 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TransmissionType_Join();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_TransmissionType_Transfer 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_TransmissionType_Transfer();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Urgency_01 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Urgency_01();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Urgency_02 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Urgency_02();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Urgency_03 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Urgency_03();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Urgency_04 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Urgency_04();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Urgency_05 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Urgency_05();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Urgency_06 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Urgency_06();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Urgency_07 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Urgency_07();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Urgency_08 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Urgency_08();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Urgency_09 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Urgency_09();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TMO_Instance_Urgency_10 
             */
            NEPOMUK_EXPORT QUrl TMO_Instance_Urgency_10();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#Task 
             * 
             * The tmo:task is the central entitiey of the tmo. Task can range 
             * from vague things to be possibly done in e distant future to concrete 
             * things to be done in a precise forseeable manner. It is not unrealisitc 
             * to assume that knowledge worker have hundred or more tasks a 
             * day. 
             */
            NEPOMUK_EXPORT QUrl Task();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TaskContainer 
             */
            NEPOMUK_EXPORT QUrl TaskContainer();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TaskDependency 
             * 
             * Between the tasks, further dependencies may exist. These dependencies 
             * allow for a graph network structure. For ease of use, dependencies 
             * should not be too frequent, otherwise the primarily character 
             * of a hierarchy would be diminished and a consequent graph representation 
             * would become considerable. However, such a graph representation 
             * has other drawbacks, the user is likely to loose oversight, 
             * tree structures are more helpful in structuring the work. 
             * 
             * A dependency relation is characterized by the type of the relation 
             * and by an additional description. There are different possibilities 
             * for dependency relations between tasks. 
             */
            NEPOMUK_EXPORT QUrl TaskDependency();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TaskPrivacyState 
             * 
             * Privacy Status serves for the separation between a professional 
             * and a private purpose of a task. This attribute provides with 
             * the values "professional/private" a high-level separation 
             * of privacy in terms of setting distribution and access 
             * rights to other users for the task. 
             * This separation may arise as a general Nepomuk issue and may 
             * therefore be handled in conjunction with a privacy preserving 
             * SSD architecture. 
             */
            NEPOMUK_EXPORT QUrl TaskPrivacyState();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TaskState 
             * 
             * The task state property allows tracking a task during its lifecycle. 
             * Initially the state is just "created". 
             * The TaskState class was modeled so that for each state can be 
             * set which the typical prior and posterior states are. This has 
             * the advantage that e.g. a UI can retrieve the allowed states 
             * at runtime from the ontology; rather can having this potentially 
             * changing knowledge hard coded. But the prior and posterior 
             * states are only defaults; the human user is always free to change 
             * the state. 
             */
            NEPOMUK_EXPORT QUrl TaskState();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TaskTransmission 
             * 
             * On the SSD, tasks are not restricted to one person and may cross 
             * from 
             * the PTM of one person to the PTM of another. With transmission, 
             * we 
             * refer to the process of sending a task  from one person (sender) 
             * to one 
             * or more other persons (receiver(s)) (see Section 5.2.1.3 Task 
             * Transmission). Task delegation and task transfer are two special 
             * kinds of 
             * task transmission which are described at the end of this section. 
             * In 
             * addition, the collaborative task is realized by task transmission. 
             * For the process of sending a task, some information is required. 
             * This 
             * information is also modelled in the task ontology. This information 
             * is still 
             * useful after the process of sending a task was completed. Task 
             * Delegation is a process where the sender of the task restricts 
             * the 
             * access rights of the receiver. This includes the right to distribute 
             * further 
             * this task and additionally the obligation to give feedback 
             * to the sender. 
             * The person that receives a task by delegation usually has not 
             * the full 
             * control about the task. The attributes described in the following 
             * section 
             * have the purpose to enable such "access rights". The receiver 
             * will also 
             * probably have obligations regarding what to report to whom 
             * at which 
             * time. 
             * In contrast, the simplest case is that all rights are granted 
             * to the receiver 
             * and there is no feedback desired by the sender. What to do with 
             * the task 
             * may be apparent by the organization context, or it may be left 
             * to the 
             * receiver. This is like sending an email  but with the advantage 
             * that the 
             * information is transferred in the "task space" of the participating 
             * persons. 
             */
            NEPOMUK_EXPORT QUrl TaskTransmission();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TransmissionState 
             * 
             * States a task can go through during transmission of an task. 
             */
            NEPOMUK_EXPORT QUrl TransmissionState();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#TransmissionType 
             * 
             * By means of the TransmissionType one can distinguish several 
             * different types which might imply a different business logic. 
             * e.g. delegation can mean that the results of the task fulfillment 
             * care to be reported back to the sender of the task. 
             */
            NEPOMUK_EXPORT QUrl TransmissionType();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#UndirectedDependency 
             * 
             * A symmetric relations between task. 
             */
            NEPOMUK_EXPORT QUrl UndirectedDependency();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#Urgency 
             */
            NEPOMUK_EXPORT QUrl Urgency();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#abilityCarrier 
             */
            NEPOMUK_EXPORT QUrl abilityCarrier();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#abilityCarrierInvolvement 
             */
            NEPOMUK_EXPORT QUrl abilityCarrierInvolvement();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#abilityCarrierRole 
             */
            NEPOMUK_EXPORT QUrl abilityCarrierRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#abilityCarrierTask 
             */
            NEPOMUK_EXPORT QUrl abilityCarrierTask();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#actualCompletion 
             */
            NEPOMUK_EXPORT QUrl actualCompletion();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#actualEndTime 
             */
            NEPOMUK_EXPORT QUrl actualEndTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#actualStartTime 
             */
            NEPOMUK_EXPORT QUrl actualStartTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#actualTime 
             */
            NEPOMUK_EXPORT QUrl actualTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#attachment 
             * 
             * connects a Task with an Attachment object. Attachments are 
             * associations of Things. 
             */
            NEPOMUK_EXPORT QUrl attachment();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#attachmentReference 
             */
            NEPOMUK_EXPORT QUrl attachmentReference();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#attachmentRole 
             */
            NEPOMUK_EXPORT QUrl attachmentRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#attachmentTask 
             * 
             * Inverse of attachment, connects an Attachment Association 
             * to the associated Task. Is required for every instance of Attachment. 
             */
            NEPOMUK_EXPORT QUrl attachmentTask();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#containsTask 
             */
            NEPOMUK_EXPORT QUrl containsTask();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#contextTask 
             */
            NEPOMUK_EXPORT QUrl contextTask();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#contextThread 
             */
            NEPOMUK_EXPORT QUrl contextThread();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#createdBy 
             */
            NEPOMUK_EXPORT QUrl createdBy();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#dateTime 
             * 
             * dateTime subsumes various properties with Range XMLSchema:dateTime. 
             * If possible they are further grouped by "abstract" properties. 
             */
            NEPOMUK_EXPORT QUrl dateTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#delegability 
             */
            NEPOMUK_EXPORT QUrl delegability();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#dependency 
             */
            NEPOMUK_EXPORT QUrl dependency();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#dependencyDescription 
             * 
             * Endusers can clarify why they created a depedency. 
             */
            NEPOMUK_EXPORT QUrl dependencyDescription();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#dependencyMemberA 
             * 
             * The semantic of this relation is defined in the sublclass of 
             * undirected Dependency on which this property is stated. (The 
             * subject of the statment where this property is expressed) 
             */
            NEPOMUK_EXPORT QUrl dependencyMemberA();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#dependencyMemberB 
             * 
             * The semantic of this relation is defined in the sublclass of 
             * undirected Dependency on which this property is stated. (The 
             * subject of the statment where this property is expressed) 
             */
            NEPOMUK_EXPORT QUrl dependencyMemberB();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#dependencyOrderNumber 
             */
            NEPOMUK_EXPORT QUrl dependencyOrderNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#dependencyType 
             */
            NEPOMUK_EXPORT QUrl dependencyType();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#dueDate 
             */
            NEPOMUK_EXPORT QUrl dueDate();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#endTime 
             */
            NEPOMUK_EXPORT QUrl endTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#importance 
             */
            NEPOMUK_EXPORT QUrl importance();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#indexPosition 
             */
            NEPOMUK_EXPORT QUrl indexPosition();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#involvedPerson 
             */
            NEPOMUK_EXPORT QUrl involvedPerson();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#involvedPersonRole 
             */
            NEPOMUK_EXPORT QUrl involvedPersonRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#involvedPersonTask 
             */
            NEPOMUK_EXPORT QUrl involvedPersonTask();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#involvedPersons 
             */
            NEPOMUK_EXPORT QUrl involvedPersons();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#lastReviewDate 
             */
            NEPOMUK_EXPORT QUrl lastReviewDate();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#logEntry 
             */
            NEPOMUK_EXPORT QUrl logEntry();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#nextReviewIntervall 
             */
            NEPOMUK_EXPORT QUrl nextReviewIntervall();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#priority 
             */
            NEPOMUK_EXPORT QUrl priority();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#progress 
             */
            NEPOMUK_EXPORT QUrl progress();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#receiveDateTime 
             */
            NEPOMUK_EXPORT QUrl receiveDateTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#sendDateTime 
             */
            NEPOMUK_EXPORT QUrl sendDateTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#startTime 
             */
            NEPOMUK_EXPORT QUrl startTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#stateTypeRole 
             */
            NEPOMUK_EXPORT QUrl stateTypeRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#subTask 
             */
            NEPOMUK_EXPORT QUrl subTask();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#subTaskOrdering 
             * 
             * Ordering of the subtasks listed in the tmo:subTasks property 
             * of this Task. This is only for ordering/sorting in GUIs, the 
             * semantic relation is defined in subTasks, and if this and subTasks 
             * differ, subTasks is the correct list. 
             */
            NEPOMUK_EXPORT QUrl subTaskOrdering();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#superTask 
             */
            NEPOMUK_EXPORT QUrl superTask();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#targetCompletion 
             */
            NEPOMUK_EXPORT QUrl targetCompletion();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#targetEndTime 
             */
            NEPOMUK_EXPORT QUrl targetEndTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#targetStartTime 
             */
            NEPOMUK_EXPORT QUrl targetStartTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#targetTime 
             */
            NEPOMUK_EXPORT QUrl targetTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#taskDescription 
             * 
             * The task description helps users to understand the goal and 
             * the proceeding of a task. It can also describe the context of 
             * a task. The task description is composed at minimum of a summary 
             * of what is done to reach the goal. The task description is the 
             * main source for identifying related information, e.g., suitable 
             * patterns. 
             * A Task Description can be either an informal, described textual 
             * content (?TextualDescription) or it can be a more formally 
             * structured representation (FormalDescription). 
             * Technology considerations: Informal descriptions allow 
             * for text similarity processing, a formal description allows 
             * for applying case based similarity measures. 
             */
            NEPOMUK_EXPORT QUrl taskDescription();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#taskGoal 
             */
            NEPOMUK_EXPORT QUrl taskGoal();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#taskId 
             * 
             * The Task Identifier allows a unique identification of a task 
             * object within the range of all Nepomuk objects. 
             * The Task Identifier is automatically generated during the 
             * creation of a task. The generation of identifiers (IDs) is a 
             * Nepomuk architecture issue (Wp2000/WP6000). 
             */
            NEPOMUK_EXPORT QUrl taskId();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#taskName 
             * 
             * The Task Name helps the user to identify a task in a list. It should 
             * be expressive enough to give a meaningful recognition. Details 
             * should be written in the description attribute instead. A name 
             * attribute is not allowed to contain line breaks. 
             */
            NEPOMUK_EXPORT QUrl taskName();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#taskPrivacyState 
             * 
             * For the separation between professional and private purpose 
             * of a task, this attribute provides with the values "professional/private" 
             * a high level separation of privacy in terms of setting distribution 
             * rights to other users for the task. 
             * This separation may arise as a general Nepomuk issue and may 
             * therefore be handled in conjunction with a privacy preserving 
             * SSD architecture. 
             */
            NEPOMUK_EXPORT QUrl taskPrivacyState();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#taskReference 
             */
            NEPOMUK_EXPORT QUrl taskReference();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#taskSource 
             * 
             * here can be stated from which sources a task was derived. e.g 
             * from another task or from an task pattern 
             */
            NEPOMUK_EXPORT QUrl taskSource();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#taskState 
             * 
             * The task state describes the current state of the task as described 
             * in Section 5.2.7. 
             */
            NEPOMUK_EXPORT QUrl taskState();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#taskStateChangesFrom 
             */
            NEPOMUK_EXPORT QUrl taskStateChangesFrom();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#taskStateChangesTo 
             */
            NEPOMUK_EXPORT QUrl taskStateChangesTo();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#taskTransmission 
             */
            NEPOMUK_EXPORT QUrl taskTransmission();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#timemanagement 
             */
            NEPOMUK_EXPORT QUrl timemanagement();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#transmissionFrom 
             */
            NEPOMUK_EXPORT QUrl transmissionFrom();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#transmissionState 
             */
            NEPOMUK_EXPORT QUrl transmissionState();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#transmissionStateChangesFrom 
             */
            NEPOMUK_EXPORT QUrl transmissionStateChangesFrom();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#transmissionStateChangesTo 
             */
            NEPOMUK_EXPORT QUrl transmissionStateChangesTo();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#transmissionTask 
             */
            NEPOMUK_EXPORT QUrl transmissionTask();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#transmissionTo 
             */
            NEPOMUK_EXPORT QUrl transmissionTo();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#transmissionType 
             */
            NEPOMUK_EXPORT QUrl transmissionType();

            /**
             * http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#urgency 
             */
            NEPOMUK_EXPORT QUrl urgency();
        }
    }
}

#endif
