/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class InternalSingleBucketAggregation
extends InternalAggregation
implements SingleBucketAggregation {
    private long docCount;
    private InternalAggregations aggregations;

    protected InternalSingleBucketAggregation(String name, long docCount, InternalAggregations aggregations, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.docCount = docCount;
        this.aggregations = aggregations;
    }

    protected InternalSingleBucketAggregation(StreamInput in) throws IOException {
        super(in);
        this.docCount = in.readVLong();
        this.aggregations = new InternalAggregations(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVLong(this.docCount);
        this.aggregations.writeTo(out);
    }

    @Override
    public long getDocCount() {
        return this.docCount;
    }

    @Override
    public InternalAggregations getAggregations() {
        return this.aggregations;
    }

    public InternalSingleBucketAggregation create(InternalAggregations subAggregations) {
        return this.newAggregation(this.getName(), this.getDocCount(), subAggregations);
    }

    protected abstract InternalSingleBucketAggregation newAggregation(String var1, long var2, InternalAggregations var4);

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        long docCount = 0L;
        ArrayList<InternalAggregations> subAggregationsList = new ArrayList<InternalAggregations>(aggregations.size());
        for (InternalAggregation aggregation : aggregations) {
            assert (aggregation.getName().equals(this.getName()));
            docCount += ((InternalSingleBucketAggregation)aggregation).docCount;
            subAggregationsList.add(((InternalSingleBucketAggregation)aggregation).aggregations);
        }
        InternalAggregations aggs = InternalAggregations.reduce(subAggregationsList, reduceContext);
        return this.newAggregation(this.getName(), docCount, aggs);
    }

    @Override
    public final InternalAggregation reducePipelines(InternalAggregation reducedAggs, InternalAggregation.ReduceContext reduceContext) {
        assert (reduceContext.isFinalReduce());
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        for (Aggregation agg : this.getAggregations().asList()) {
            aggs.add(((InternalAggregation)agg).reducePipelines((InternalAggregation)agg, reduceContext));
        }
        InternalAggregations reducedSubAggs = new InternalAggregations((List<InternalAggregation>)aggs);
        return super.reducePipelines(this.create(reducedSubAggs), reduceContext);
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        String aggName = path.get(0);
        if (aggName.equals("_count")) {
            if (path.size() > 1) {
                throw new IllegalArgumentException("_count must be the last element in the path");
            }
            return this.getDocCount();
        }
        InternalAggregation aggregation = (InternalAggregation)this.aggregations.get(aggName);
        if (aggregation == null) {
            throw new IllegalArgumentException("Cannot find an aggregation named [" + aggName + "] in [" + this.getName() + "]");
        }
        return aggregation.getProperty(path.subList(1, path.size()));
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
        this.aggregations.toXContentInternal(builder, params);
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalSingleBucketAggregation other = (InternalSingleBucketAggregation)obj;
        return Objects.equals(this.docCount, other.docCount) && Objects.equals(this.aggregations, other.aggregations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.docCount, this.aggregations);
    }
}

