/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardContext;

public class RankFeatureMetaFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_feature";
    public static final String CONTENT_TYPE = "_feature";

    private RankFeatureMetaFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing.clone(), indexSettings);
    }

    private RankFeatureMetaFieldMapper(MappedFieldType fieldType, Settings indexSettings) {
        super("_feature", fieldType, Defaults.FIELD_TYPE, indexSettings);
    }

    public void preParse(ParseContext context) throws IOException {
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new AssertionError((Object)"Should never be called");
    }

    public void postParse(ParseContext context) throws IOException {
    }

    protected String contentType() {
        return "_feature";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new RankFeatureMetaFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_feature");
            FIELD_TYPE.freeze();
        }
    }

    public static final class RankFeatureMetaFieldType
    extends MappedFieldType {
        public RankFeatureMetaFieldType() {
        }

        protected RankFeatureMetaFieldType(RankFeatureMetaFieldType ref) {
            super((MappedFieldType)ref);
        }

        public RankFeatureMetaFieldType clone() {
            return new RankFeatureMetaFieldType(this);
        }

        public String typeName() {
            return "_feature";
        }

        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException("Cannot run exists query on [_feature]");
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new UnsupportedOperationException("The [_feature] field may not be queried directly");
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            return new Builder(parserContext.mapperService().fieldType("_feature"));
        }

        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            if (fieldType != null) {
                return new RankFeatureMetaFieldMapper(indexSettings, fieldType);
            }
            return (MetadataFieldMapper)this.parse("_feature", Collections.emptyMap(), context).build(new Mapper.BuilderContext(indexSettings, new ContentPath(1)));
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, RankFeatureMetaFieldMapper> {
        public Builder(MappedFieldType existing) {
            super("_feature", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
        }

        public RankFeatureMetaFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new RankFeatureMetaFieldMapper(this.fieldType, context.indexSettings());
        }
    }
}

