/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.rules.SystemPropertiesRestoreRule;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.util.ExternalPaths;
import org.apache.solr.util.RevertDefaultThreadHandlerRule;
import org.apache.solr.util.StartupLoggingUtils;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrTestCase
extends LuceneTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @ClassRule
    public static TestRule solrClassRules = RuleChain.outerRule((TestRule)new SystemPropertiesRestoreRule()).around((TestRule)new RevertDefaultThreadHandlerRule());

    @BeforeClass
    public static void setDefaultConfigDirSysPropIfNotSet() {
        String existingValue = System.getProperty("solr.default.confdir");
        if (null != existingValue) {
            log.info("Test env includes configset dir system property '{}'='{}'");
            return;
        }
        File extPath = new File(ExternalPaths.DEFAULT_CONFIGSET);
        if (extPath.canRead() && extPath.isDirectory()) {
            log.info("Setting '{}' system property to test-framework derived value of '{}'", (Object)"solr.default.confdir", (Object)ExternalPaths.DEFAULT_CONFIGSET);
            assert (null == existingValue);
            System.setProperty("solr.default.confdir", ExternalPaths.DEFAULT_CONFIGSET);
        } else {
            log.warn("System property '{}' is not already set, but test-framework derived value ('{}') either does not exist or is not a readable directory, you may need to set the property yourself for tests to run properly", (Object)"solr.default.confdir", (Object)ExternalPaths.DEFAULT_CONFIGSET);
        }
    }

    @BeforeClass
    public static void checkSyspropForceBeforeClassAssumptionFailure() {
        String PROP = "tests.force.assumption.failure.beforeclass";
        SolrTestCase.assumeFalse((String)"tests.force.assumption.failure.beforeclass == true", (boolean)RandomizedTest.systemPropertyAsBoolean((String)"tests.force.assumption.failure.beforeclass", (boolean)false));
    }

    @Before
    public void checkSyspropForceBeforeAssumptionFailure() {
        String PROP = "tests.force.assumption.failure.before";
        SolrTestCase.assumeFalse((String)"tests.force.assumption.failure.before == true", (boolean)RandomizedTest.systemPropertyAsBoolean((String)"tests.force.assumption.failure.before", (boolean)false));
    }

    @AfterClass
    public static void shutdownLogger() throws Exception {
        StartupLoggingUtils.shutdown();
    }
}

