/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesIterator;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PendingDeletes;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;

final class ReadersAndUpdates {
    final SegmentCommitInfo info;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private SegmentReader reader;
    private final PendingDeletes pendingDeletes;
    private final int indexCreatedVersionMajor;
    private boolean isMerging = false;
    private final Map<String, List<DocValuesFieldUpdates>> pendingDVUpdates = new HashMap<String, List<DocValuesFieldUpdates>>();
    private final Map<String, List<DocValuesFieldUpdates>> mergingDVUpdates = new HashMap<String, List<DocValuesFieldUpdates>>();
    Sorter.DocMap sortMap;
    final AtomicLong ramBytesUsed = new AtomicLong();
    private final Map<String, String> readerAttributes;

    ReadersAndUpdates(int indexCreatedVersionMajor, SegmentCommitInfo info, PendingDeletes pendingDeletes, Map<String, String> readerAttributes) {
        this.info = info;
        this.pendingDeletes = pendingDeletes;
        this.indexCreatedVersionMajor = indexCreatedVersionMajor;
        this.readerAttributes = readerAttributes;
    }

    ReadersAndUpdates(int indexCreatedVersionMajor, SegmentReader reader, PendingDeletes pendingDeletes, Map<String, String> readerAttributes) throws IOException {
        this(indexCreatedVersionMajor, reader.getOriginalSegmentInfo(), pendingDeletes, readerAttributes);
        this.reader = reader;
        pendingDeletes.onNewReader(reader, this.info);
    }

    public void incRef() {
        int rc = this.refCount.incrementAndGet();
        assert (rc > 1) : "seg=" + this.info;
    }

    public void decRef() {
        int rc = this.refCount.decrementAndGet();
        assert (rc >= 0) : "seg=" + this.info;
    }

    public int refCount() {
        int rc = this.refCount.get();
        assert (rc >= 0);
        return rc;
    }

    public synchronized int getDelCount() {
        return this.pendingDeletes.getDelCount();
    }

    private synchronized boolean assertNoDupGen(List<DocValuesFieldUpdates> fieldUpdates, DocValuesFieldUpdates update) {
        for (int i = 0; i < fieldUpdates.size(); ++i) {
            DocValuesFieldUpdates oldUpdate = fieldUpdates.get(i);
            if (oldUpdate.delGen == update.delGen) {
                throw new AssertionError((Object)("duplicate delGen=" + update.delGen + " for seg=" + this.info));
            }
        }
        return true;
    }

    public synchronized void addDVUpdate(DocValuesFieldUpdates update) throws IOException {
        if (!update.getFinished()) {
            throw new IllegalArgumentException("call finish first");
        }
        List<DocValuesFieldUpdates> fieldUpdates = this.pendingDVUpdates.computeIfAbsent(update.field, key -> new ArrayList());
        assert (this.assertNoDupGen(fieldUpdates, update));
        this.ramBytesUsed.addAndGet(update.ramBytesUsed());
        fieldUpdates.add(update);
        if (this.isMerging) {
            fieldUpdates = this.mergingDVUpdates.get(update.field);
            if (fieldUpdates == null) {
                fieldUpdates = new ArrayList<DocValuesFieldUpdates>();
                this.mergingDVUpdates.put(update.field, fieldUpdates);
            }
            fieldUpdates.add(update);
        }
    }

    public synchronized long getNumDVUpdates() {
        long count = 0L;
        for (List<DocValuesFieldUpdates> updates : this.pendingDVUpdates.values()) {
            count += (long)updates.size();
        }
        return count;
    }

    public synchronized SegmentReader getReader(IOContext context) throws IOException {
        if (this.reader == null) {
            this.reader = new SegmentReader(this.info, this.indexCreatedVersionMajor, true, context, this.readerAttributes);
            this.pendingDeletes.onNewReader(this.reader, this.info);
        }
        this.reader.incRef();
        return this.reader;
    }

    public synchronized void release(SegmentReader sr) throws IOException {
        assert (this.info == sr.getOriginalSegmentInfo());
        sr.decRef();
    }

    public synchronized boolean delete(int docID) throws IOException {
        if (this.reader == null && this.pendingDeletes.mustInitOnDelete()) {
            this.getReader(IOContext.READ).decRef();
        }
        return this.pendingDeletes.delete(docID);
    }

    public synchronized void dropReaders() throws IOException {
        if (this.reader != null) {
            try {
                this.reader.decRef();
            }
            finally {
                this.reader = null;
            }
        }
        this.decRef();
    }

    public synchronized SegmentReader getReadOnlyClone(IOContext context) throws IOException {
        Bits liveDocs;
        if (this.reader == null) {
            this.getReader(context).decRef();
            assert (this.reader != null);
        }
        if ((liveDocs = this.pendingDeletes.getLiveDocs()) != null) {
            return new SegmentReader(this.info, this.reader, liveDocs, this.pendingDeletes.getHardLiveDocs(), this.pendingDeletes.numDocs(), true);
        }
        assert (this.reader.getLiveDocs() == null);
        this.reader.incRef();
        return this.reader;
    }

    synchronized int numDeletesToMerge(MergePolicy policy) throws IOException {
        return this.pendingDeletes.numDeletesToMerge(policy, this::getLatestReader);
    }

    private synchronized CodecReader getLatestReader() throws IOException {
        if (this.reader == null) {
            this.getReader(IOContext.READ).decRef();
        }
        if (this.pendingDeletes.needsRefresh(this.reader)) {
            this.swapNewReaderWithLatestLiveDocs();
        }
        return this.reader;
    }

    public synchronized Bits getLiveDocs() {
        return this.pendingDeletes.getLiveDocs();
    }

    public synchronized Bits getHardLiveDocs() {
        return this.pendingDeletes.getHardLiveDocs();
    }

    public synchronized void dropChanges() {
        this.pendingDeletes.dropChanges();
        this.dropMergingUpdates();
    }

    public synchronized boolean writeLiveDocs(Directory dir) throws IOException {
        return this.pendingDeletes.writeLiveDocs(dir);
    }

    private synchronized void handleDVUpdates(FieldInfos infos, Directory dir, DocValuesFormat dvFormat, final SegmentReader reader, Map<Integer, Set<String>> fieldFiles, long maxDelGen, InfoStream infoStream) throws IOException {
        for (Map.Entry<String, List<DocValuesFieldUpdates>> ent : this.pendingDVUpdates.entrySet()) {
            final String field = ent.getKey();
            List<DocValuesFieldUpdates> updates = ent.getValue();
            DocValuesType type = updates.get((int)0).type;
            assert (type == DocValuesType.NUMERIC || type == DocValuesType.BINARY) : "unsupported type: " + (Object)((Object)type);
            ArrayList<DocValuesFieldUpdates> updatesToApply = new ArrayList<DocValuesFieldUpdates>();
            long bytes = 0L;
            for (DocValuesFieldUpdates update : updates) {
                if (update.delGen > maxDelGen) continue;
                bytes += update.ramBytesUsed();
                updatesToApply.add(update);
            }
            if (updatesToApply.isEmpty()) continue;
            if (infoStream.isEnabled("BD")) {
                infoStream.message("BD", String.format(Locale.ROOT, "now write %d pending numeric DV updates for field=%s, seg=%s, bytes=%.3f MB", updatesToApply.size(), field, this.info, (double)bytes / 1024.0 / 1024.0));
            }
            long nextDocValuesGen = this.info.getNextDocValuesGen();
            String segmentSuffix = Long.toString(nextDocValuesGen, 36);
            IOContext updatesContext = new IOContext(new FlushInfo(this.info.info.maxDoc(), bytes));
            final FieldInfo fieldInfo = infos.fieldInfo(field);
            assert (fieldInfo != null);
            fieldInfo.setDocValuesGen(nextDocValuesGen);
            FieldInfos fieldInfos = new FieldInfos(new FieldInfo[]{fieldInfo});
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
            SegmentWriteState state = new SegmentWriteState(null, trackingDir, this.info.info, fieldInfos, null, updatesContext, segmentSuffix);
            try (DocValuesConsumer fieldsConsumer = dvFormat.fieldsConsumer(state);){
                final Function<FieldInfo, DocValuesFieldUpdates.Iterator> updateSupplier = info -> {
                    if (info != fieldInfo) {
                        throw new IllegalArgumentException("expected field info for field: " + fieldInfo.name + " but got: " + info.name);
                    }
                    DocValuesFieldUpdates.Iterator[] subs = new DocValuesFieldUpdates.Iterator[updatesToApply.size()];
                    for (int i = 0; i < subs.length; ++i) {
                        subs[i] = ((DocValuesFieldUpdates)updatesToApply.get(i)).iterator();
                    }
                    return DocValuesFieldUpdates.mergedIterator(subs);
                };
                this.pendingDeletes.onDocValuesUpdate(fieldInfo, updateSupplier.apply(fieldInfo));
                if (type == DocValuesType.BINARY) {
                    fieldsConsumer.addBinaryField(fieldInfo, new EmptyDocValuesProducer(){

                        @Override
                        public BinaryDocValues getBinary(FieldInfo fieldInfoIn) throws IOException {
                            DocValuesFieldUpdates.Iterator iterator = (DocValuesFieldUpdates.Iterator)updateSupplier.apply(fieldInfo);
                            final MergedDocValues<BinaryDocValues> mergedDocValues = new MergedDocValues<BinaryDocValues>(reader.getBinaryDocValues(field), DocValuesFieldUpdates.Iterator.asBinaryDocValues(iterator), iterator);
                            return new BinaryDocValues(){

                                @Override
                                public BytesRef binaryValue() throws IOException {
                                    return ((BinaryDocValues)mergedDocValues.currentValuesSupplier).binaryValue();
                                }

                                @Override
                                public boolean advanceExact(int target) {
                                    return mergedDocValues.advanceExact(target);
                                }

                                @Override
                                public int docID() {
                                    return mergedDocValues.docID();
                                }

                                @Override
                                public int nextDoc() throws IOException {
                                    return mergedDocValues.nextDoc();
                                }

                                @Override
                                public int advance(int target) {
                                    return mergedDocValues.advance(target);
                                }

                                @Override
                                public long cost() {
                                    return mergedDocValues.cost();
                                }
                            };
                        }
                    });
                } else {
                    fieldsConsumer.addNumericField(fieldInfo, new EmptyDocValuesProducer(){

                        @Override
                        public NumericDocValues getNumeric(FieldInfo fieldInfoIn) throws IOException {
                            DocValuesFieldUpdates.Iterator iterator = (DocValuesFieldUpdates.Iterator)updateSupplier.apply(fieldInfo);
                            final MergedDocValues<NumericDocValues> mergedDocValues = new MergedDocValues<NumericDocValues>(reader.getNumericDocValues(field), DocValuesFieldUpdates.Iterator.asNumericDocValues(iterator), iterator);
                            return new NumericDocValues(){

                                @Override
                                public long longValue() throws IOException {
                                    return ((NumericDocValues)mergedDocValues.currentValuesSupplier).longValue();
                                }

                                @Override
                                public boolean advanceExact(int target) {
                                    return mergedDocValues.advanceExact(target);
                                }

                                @Override
                                public int docID() {
                                    return mergedDocValues.docID();
                                }

                                @Override
                                public int nextDoc() throws IOException {
                                    return mergedDocValues.nextDoc();
                                }

                                @Override
                                public int advance(int target) {
                                    return mergedDocValues.advance(target);
                                }

                                @Override
                                public long cost() {
                                    return mergedDocValues.cost();
                                }
                            };
                        }
                    });
                }
            }
            this.info.advanceDocValuesGen();
            assert (!fieldFiles.containsKey(fieldInfo.number));
            fieldFiles.put(fieldInfo.number, trackingDir.getCreatedFiles());
        }
    }

    private synchronized Set<String> writeFieldInfosGen(FieldInfos fieldInfos, Directory dir, FieldInfosFormat infosFormat) throws IOException {
        long nextFieldInfosGen = this.info.getNextFieldInfosGen();
        String segmentSuffix = Long.toString(nextFieldInfosGen, 36);
        long estInfosSize = 40 + 90 * fieldInfos.size();
        IOContext infosContext = new IOContext(new FlushInfo(this.info.info.maxDoc(), estInfosSize));
        TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
        infosFormat.write(trackingDir, this.info.info, segmentSuffix, fieldInfos, infosContext);
        this.info.advanceFieldInfosGen();
        return trackingDir.getCreatedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeFieldUpdates(Directory dir, FieldInfos.FieldNumbers fieldNumbers, long maxDelGen, InfoStream infoStream) throws IOException {
        Set<String> fieldInfosFiles;
        HashMap<Integer, Set<String>> newDVFiles;
        long startTimeNS;
        block29: {
            startTimeNS = System.nanoTime();
            newDVFiles = new HashMap<Integer, Set<String>>();
            fieldInfosFiles = null;
            FieldInfos fieldInfos = null;
            boolean any = false;
            block5: for (List<DocValuesFieldUpdates> updates : this.pendingDVUpdates.values()) {
                Collections.sort(updates, Comparator.comparingLong(a -> a.delGen));
                for (DocValuesFieldUpdates update : updates) {
                    if (update.delGen > maxDelGen || !update.any()) continue;
                    any = true;
                    continue block5;
                }
            }
            if (!any) {
                return false;
            }
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
            boolean success = false;
            try {
                SegmentReader reader;
                Codec codec = this.info.info.getCodec();
                if (this.reader == null) {
                    reader = new SegmentReader(this.info, this.indexCreatedVersionMajor, true, IOContext.READONCE, Collections.singletonMap("blocktree.terms.fst", BlockTreeTermsReader.FSTLoadMode.OFF_HEAP.name()));
                    this.pendingDeletes.onNewReader(reader, this.info);
                } else {
                    reader = this.reader;
                }
                try {
                    int maxFieldNumber = -1;
                    HashMap<String, FieldInfo> byName = new HashMap<String, FieldInfo>();
                    for (Object fi : reader.getFieldInfos()) {
                        byName.put(((FieldInfo)fi).name, this.cloneFieldInfo((FieldInfo)fi, ((FieldInfo)fi).number));
                        maxFieldNumber = Math.max(((FieldInfo)fi).number, maxFieldNumber);
                    }
                    FieldInfos.Builder builder = new FieldInfos.Builder(fieldNumbers);
                    for (List list : this.pendingDVUpdates.values()) {
                        FieldInfo fi;
                        DocValuesFieldUpdates update = (DocValuesFieldUpdates)list.get(0);
                        if (byName.containsKey(update.field)) {
                            fi = (FieldInfo)byName.get(update.field);
                            fi.setDocValuesType(update.type);
                            continue;
                        }
                        assert (fieldNumbers.contains(update.field, update.type));
                        fi = this.cloneFieldInfo(builder.getOrAdd(update.field), ++maxFieldNumber);
                        fi.setDocValuesType(update.type);
                        byName.put(fi.name, fi);
                    }
                    fieldInfos = new FieldInfos(byName.values().toArray(new FieldInfo[0]));
                    DocValuesFormat docValuesFormat = codec.docValuesFormat();
                    this.handleDVUpdates(fieldInfos, trackingDir, docValuesFormat, reader, newDVFiles, maxDelGen, infoStream);
                    fieldInfosFiles = this.writeFieldInfosGen(fieldInfos, trackingDir, codec.fieldInfosFormat());
                }
                finally {
                    if (reader != this.reader) {
                        reader.close();
                    }
                }
                success = true;
                if (success) break block29;
                this.info.advanceNextWriteFieldInfosGen();
                this.info.advanceNextWriteDocValuesGen();
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.info.advanceNextWriteFieldInfosGen();
                    this.info.advanceNextWriteDocValuesGen();
                    for (String fileName : trackingDir.getCreatedFiles()) {
                        IOUtils.deleteFilesIgnoringExceptions(dir, fileName);
                    }
                }
                throw throwable;
            }
            for (String fileName : trackingDir.getCreatedFiles()) {
                IOUtils.deleteFilesIgnoringExceptions(dir, fileName);
            }
        }
        long bytesFreed = 0L;
        Iterator<Map.Entry<String, List<DocValuesFieldUpdates>>> it = this.pendingDVUpdates.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<DocValuesFieldUpdates>> ent = it.next();
            int upto = 0;
            List<DocValuesFieldUpdates> updates = ent.getValue();
            for (DocValuesFieldUpdates update : updates) {
                if (update.delGen > maxDelGen) {
                    updates.set(upto, update);
                    ++upto;
                    continue;
                }
                bytesFreed += update.ramBytesUsed();
            }
            if (upto == 0) {
                it.remove();
                continue;
            }
            updates.subList(upto, updates.size()).clear();
        }
        long bytes = this.ramBytesUsed.addAndGet(-bytesFreed);
        assert (bytes >= 0L);
        if (this.reader != null) {
            this.swapNewReaderWithLatestLiveDocs();
        }
        assert (fieldInfosFiles != null);
        this.info.setFieldInfosFiles(fieldInfosFiles);
        assert (!newDVFiles.isEmpty());
        for (Map.Entry<Integer, Set<String>> entry : this.info.getDocValuesUpdatesFiles().entrySet()) {
            if (newDVFiles.containsKey(entry.getKey())) continue;
            newDVFiles.put(entry.getKey(), entry.getValue());
        }
        this.info.setDocValuesUpdatesFiles(newDVFiles);
        if (infoStream.isEnabled("BD")) {
            infoStream.message("BD", String.format(Locale.ROOT, "done write field updates for seg=%s; took %.3fs; new files: %s", this.info, (double)(System.nanoTime() - startTimeNS) / 1.0E9, newDVFiles));
        }
        return true;
    }

    private FieldInfo cloneFieldInfo(FieldInfo fi, int fieldNumber) {
        return new FieldInfo(fi.name, fieldNumber, fi.hasVectors(), fi.omitsNorms(), fi.hasPayloads(), fi.getIndexOptions(), fi.getDocValuesType(), fi.getDocValuesGen(), new HashMap<String, String>(fi.attributes()), fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes(), fi.isSoftDeletesField());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentReader createNewReaderWithLatestLiveDocs(SegmentReader reader) throws IOException {
        assert (reader != null);
        assert (Thread.holdsLock(this)) : Thread.currentThread().getName();
        SegmentReader newReader = new SegmentReader(this.info, reader, this.pendingDeletes.getLiveDocs(), this.pendingDeletes.getHardLiveDocs(), this.pendingDeletes.numDocs(), true);
        boolean success2 = false;
        try {
            this.pendingDeletes.onNewReader(newReader, this.info);
            reader.decRef();
            success2 = true;
        }
        finally {
            if (!success2) {
                newReader.decRef();
            }
        }
        return newReader;
    }

    private void swapNewReaderWithLatestLiveDocs() throws IOException {
        this.reader = this.createNewReaderWithLatestLiveDocs(this.reader);
    }

    synchronized void setIsMerging() {
        if (!this.isMerging) {
            this.isMerging = true;
            assert (this.mergingDVUpdates.isEmpty());
        }
    }

    synchronized boolean isMerging() {
        return this.isMerging;
    }

    synchronized MergeReader getReaderForMerge(IOContext context) throws IOException {
        for (Map.Entry<String, List<DocValuesFieldUpdates>> ent : this.pendingDVUpdates.entrySet()) {
            List<DocValuesFieldUpdates> mergingUpdates = this.mergingDVUpdates.get(ent.getKey());
            if (mergingUpdates == null) {
                mergingUpdates = new ArrayList<DocValuesFieldUpdates>();
                this.mergingDVUpdates.put(ent.getKey(), mergingUpdates);
            }
            mergingUpdates.addAll((Collection<DocValuesFieldUpdates>)ent.getValue());
        }
        SegmentReader reader = this.getReader(context);
        if (this.pendingDeletes.needsRefresh(reader)) {
            assert (this.pendingDeletes.getLiveDocs() != null);
            reader = this.createNewReaderWithLatestLiveDocs(reader);
        }
        assert (this.pendingDeletes.verifyDocCounts(reader));
        return new MergeReader(reader, this.pendingDeletes.getHardLiveDocs());
    }

    public synchronized void dropMergingUpdates() {
        this.mergingDVUpdates.clear();
        this.isMerging = false;
    }

    public synchronized Map<String, List<DocValuesFieldUpdates>> getMergingDVUpdates() {
        this.isMerging = false;
        return this.mergingDVUpdates;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReadersAndLiveDocs(seg=").append(this.info);
        sb.append(" pendingDeletes=").append(this.pendingDeletes);
        return sb.toString();
    }

    public synchronized boolean isFullyDeleted() throws IOException {
        return this.pendingDeletes.isFullyDeleted(this::getLatestReader);
    }

    boolean keepFullyDeletedSegment(MergePolicy mergePolicy) throws IOException {
        return mergePolicy.keepFullyDeletedSegment(this::getLatestReader);
    }

    static final class MergeReader {
        final SegmentReader reader;
        final Bits hardLiveDocs;

        MergeReader(SegmentReader reader, Bits hardLiveDocs) {
            this.reader = reader;
            this.hardLiveDocs = hardLiveDocs;
        }
    }

    static final class MergedDocValues<DocValuesInstance extends DocValuesIterator>
    extends DocValuesIterator {
        private final DocValuesFieldUpdates.Iterator updateIterator;
        private int docIDOut = -1;
        private int docIDOnDisk = -1;
        private int updateDocID = -1;
        private final DocValuesInstance onDiskDocValues;
        private final DocValuesInstance updateDocValues;
        DocValuesInstance currentValuesSupplier;

        protected MergedDocValues(DocValuesInstance onDiskDocValues, DocValuesInstance updateDocValues, DocValuesFieldUpdates.Iterator updateIterator) {
            this.onDiskDocValues = onDiskDocValues;
            this.updateDocValues = updateDocValues;
            this.updateIterator = updateIterator;
        }

        @Override
        public int docID() {
            return this.docIDOut;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return ((DocIdSetIterator)this.onDiskDocValues).cost();
        }

        @Override
        public int nextDoc() throws IOException {
            boolean hasValue = false;
            do {
                if (this.docIDOnDisk == this.docIDOut) {
                    this.docIDOnDisk = this.onDiskDocValues == null ? Integer.MAX_VALUE : ((DocIdSetIterator)this.onDiskDocValues).nextDoc();
                }
                if (this.updateDocID == this.docIDOut) {
                    this.updateDocID = ((DocIdSetIterator)this.updateDocValues).nextDoc();
                }
                if (this.docIDOnDisk < this.updateDocID) {
                    this.docIDOut = this.docIDOnDisk;
                    this.currentValuesSupplier = this.onDiskDocValues;
                    hasValue = true;
                    continue;
                }
                this.docIDOut = this.updateDocID;
                if (this.docIDOut != Integer.MAX_VALUE) {
                    this.currentValuesSupplier = this.updateDocValues;
                    hasValue = this.updateIterator.hasValue();
                    continue;
                }
                hasValue = true;
            } while (!hasValue);
            return this.docIDOut;
        }
    }
}

