/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.idversion;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.codecs.idversion.IDVersionSegmentTermsEnum;
import org.apache.lucene.codecs.idversion.VersionBlockTreeTermsReader;
import org.apache.lucene.codecs.idversion.VersionBlockTreeTermsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PairOutputs;

final class VersionFieldReader
extends Terms
implements Accountable {
    final long numTerms;
    final FieldInfo fieldInfo;
    final long sumTotalTermFreq;
    final long sumDocFreq;
    final int docCount;
    final long indexStartFP;
    final long rootBlockFP;
    final PairOutputs.Pair<BytesRef, Long> rootCode;
    final BytesRef minTerm;
    final BytesRef maxTerm;
    final VersionBlockTreeTermsReader parent;
    final FST<PairOutputs.Pair<BytesRef, Long>> index;

    VersionFieldReader(VersionBlockTreeTermsReader parent, FieldInfo fieldInfo, long numTerms, PairOutputs.Pair<BytesRef, Long> rootCode, long sumTotalTermFreq, long sumDocFreq, int docCount, long indexStartFP, IndexInput indexIn, BytesRef minTerm, BytesRef maxTerm) throws IOException {
        assert (numTerms > 0L);
        this.fieldInfo = fieldInfo;
        this.parent = parent;
        this.numTerms = numTerms;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.sumDocFreq = sumDocFreq;
        this.docCount = docCount;
        this.indexStartFP = indexStartFP;
        this.rootCode = rootCode;
        this.minTerm = minTerm;
        this.maxTerm = maxTerm;
        this.rootBlockFP = new ByteArrayDataInput(((BytesRef)rootCode.output1).bytes, ((BytesRef)rootCode.output1).offset, ((BytesRef)rootCode.output1).length).readVLong() >>> 2;
        if (indexIn != null) {
            IndexInput clone = indexIn.clone();
            clone.seek(indexStartFP);
            this.index = new FST((DataInput)clone, VersionBlockTreeTermsWriter.FST_OUTPUTS);
        } else {
            this.index = null;
        }
    }

    public BytesRef getMin() throws IOException {
        if (this.minTerm == null) {
            return super.getMin();
        }
        return this.minTerm;
    }

    public BytesRef getMax() throws IOException {
        if (this.maxTerm == null) {
            return super.getMax();
        }
        return this.maxTerm;
    }

    public boolean hasFreqs() {
        return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
    }

    public boolean hasOffsets() {
        return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    public boolean hasPositions() {
        return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    public boolean hasPayloads() {
        return this.fieldInfo.hasPayloads();
    }

    public TermsEnum iterator() throws IOException {
        return new IDVersionSegmentTermsEnum(this);
    }

    public long size() {
        return this.numTerms;
    }

    public long getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    public long getSumDocFreq() {
        return this.sumDocFreq;
    }

    public int getDocCount() {
        return this.docCount;
    }

    public long ramBytesUsed() {
        return this.index != null ? this.index.ramBytesUsed() : 0L;
    }

    public Collection<Accountable> getChildResources() {
        if (this.index == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Accountables.namedAccountable((String)"term index", this.index));
    }

    public String toString() {
        return "IDVersionTerms(terms=" + this.numTerms + ",postings=" + this.sumDocFreq + ",positions=" + this.sumTotalTermFreq + ",docs=" + this.docCount + ")";
    }
}

