/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.JoinQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.TopLevelJoinQuery;
import org.apache.solr.search.join.ScoreJoinQParserPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinQParserPlugin
extends QParserPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String NAME = "join";
    private static final String METHOD = "method";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            @Override
            public Query parse() throws SyntaxError {
                if (this.localParams != null && this.localParams.get(JoinQParserPlugin.METHOD) != null) {
                    Method explicitMethod = Method.valueOf(this.localParams.get(JoinQParserPlugin.METHOD));
                    return explicitMethod.makeFilter(this);
                }
                if (this.localParams != null && this.localParams.get("score") != null) {
                    return new ScoreJoinQParserPlugin().createParser(this.qstr, this.localParams, this.params, this.req).parse();
                }
                return Method.index.makeFilter(this);
            }
        };
    }

    public static Query createJoinQuery(Query subQuery, String fromField, String toField) {
        return new JoinQuery(fromField, toField, null, subQuery);
    }

    private static enum Method {
        index{

            @Override
            Query makeFilter(QParser qparser) throws SyntaxError {
                JoinParams jParams = this.parseJoin(qparser);
                JoinQuery q = new JoinQuery(jParams.fromField, jParams.toField, jParams.fromCore, jParams.fromQuery);
                q.fromCoreOpenTime = jParams.fromCoreOpenTime;
                return q;
            }
        }
        ,
        dvWithScore{

            @Override
            Query makeFilter(QParser qparser) throws SyntaxError {
                return new ScoreJoinQParserPlugin().createParser(qparser.qstr, qparser.localParams, qparser.params, qparser.req).parse();
            }
        }
        ,
        topLevelDV{

            @Override
            Query makeFilter(QParser qparser) throws SyntaxError {
                JoinParams jParams = this.parseJoin(qparser);
                TopLevelJoinQuery q = new TopLevelJoinQuery(jParams.fromField, jParams.toField, jParams.fromCore, jParams.fromQuery);
                q.fromCoreOpenTime = jParams.fromCoreOpenTime;
                return q;
            }
        };


        abstract Query makeFilter(QParser var1) throws SyntaxError;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        JoinParams parseJoin(QParser qparser) throws SyntaxError {
            fromField = qparser.getParam("from");
            fromIndex = qparser.getParam("fromIndex");
            toField = qparser.getParam("to");
            v = qparser.localParams.get("v");
            fromCoreOpenTime = 0L;
            if (fromIndex != null && !fromIndex.equals(qparser.req.getCore().getCoreDescriptor().getName())) {
                container = qparser.req.getCore().getCoreContainer();
                fromCore = container.getCore(coreName = ScoreJoinQParserPlugin.getCoreName(fromIndex, container));
                if (fromCore == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core join: no such core " + coreName);
                }
                fromHolder = null;
                otherReq = new LocalSolrQueryRequest(fromCore, qparser.params);
                try {
                    parser = QParser.getParser(v, otherReq);
                    fromQuery = parser.getQuery();
                    fromHolder = fromCore.getRegisteredSearcher();
                    if (fromHolder == null) ** GOTO lbl30
                    fromCoreOpenTime = fromHolder.get().getOpenNanoTime();
                }
                finally {
                    otherReq.close();
                    fromCore.close();
                    if (fromHolder != null) {
                        fromHolder.decref();
                    }
                }
            } else {
                coreName = null;
                fromQueryParser = qparser.subQuery(v, null);
                fromQueryParser.setIsFilter(true);
                fromQuery = fromQueryParser.getQuery();
            }
lbl30:
            // 3 sources

            indexToUse = coreName == null ? fromIndex : coreName;
            return new JoinParams(fromField, indexToUse, fromQuery, fromCoreOpenTime, toField);
        }
    }

    private static class JoinParams {
        final String fromField;
        final String fromCore;
        final Query fromQuery;
        final long fromCoreOpenTime;
        final String toField;

        public JoinParams(String fromField, String fromCore, Query fromQuery, long fromCoreOpenTime, String toField) {
            this.fromField = fromField;
            this.fromCore = fromCore;
            this.fromQuery = fromQuery;
            this.fromCoreOpenTime = fromCoreOpenTime;
            this.toField = toField;
        }
    }
}

