/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.LittleEndian;

public final class ExControlAtom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private int _id;

    protected ExControlAtom() {
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)4);
    }

    protected ExControlAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._id = LittleEndian.getInt((byte[])source, (int)(start + 8));
    }

    public int getSlideId() {
        return this._id;
    }

    public void setSlideId(int id) {
        this._id = id;
    }

    @Override
    public long getRecordType() {
        return RecordTypes.ExControlAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        byte[] data = new byte[4];
        LittleEndian.putInt((byte[])data, (int)0, (int)this._id);
        out.write(data);
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties((String)"slideId", this::getSlideId);
    }
}

