/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.model;

import com.github.cereda.arara.controller.ConfigurationController;
import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Conditional;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.utils.CommonUtils;
import com.github.cereda.arara.utils.Methods;
import java.util.HashMap;
import org.mvel2.templates.TemplateRuntime;

public class Evaluator {
    private final long loops = (Long)ConfigurationController.getInstance().get("execution.loops");
    private long counter = 0L;
    private boolean halt = false;
    private static final LanguageController messages = LanguageController.getInstance();

    public boolean evaluate(Conditional conditional) throws AraraException {
        if (((Boolean)ConfigurationController.getInstance().get("execution.dryrun")).booleanValue()) {
            return false;
        }
        switch (conditional.getType()) {
            case NONE: {
                return false;
            }
            case IF: 
            case UNLESS: {
                if (!this.halt) {
                    this.halt = true;
                    break;
                }
                return false;
            }
        }
        ++this.counter;
        if (conditional.getType() == Conditional.ConditionalType.WHILE && this.counter > this.loops || conditional.getType() == Conditional.ConditionalType.UNTIL && this.counter >= this.loops) {
            return false;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        Methods.addConditionalMethods(context);
        try {
            Object result = TemplateRuntime.eval("@{ ".concat(conditional.getCondition()).concat(" }"), context);
            if (!CommonUtils.checkClass(Boolean.class, result)) {
                throw new AraraException(messages.getMessage(Messages.ERROR_EVALUATE_NOT_BOOLEAN_VALUE));
            }
            boolean value = (Boolean)result;
            switch (conditional.getType()) {
                case UNLESS: 
                case UNTIL: {
                    value = !value;
                }
            }
            return value;
        }
        catch (RuntimeException exception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_EVALUATE_COMPILATION_FAILED), exception);
        }
    }
}

