/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.utils;

import com.github.cereda.arara.controller.ConfigurationController;
import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.controller.SystemCallController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Argument;
import com.github.cereda.arara.model.Database;
import com.github.cereda.arara.model.FileType;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.utils.DatabaseUtils;
import com.github.cereda.arara.utils.InterpreterUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonUtils {
    private static final LanguageController messages = LanguageController.getInstance();

    public static boolean checkBoolean(String value) throws AraraException {
        List<String> yes = Arrays.asList("yes", "true", "1", "on");
        List<String> no = Arrays.asList("no", "false", "0", "off");
        if (!CommonUtils.union(yes, no).contains(value.toLowerCase())) {
            throw new AraraException(messages.getMessage(Messages.ERROR_CHECKBOOLEAN_NOT_VALID_BOOLEAN, value));
        }
        return yes.contains(value.toLowerCase());
    }

    private static <T> List<T> union(List<T> list1, List<T> list2) {
        HashSet<T> elements = new HashSet<T>();
        elements.addAll(list1);
        elements.addAll(list2);
        return new ArrayList(elements);
    }

    public static String buildPath(String path, String file) {
        return path.endsWith(File.separator) ? path.concat(file) : path.concat(File.separator).concat(file);
    }

    public static boolean checkEmptyString(String string) {
        return "".equals(string);
    }

    public static String removeKeyword(String line) {
        if (line != null) {
            Pattern pattern = Pattern.compile("^(\\s)*<arara>\\s");
            Matcher matcher = pattern.matcher(line);
            if (matcher.find()) {
                line = line.substring(matcher.end(), line.length());
            }
            line = line.trim();
        }
        return line;
    }

    public static void discoverFile(String reference) throws AraraException {
        File file = CommonUtils.lookupFile(reference);
        if (file == null) {
            throw new AraraException(messages.getMessage(Messages.ERROR_DISCOVERFILE_FILE_NOT_FOUND, reference, CommonUtils.getFileTypesList()));
        }
    }

    private static File lookupFile(String reference) throws AraraException {
        List types = (List)ConfigurationController.getInstance().get("execution.filetypes");
        File file = new File(reference);
        String name = file.getName();
        String parent = CommonUtils.getParentCanonicalPath(file);
        String path = CommonUtils.buildPath(parent, name);
        for (FileType type : types) {
            if (!path.endsWith(".".concat(type.getExtension())) || !(file = new File(path)).exists() || !file.isFile()) continue;
            ConfigurationController.getInstance().put("execution.file.pattern", type.getPattern());
            ConfigurationController.getInstance().put("execution.reference", file);
            return file;
        }
        for (FileType type : types) {
            path = CommonUtils.buildPath(parent, name.concat(".").concat(type.getExtension()));
            file = new File(path);
            if (!file.exists() || !file.isFile()) continue;
            ConfigurationController.getInstance().put("execution.file.pattern", type.getPattern());
            ConfigurationController.getInstance().put("execution.reference", file);
            return file;
        }
        return null;
    }

    public static String getParentCanonicalPath(File file) throws AraraException {
        try {
            String path = file.getCanonicalFile().getParent();
            return path;
        }
        catch (IOException exception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_GETPARENTCANONICALPATH_IO_EXCEPTION), exception);
        }
    }

    public static File getCanonicalFile(String file) throws AraraException {
        try {
            return new File(file).getCanonicalFile();
        }
        catch (IOException exception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_GETCANONICALFILE_IO_EXCEPTION), exception);
        }
    }

    public static boolean checkClass(Class clazz, Object object) {
        return clazz.isInstance(object);
    }

    private static void flatten(List<?> list, List<Object> flat) {
        for (Object item : list) {
            if (item instanceof List) {
                CommonUtils.flatten((List)item, flat);
                continue;
            }
            flat.add(item);
        }
    }

    public static List<Object> flatten(List<?> list) {
        ArrayList<Object> result = new ArrayList<Object>();
        CommonUtils.flatten(list, result);
        return result;
    }

    public static String getFileTypesList() {
        List types = (List)ConfigurationController.getInstance().get("execution.filetypes");
        return CommonUtils.getCollectionElements(types, "[ ", " ]", " | ");
    }

    public static String getCollectionElements(Collection collection, String open, String close, String separator) {
        StringBuilder builder = new StringBuilder();
        builder.append(open);
        builder.append(StringUtils.join(collection, separator));
        builder.append(close);
        return builder.toString();
    }

    public static Set<String> getUnknownKeys(Map<String, Object> parameters, List<Argument> arguments) {
        Set<String> found = parameters.keySet();
        Collection<String> expected = CollectionUtils.collect(arguments, new Transformer<Argument, String>(){

            @Override
            public String transform(Argument argument) {
                return argument.getIdentifier();
            }
        });
        Collection<String> difference = CollectionUtils.subtract(found, expected);
        return new HashSet<String>(difference);
    }

    public static String getRuleErrorHeader() {
        if (ConfigurationController.getInstance().contains("execution.info.rule.id") && ConfigurationController.getInstance().contains("execution.info.rule.path")) {
            String id = (String)ConfigurationController.getInstance().get("execution.info.rule.id");
            String path = (String)ConfigurationController.getInstance().get("execution.info.rule.path");
            return messages.getMessage(Messages.ERROR_RULE_IDENTIFIER_AND_PATH, id, path).concat(" ");
        }
        return "";
    }

    public static List<String> trimSpaces(List<String> input) {
        Collection<String> result = CollectionUtils.collect(input, new Transformer<String, String>(){

            @Override
            public String transform(String input) {
                return input.trim();
            }
        });
        return new ArrayList<String>(result);
    }

    public static String calculateFileSize(File file) {
        return FileUtils.byteCountToDisplaySize(file.length());
    }

    public static String getLastModifiedInformation(File file) {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return format.format(file.lastModified());
    }

    public static List<String> getAllRulePaths() throws AraraException {
        List paths = (List)ConfigurationController.getInstance().get("execution.rule.paths");
        ArrayList<String> result = new ArrayList<String>();
        for (String path : paths) {
            File location = new File(InterpreterUtils.construct(path, "quack"));
            result.add(CommonUtils.getParentCanonicalPath(location));
        }
        return result;
    }

    private static File getCurrentReference() {
        return (File)ConfigurationController.getInstance().get("execution.file");
    }

    public static String calculateHash(File file) throws AraraException {
        try {
            long result = FileUtils.checksumCRC32(file);
            return String.format("%08x", result);
        }
        catch (IOException exception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_CALCULATEHASH_IO_EXCEPTION), exception);
        }
    }

    public static String getFiletype(File file) {
        return CommonUtils.getFiletype(file.getName());
    }

    public static String getFiletype(String name) {
        name = name.lastIndexOf(".") != -1 ? name.substring(name.lastIndexOf(".") + 1, name.length()) : "";
        return name;
    }

    public static String getBasename(File file) {
        return CommonUtils.getBasename(file.getName());
    }

    public static String getBasename(String name) {
        int index = name.lastIndexOf(".") != -1 ? name.lastIndexOf(".") : name.length();
        return name.substring(0, index);
    }

    public static String addQuotes(Object object) {
        return "\"".concat(String.valueOf(object)).concat("\"");
    }

    public static String generateString(Object ... objects) {
        ArrayList<String> values = new ArrayList<String>();
        for (Object object : objects) {
            if (CommonUtils.checkEmptyString(String.valueOf(object))) continue;
            values.add(String.valueOf(object));
        }
        return StringUtils.join(values, " ");
    }

    public static boolean exists(File file) {
        return file.exists();
    }

    public static boolean exists(String extension) throws AraraException {
        File file = new File(CommonUtils.getPath(extension));
        return file.exists();
    }

    public static boolean hasChanged(File file) throws AraraException {
        Database database = DatabaseUtils.load();
        HashMap<String, String> map = database.getMap();
        String path = CommonUtils.getCanonicalPath(file);
        if (!file.exists()) {
            if (map.containsKey(path)) {
                map.remove(path);
                database.setMap(map);
                DatabaseUtils.save(database);
                return true;
            }
            return false;
        }
        String hash = CommonUtils.calculateHash(file);
        if (map.containsKey(path)) {
            String value = map.get(path);
            if (hash.equals(value)) {
                return false;
            }
            map.put(path, hash);
            database.setMap(map);
            DatabaseUtils.save(database);
            return true;
        }
        map.put(path, hash);
        database.setMap(map);
        DatabaseUtils.save(database);
        return true;
    }

    public static boolean hasChanged(String extension) throws AraraException {
        File file = new File(CommonUtils.getPath(extension));
        return CommonUtils.hasChanged(file);
    }

    private static String getPath(String extension) throws AraraException {
        String name = CommonUtils.getBasename(CommonUtils.getCurrentReference());
        String path = CommonUtils.getParentCanonicalPath(CommonUtils.getCurrentReference());
        name = name.concat(".").concat(extension);
        return CommonUtils.buildPath(path, name);
    }

    public static String getCanonicalPath(File file) throws AraraException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException exception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_GETCANONICALPATH_IO_EXCEPTION), exception);
        }
    }

    public static boolean checkRegex(String extension, String regex) throws AraraException {
        File file = new File(CommonUtils.getPath(extension));
        return CommonUtils.checkRegex(file, regex);
    }

    public static boolean checkRegex(File file, String regex) throws AraraException {
        Charset charset = (Charset)ConfigurationController.getInstance().get("directives.charset");
        try {
            String text = FileUtils.readFileToString(file, charset.name());
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(text);
            return matcher.find();
        }
        catch (IOException exception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_CHECKREGEX_IO_EXCEPTION, file.getName()), exception);
        }
    }

    public static List<Object> replicateList(String pattern, List<Object> values) throws AraraException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : values) {
            try {
                result.add(String.format(pattern, value));
            }
            catch (MissingFormatArgumentException exception) {
                throw new AraraException(messages.getMessage(Messages.ERROR_REPLICATELIST_MISSING_FORMAT_ARGUMENTS_EXCEPTION), exception);
            }
        }
        return result;
    }

    public static boolean checkOS(String value) throws AraraException {
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("windows", SystemUtils.IS_OS_WINDOWS);
        values.put("linux", SystemUtils.IS_OS_LINUX);
        values.put("mac", SystemUtils.IS_OS_MAC_OSX);
        values.put("unix", SystemUtils.IS_OS_UNIX);
        values.put("aix", SystemUtils.IS_OS_AIX);
        values.put("irix", SystemUtils.IS_OS_IRIX);
        values.put("os2", SystemUtils.IS_OS_OS2);
        values.put("solaris", SystemUtils.IS_OS_SOLARIS);
        values.put("cygwin", (Boolean)SystemCallController.getInstance().get("cygwin"));
        if (!values.containsKey(value.toLowerCase())) {
            throw new AraraException(messages.getMessage(Messages.ERROR_CHECKOS_INVALID_OPERATING_SYSTEM, value));
        }
        return (Boolean)values.get(value.toLowerCase());
    }

    public static int getExitStatus() {
        return (Integer)ConfigurationController.getInstance().get("execution.status");
    }

    public static String getSystemProperty(String key, String fallback) {
        try {
            String result = System.getProperty(key, fallback);
            return result.equals("") ? fallback : result;
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static List<String> getPreambleContent() {
        if (((Boolean)ConfigurationController.getInstance().get("execution.preamble.active")).booleanValue()) {
            return new ArrayList<String>(Arrays.asList(((String)ConfigurationController.getInstance().get("execution.preamble.content")).split("\n")));
        }
        return new ArrayList<String>();
    }

    private static List<String> appendExtensions(String command) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> extensions = SystemUtils.IS_OS_WINDOWS ? Arrays.asList(".com", ".exe", ".bat", ".cmd") : Arrays.asList("");
        for (String extension : extensions) {
            result.add(command.concat(extension));
        }
        return result;
    }

    public static boolean isOnPath(String command) {
        try {
            List<String> filenames = CommonUtils.appendExtensions(command);
            StringTokenizer tokenizer = new StringTokenizer(System.getenv("PATH"), File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                if (FileUtils.listFiles(new File(tokenizer.nextToken()), new NameFileFilter(filenames), null).isEmpty()) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getFullBasename(File file) throws AraraException {
        if (!file.toString().contains(File.separator)) {
            return CommonUtils.getBasename(file);
        }
        File parent = file.getParentFile();
        String path = CommonUtils.getCanonicalPath(parent == null ? file : parent);
        return CommonUtils.buildPath(path, CommonUtils.getBasename(file));
    }
}

