/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.proxy;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.spdy.api.GoAwayResultInfo;
import org.eclipse.jetty.spdy.api.PingResultInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.api.server.ServerSessionFrameListener;
import org.eclipse.jetty.spdy.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.server.proxy.ProxyEngine;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ProxyEngineSelector
extends ServerSessionFrameListener.Adapter {
    protected final Logger LOG = Log.getLogger(this.getClass());
    private final Map<String, ProxyServerInfo> proxyInfos = new ConcurrentHashMap<String, ProxyServerInfo>();
    private final Map<String, ProxyEngine> proxyEngines = new ConcurrentHashMap<String, ProxyEngine>();

    @Override
    public final StreamFrameListener onSyn(Stream clientStream, SynInfo clientSynInfo) {
        ProxyServerInfo proxyServerInfo;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("C -> P {} on {}", clientSynInfo, clientStream);
        }
        Session clientSession = clientStream.getSession();
        short clientVersion = clientSession.getVersion();
        Fields headers = new Fields(clientSynInfo.getHeaders(), false);
        Fields.Field hostHeader = headers.get(HTTPSPDYHeader.HOST.name(clientVersion));
        if (hostHeader == null) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("No host header found: " + headers, new Object[0]);
            }
            this.rst(clientStream);
            return null;
        }
        String host = hostHeader.getValue();
        int colon = host.indexOf(58);
        if (colon >= 0) {
            host = host.substring(0, colon);
        }
        if ((proxyServerInfo = this.getProxyServerInfo(host)) == null) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("No matching ProxyServerInfo found for: " + host, new Object[0]);
            }
            this.rst(clientStream);
            return null;
        }
        String protocol = proxyServerInfo.getProtocol();
        ProxyEngine proxyEngine = this.proxyEngines.get(protocol);
        if (proxyEngine == null) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("No matching ProxyEngine found for: " + protocol, new Object[0]);
            }
            this.rst(clientStream);
            return null;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Forwarding request: {} -> {}", clientSynInfo, proxyServerInfo);
        }
        return proxyEngine.proxy(clientStream, clientSynInfo, proxyServerInfo);
    }

    @Override
    public void onPing(Session clientSession, PingResultInfo pingResultInfo) {
    }

    @Override
    public void onGoAway(Session session, GoAwayResultInfo goAwayResultInfo) {
    }

    public Map<String, ProxyEngine> getProxyEngines() {
        return new HashMap<String, ProxyEngine>(this.proxyEngines);
    }

    public void setProxyEngines(Map<String, ProxyEngine> proxyEngines) {
        this.proxyEngines.clear();
        this.proxyEngines.putAll(proxyEngines);
    }

    public ProxyEngine getProxyEngine(String protocol) {
        return this.proxyEngines.get(protocol);
    }

    public void putProxyEngine(String protocol, ProxyEngine proxyEngine) {
        this.proxyEngines.put(protocol, proxyEngine);
    }

    public Map<String, ProxyServerInfo> getProxyServerInfos() {
        return new HashMap<String, ProxyServerInfo>(this.proxyInfos);
    }

    protected ProxyServerInfo getProxyServerInfo(String host) {
        return this.proxyInfos.get(host);
    }

    public void setProxyServerInfos(Map<String, ProxyServerInfo> proxyServerInfos) {
        this.proxyInfos.clear();
        this.proxyInfos.putAll(proxyServerInfos);
    }

    public void putProxyServerInfo(String host, ProxyServerInfo proxyServerInfo) {
        this.proxyInfos.put(host, proxyServerInfo);
    }

    private void rst(Stream stream) {
        RstInfo rstInfo = new RstInfo(stream.getId(), StreamStatus.REFUSED_STREAM);
        stream.getSession().rst(rstInfo, Callback.Adapter.INSTANCE);
    }

    public static class ProxyServerInfo {
        private final String protocol;
        private final String host;
        private final InetSocketAddress address;

        public ProxyServerInfo(String protocol, String host, int port) {
            this.protocol = protocol;
            this.host = host;
            this.address = new InetSocketAddress(host, port);
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getHost() {
            return this.host;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public String toString() {
            return "ProxyServerInfo{protocol='" + this.protocol + '\'' + ", host='" + this.host + '\'' + ", address=" + this.address + '}';
        }
    }
}

