/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.internal;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.ClippingTextField;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.fieldpanel.support.HighlightFactory;
import docking.widgets.fieldpanel.support.SingleRowLayout;
import docking.widgets.indexedscrollpane.IndexedScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;

public class TestBigLayoutModel
implements LayoutModel {
    private static final Highlight[] NO_HIGHLIGHTS = new Highlight[0];
    private static final HighlightFactory hlFactory = (field, text, cursorTextOffset) -> NO_HIGHLIGHTS;
    ArrayList<LayoutModelListener> listeners = new ArrayList();
    FontMetrics fm;
    BigInteger numIndexes = BigInteger.valueOf(55L);
    private final String name;
    private int startBigSizes = 0;
    private int endBigSizes = -1;

    public TestBigLayoutModel(FontMetrics fm, String name, BigInteger numIndexes) {
        this.fm = fm;
        this.name = name;
        this.numIndexes = numIndexes;
    }

    public void setNumIndexes(BigInteger n) {
        this.numIndexes = n;
        for (LayoutModelListener listener : this.listeners) {
            listener.modelSizeChanged();
        }
    }

    @Override
    public boolean isUniform() {
        return false;
    }

    @Override
    public Dimension getPreferredViewSize() {
        return new Dimension(500, 500);
    }

    @Override
    public BigInteger getNumIndexes() {
        return this.numIndexes;
    }

    @Override
    public Layout getLayout(BigInteger index) {
        if (index.compareTo(BigInteger.ZERO) < 0) {
            return null;
        }
        if (index.compareTo(this.numIndexes) >= 0) {
            return null;
        }
        String text = this.name + ": This is line " + index + " More text to make line longer abcdefghijklmnopqrstuvwxyzabcdefghijk";
        TextFieldElement fe1 = new TextFieldElement(new AttributedString(text, Color.BLACK, this.fm), 0, 0);
        TextFieldElement fe2 = new TextFieldElement(new AttributedString("More text", Color.BLACK, this.fm), 0, 0);
        SingleRowLayout layout = new SingleRowLayout(new ClippingTextField(20, 300, fe1, hlFactory), new ClippingTextField(330, 100, fe2, hlFactory));
        if (index.intValue() >= this.startBigSizes && index.intValue() <= this.endBigSizes) {
            layout.insertSpaceAbove(30);
        }
        return layout;
    }

    @Override
    public void addLayoutModelListener(LayoutModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLayoutModelListener(LayoutModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public BigInteger getIndexAfter(BigInteger index) {
        BigInteger nextIndex = index.add(BigInteger.ONE);
        if (nextIndex.compareTo(this.numIndexes) >= 0) {
            return null;
        }
        return nextIndex;
    }

    @Override
    public BigInteger getIndexBefore(BigInteger index) {
        if (index.compareTo(BigInteger.ZERO) <= 0) {
            return null;
        }
        if (index.compareTo(this.numIndexes) >= 0) {
            index = this.numIndexes;
        }
        return index.subtract(BigInteger.ONE);
    }

    public static void main(String[] args) {
        Font font = new Font("monospace", 0, 12);
        JFrame frame = new JFrame();
        TestBigLayoutModel model = new TestBigLayoutModel(frame.getFontMetrics(font), "AAA", BigInteger.valueOf(1000000L));
        FieldPanel provider = new FieldPanel(model);
        IndexedScrollPane scrollPanel = new IndexedScrollPane(provider);
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(scrollPanel);
        JButton button = new JButton("Hit Me");
        button.addActionListener(e -> model.updateData(1000, 2000));
        contentPane.add((Component)button, "South");
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        frame.repaint();
    }

    protected void updateData(int i, int j) {
        int notifyStart = Math.min(i, this.startBigSizes);
        int notifyEnd = Math.max(j, this.endBigSizes);
        this.startBigSizes = i;
        this.endBigSizes = j;
        for (LayoutModelListener listener : this.listeners) {
            listener.dataChanged(BigInteger.valueOf(notifyStart), BigInteger.valueOf(notifyEnd));
        }
    }

    @Override
    public void flushChanges() {
    }
}

