/*
 * Decompiled with CFR 0.152.
 */
package util.demangler;

import util.demangler.GenericDemangledTemplate;

public class GenericDemangledType {
    private GenericDemangledType namespace;
    private String name;
    private GenericDemangledTemplate template;
    private boolean isConst;
    private boolean isVolatile;

    public GenericDemangledType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public void setConst() {
        this.isConst = true;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setVolatile() {
        this.isVolatile = true;
    }

    public GenericDemangledType getNamespace() {
        return this.namespace;
    }

    public void setNamespace(GenericDemangledType namespace) {
        if (this == namespace) {
            throw new IllegalArgumentException("Attempt to set this.namespace == this!");
        }
        this.namespace = namespace;
    }

    public GenericDemangledTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(GenericDemangledTemplate template) {
        this.template = template;
    }

    public String toSignature() {
        StringBuffer buffer = new StringBuffer();
        if (this.namespace != null) {
            buffer.append(this.namespace.toNamespace());
        }
        buffer.append(this.name);
        if (this.template != null) {
            buffer.append(this.template.toTemplate());
        }
        return buffer.toString();
    }

    public String toNamespace() {
        StringBuffer buffer = new StringBuffer();
        if (this.namespace != null) {
            buffer.append(this.namespace.toNamespace());
        }
        buffer.append(this.name);
        if (this.template != null) {
            buffer.append(this.template.toTemplate());
        }
        buffer.append("::");
        return buffer.toString();
    }

    public String toString() {
        return this.toSignature();
    }
}

