/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.graphs;

import com.google.common.collect.Iterables;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import ghidra.graph.event.VisualGraphChangeListener;
import ghidra.graph.graphs.JungDirectedVisualGraph;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.LayoutListener;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.IterableUtils;
import util.CollectionUtils;

public abstract class DefaultVisualGraph<V extends VisualVertex, E extends VisualEdge<V>>
extends JungDirectedVisualGraph<V, E> {
    protected V focusedVertex;
    private Set<V> selectedVertices = Collections.emptySet();
    private WeakSet<VisualGraphChangeListener<V, E>> changeListeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();

    @Override
    public abstract DefaultVisualGraph<V, E> copy();

    @Override
    public void setSelectedVertices(Set<V> selectedVertices) {
        this.clearFocusedVertex();
        this.setVerticesSelected(this.selectedVertices, false);
        this.selectedVertices = selectedVertices;
        this.setVerticesSelected(selectedVertices, true);
    }

    private void setVerticesSelected(Set<V> vertices, boolean selected) {
        for (VisualVertex vertex : vertices) {
            vertex.setSelected(selected);
        }
    }

    @Override
    public void setVertexFocused(V vertex, boolean focused) {
        this.clearSelectedVertices();
        vertex.setFocused(focused);
        if (focused) {
            vertex.setSelected(focused);
            this.focusedVertex = vertex;
        }
    }

    @Override
    public V getFocusedVertex() {
        return this.focusedVertex;
    }

    private void clearFocusedVertex() {
        if (this.focusedVertex == null) {
            return;
        }
        this.focusedVertex.setFocused(false);
        this.focusedVertex.setSelected(false);
        this.focusedVertex = null;
    }

    @Override
    public void clearSelectedVertices() {
        this.clearFocusedVertex();
        this.setVerticesSelected(this.selectedVertices, false);
        this.selectedVertices.clear();
    }

    @Override
    public Set<V> getSelectedVertices() {
        boolean hasGroupSelection;
        boolean bl = hasGroupSelection = this.selectedVertices.size() > 0;
        if (!hasGroupSelection && this.focusedVertex == null) {
            return Collections.emptySet();
        }
        if (hasGroupSelection) {
            return new HashSet<V>(this.selectedVertices);
        }
        HashSet<V> set = new HashSet<V>();
        set.add(this.focusedVertex);
        return set;
    }

    @Override
    public void vertexLocationChanged(V v, Point point, LayoutListener.ChangeType type) {
    }

    public void dispose() {
        this.selectedVertices.clear();
        this.selectedVertices = Collections.emptySet();
        this.changeListeners.clear();
        this.changeListeners = null;
    }

    protected void initializeLocation(V v) {
        VisualGraphLayout layout = this.getLayout();
        if (layout == null) {
            return;
        }
        Point2D location = (Point2D)layout.apply(v);
        v.setLocation(location);
    }

    public Iterable<E> getAllEdges(V v) {
        Collection in = this.getInEdges(v);
        Collection out = this.getOutEdges(v);
        Iterable concatenated = Iterables.concat((Iterable)in, (Iterable)out);
        return concatenated;
    }

    public Iterable<E> getEdges(V start, V end) {
        Collection outs = CollectionUtils.nonNull((Collection)this.getOutEdges(start));
        Collection ins = CollectionUtils.nonNull((Collection)this.getInEdges(end));
        Iterable concatenated = Iterables.concat((Iterable)outs, (Iterable)ins);
        Iterable filtered = Iterables.filter((Iterable)concatenated, e -> ((VisualVertex)e.getStart()).equals(start) && ((VisualVertex)e.getEnd()).equals(end));
        return filtered;
    }

    @Override
    public boolean addVertex(V v) {
        boolean added = super.addVertex(v);
        if (added) {
            this.initializeLocation(v);
            this.verticesAdded(Arrays.asList(v));
        }
        return added;
    }

    public boolean addEdge(E edge, Pair<? extends V> endpoints, EdgeType edgeType) {
        boolean added = super.addEdge(edge, endpoints, edgeType);
        if (added) {
            this.fireEdgesAdded(Arrays.asList(edge));
        }
        return added;
    }

    @Override
    public boolean removeVertex(V v) {
        boolean removed = super.removeVertex(v);
        if (removed) {
            this.verticesRemoved(Arrays.asList(v));
        }
        return removed;
    }

    @Override
    public void removeVertices(Iterable<V> toRemove) {
        ArrayList<VisualVertex> removed = new ArrayList<VisualVertex>();
        for (VisualVertex v : toRemove) {
            if (!super.removeVertex((Object)v)) continue;
            removed.add(v);
        }
        this.verticesRemoved(removed);
    }

    @Override
    public boolean removeEdge(E edge) {
        boolean removed = super.removeEdge(edge);
        if (removed) {
            this.fireEdgesRemoved(Arrays.asList(edge));
        }
        return removed;
    }

    protected void verticesAdded(Collection<V> added) {
        this.fireVerticesAdded(added);
    }

    protected void verticesRemoved(Collection<V> removed) {
        this.fireVerticesRemoved(removed);
    }

    protected void fireVerticesRemoved(Collection<V> removed) {
        if (removed.isEmpty()) {
            return;
        }
        this.changeListeners.forEach(l -> l.verticesRemoved(removed));
    }

    protected void fireVerticesAdded(Collection<V> added) {
        if (added.isEmpty()) {
            return;
        }
        this.changeListeners.forEach(l -> l.verticesAdded(added));
    }

    protected void fireEdgesRemoved(Iterable<E> removed) {
        if (IterableUtils.isEmpty(removed)) {
            return;
        }
        this.changeListeners.forEach(l -> l.edgesRemoved(removed));
    }

    protected void fireEdgesAdded(Iterable<E> added) {
        if (IterableUtils.isEmpty(added)) {
            return;
        }
        this.changeListeners.forEach(l -> l.edgesAdded(added));
    }

    @Override
    public void addGraphChangeListener(VisualGraphChangeListener<V, E> l) {
        this.changeListeners.add(l);
    }

    @Override
    public void removeGraphChangeListener(VisualGraphChangeListener<V, E> l) {
        this.changeListeners.remove(l);
    }
}

