/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.javaclass.format.ClassFileJava;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.AttributeFactory;
import ghidra.javaclass.format.attributes.ConstantValueAttribute;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class FieldInfoJava
implements StructConverter {
    private long _offset;
    private short accessFlags;
    private short nameIndex;
    private short descriptorIndex;
    private short attributesCount;
    private AbstractAttributeInfo[] attributes;

    public FieldInfoJava(BinaryReader reader, ClassFileJava classFile) throws IOException {
        this._offset = reader.getPointerIndex();
        this.accessFlags = reader.readNextShort();
        this.nameIndex = reader.readNextShort();
        this.descriptorIndex = reader.readNextShort();
        this.attributesCount = reader.readNextShort();
        this.attributes = new AbstractAttributeInfo[this.attributesCount];
        for (int i = 0; i < this.attributesCount; ++i) {
            this.attributes[i] = AttributeFactory.get(reader, classFile.getConstantPool());
        }
    }

    public long getOffset() {
        return this._offset;
    }

    public short getAccessFlags() {
        return this.accessFlags;
    }

    public short getNameIndex() {
        return this.nameIndex;
    }

    public short getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public short getAttributesCount() {
        return this.attributesCount;
    }

    public AbstractAttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public ConstantValueAttribute getConstantValueAttribute() {
        for (AbstractAttributeInfo attributeInfo : this.attributes) {
            if (!(attributeInfo instanceof ConstantValueAttribute)) continue;
            return (ConstantValueAttribute)attributeInfo;
        }
        return null;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "field_info|" + this.attributesCount + "|";
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(WORD, "access_flags", null);
        structure.add(WORD, "name_index", null);
        structure.add(WORD, "descriptor_index", null);
        structure.add(WORD, "attributes_count", null);
        for (int i = 0; i < this.attributes.length; ++i) {
            structure.add(this.attributes[i].toDataType(), "attributes_" + i, null);
        }
        return structure;
    }
}

