/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.javaclass.format.AccessFlagsJava;
import ghidra.javaclass.format.ClassFileJava;
import ghidra.javaclass.format.DescriptorDecoder;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.AttributeFactory;
import ghidra.javaclass.format.attributes.CodeAttribute;
import ghidra.javaclass.format.attributes.ExceptionsAttribute;
import ghidra.javaclass.format.attributes.LocalVariableJava;
import ghidra.javaclass.format.attributes.LocalVariableTableAttribute;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.javaclass.format.constantpool.ConstantPoolClassInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolUtf8Info;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MethodInfoJava
implements StructConverter {
    private long _offset;
    private short accessFlags;
    private short nameIndex;
    private short descriptorIndex;
    private short attributesCount;
    private AbstractAttributeInfo[] attributes;

    public MethodInfoJava(BinaryReader reader, ClassFileJava classFile) throws IOException {
        this._offset = reader.getPointerIndex();
        this.accessFlags = reader.readNextShort();
        this.nameIndex = reader.readNextShort();
        this.descriptorIndex = reader.readNextShort();
        this.attributesCount = reader.readNextShort();
        this.attributes = new AbstractAttributeInfo[this.attributesCount];
        for (int i = 0; i < this.attributesCount; ++i) {
            this.attributes[i] = AttributeFactory.get(reader, classFile.getConstantPool());
        }
    }

    public long getOffset() {
        return this._offset;
    }

    public short getAccessFlags() {
        return this.accessFlags;
    }

    public boolean isStatic() {
        return AccessFlagsJava.isStatic(this.accessFlags);
    }

    public short getNameIndex() {
        return this.nameIndex;
    }

    public short getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public short getAttributesCount() {
        return this.attributesCount;
    }

    public AbstractAttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public String getMethodSignature(ClassFileJava classFile) {
        AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
        ConstantPoolUtf8Info methodName = (ConstantPoolUtf8Info)constantPool[this.nameIndex];
        ConstantPoolUtf8Info methodDescriptor = (ConstantPoolUtf8Info)constantPool[this.descriptorIndex];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AccessFlagsJava.toString(this.accessFlags, false).trim());
        if (!methodName.getString().equals("<clinit>")) {
            LocalVariableTableAttribute localVariableTable;
            stringBuffer.append(' ');
            if (methodName.getString().equals("<init>")) {
                ConstantPoolClassInfo thisClass = (ConstantPoolClassInfo)constantPool[classFile.getThisClass()];
                ConstantPoolUtf8Info thisClassName = (ConstantPoolUtf8Info)constantPool[thisClass.getNameIndex()];
                String className = thisClassName.getString();
                String dottedClassName = className.replace('/', '.');
                int pos = dottedClassName.lastIndexOf(46);
                if (pos > -1) {
                    stringBuffer.append(dottedClassName.substring(pos + 1));
                } else {
                    stringBuffer.append(className);
                }
            } else {
                stringBuffer.append(this.getReturnType(methodDescriptor));
                stringBuffer.append(' ');
                stringBuffer.append(methodName.getString());
            }
            stringBuffer.append('(');
            CodeAttribute codeAttribute = this.getCodeAttribute();
            if (codeAttribute != null && (localVariableTable = codeAttribute.getLocalVariableTableAttribute()) != null) {
                int startIndex;
                LocalVariableJava[] localVariables = localVariableTable.getLocalVariables();
                for (int i = startIndex = this.getParametersStartIndex(); i < localVariables.length; ++i) {
                    if (localVariables[i].getStartPC() != 0) continue;
                    if (i > startIndex) {
                        stringBuffer.append(", ");
                    }
                    ConstantPoolUtf8Info parameterName = (ConstantPoolUtf8Info)constantPool[localVariables[i].getNameIndex()];
                    ConstantPoolUtf8Info parameterDescriptor = (ConstantPoolUtf8Info)constantPool[localVariables[i].getDescriptorIndex()];
                    stringBuffer.append(DescriptorDecoder.decodeType(parameterDescriptor, false));
                    stringBuffer.append(" ");
                    stringBuffer.append(parameterName);
                }
            }
            stringBuffer.append(')');
            ExceptionsAttribute exceptionsAttribute = this.getExceptionsAttribute();
            if (exceptionsAttribute != null) {
                int i = 0;
                for (short s : exceptionsAttribute.getExceptionIndexTable()) {
                    ConstantPoolClassInfo exceptionClass = (ConstantPoolClassInfo)constantPool[s];
                    ConstantPoolUtf8Info exceptionClassName = (ConstantPoolUtf8Info)constantPool[exceptionClass.getNameIndex()];
                    String className = exceptionClassName.getString();
                    String dottedClassName = className.replace('/', '.');
                    if (i == 0) {
                        stringBuffer.append(" throws ");
                    } else {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(dottedClassName);
                    ++i;
                }
            }
        }
        stringBuffer.append(' ');
        return stringBuffer.toString();
    }

    private int getParametersStartIndex() {
        return AccessFlagsJava.isStatic(this.accessFlags) ? 0 : 1;
    }

    private String getReturnType(ConstantPoolUtf8Info methodDescriptor) {
        String methodDescriptorString = methodDescriptor.getString();
        int closeParenthesisPos = methodDescriptorString.indexOf(41) + 1;
        String encodedReturnType = methodDescriptorString.substring(closeParenthesisPos);
        return DescriptorDecoder.getTypeNameFromDescriptor(encodedReturnType, false, true);
    }

    public CodeAttribute getCodeAttribute() {
        for (AbstractAttributeInfo attributeInfo : this.attributes) {
            if (!(attributeInfo instanceof CodeAttribute)) continue;
            return (CodeAttribute)attributeInfo;
        }
        return null;
    }

    public ExceptionsAttribute getExceptionsAttribute() {
        for (AbstractAttributeInfo attributeInfo : this.attributes) {
            if (!(attributeInfo instanceof ExceptionsAttribute)) continue;
            return (ExceptionsAttribute)attributeInfo;
        }
        return null;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "method_info|" + this.nameIndex + "|" + this.descriptorIndex + "|" + this.attributesCount + "|";
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(WORD, "access_flags", null);
        structure.add(WORD, "name_index", null);
        structure.add(WORD, "descriptor_index", null);
        structure.add(WORD, "attributes_count", null);
        for (int i = 0; i < this.attributes.length; ++i) {
            structure.add(this.attributes[i].toDataType(), "attributes_" + i, null);
        }
        return structure;
    }
}

