/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.program;

import ghidra.app.plugin.prototype.match.ExactInstructionsFunctionHasher;
import ghidra.app.plugin.prototype.match.FunctionHasher;
import ghidra.feature.vt.api.correlator.program.FunctionMatchProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelatorFactory;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;

public class DuplicateFunctionMatchProgramCorrelatorFactory
extends VTAbstractProgramCorrelatorFactory {
    static final String DESC = "Compares code by hashing instructions (masking off operands), looking for identical functions.  It reports back any that have MORE THAN ONE identical match.";
    static final String DUPLICATE_MATCH = "Duplicate Function Instructions Match";
    static final int maxMatches = 10;

    @Override
    public int getPriority() {
        return 80;
    }

    @Override
    protected VTProgramCorrelator doCreateCorrelator(ServiceProvider serviceProvider, Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, VTOptions options) {
        return new FunctionMatchProgramCorrelator(serviceProvider, sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, options, DUPLICATE_MATCH, false, (FunctionHasher)ExactInstructionsFunctionHasher.INSTANCE);
    }

    @Override
    public String getName() {
        return DUPLICATE_MATCH;
    }

    @Override
    public VTOptions createDefaultOptions() {
        VTOptions options = new VTOptions(DUPLICATE_MATCH);
        options.setInt("Function Minimum Size", 10);
        return options;
    }

    @Override
    public String getDescription() {
        return DESC;
    }
}

