/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.stringable;

import ghidra.feature.vt.api.util.Stringable;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.util.SystemUtilities;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import java.util.StringTokenizer;

public class DataTypeStringable
extends Stringable {
    public static final String SHORT_NAME = "DT";
    private long managerUniversalID;
    private long dataTypeID;
    private String dataTypeName;
    private int length;

    public DataTypeStringable() {
        super(SHORT_NAME);
    }

    public DataTypeStringable(DataType dataType, DataTypeManager dataTypeManager, int length) {
        super(SHORT_NAME);
        UniversalID universalID = dataTypeManager.getUniversalID();
        this.managerUniversalID = universalID.getValue();
        this.dataTypeID = dataTypeManager.getID(dataType);
        this.dataTypeName = dataType.getName();
        this.length = length;
    }

    @Override
    public String getDisplayString() {
        return this.dataTypeName + " (size=" + this.length + ")";
    }

    @Override
    protected String doConvertToString(Program program) {
        return Long.toString(this.managerUniversalID) + "\t" + Long.toString(this.dataTypeID) + "\t" + this.dataTypeName + "\t" + Integer.toString(this.length);
    }

    @Override
    protected void doRestoreFromString(String string, Program program) {
        StringTokenizer tokenizzy = new StringTokenizer(string, "\t");
        this.managerUniversalID = Long.parseLong(tokenizzy.nextToken());
        this.dataTypeID = Long.parseLong(tokenizzy.nextToken());
        this.dataTypeName = tokenizzy.nextToken();
        this.length = Integer.parseInt(tokenizzy.nextToken());
    }

    public long getDataTypeManagerID() {
        return this.managerUniversalID;
    }

    public long getDataTypeID() {
        return this.dataTypeID;
    }

    public String getDataTypeName() {
        return this.dataTypeName;
    }

    public DataType getDataType(DataTypeManager dataTypeManager) {
        long actualUniversalID = dataTypeManager.getUniversalID().getValue();
        if (actualUniversalID != this.managerUniversalID) {
            throw new AssertException("Provided data type manager ID of " + actualUniversalID + " doesn't matched saved ID of " + this.managerUniversalID + ".");
        }
        return dataTypeManager.getDataType(this.dataTypeID);
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataTypeStringable other = (DataTypeStringable)obj;
        return this.managerUniversalID == other.managerUniversalID && this.dataTypeID == other.dataTypeID && SystemUtilities.isEqual((Object)this.dataTypeName, (Object)other.dataTypeName) && this.length == other.length;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.dataTypeID ^ this.dataTypeID >>> 32);
        result = 31 * result + (this.dataTypeName == null ? 0 : this.dataTypeName.hashCode());
        result = 31 * result + (int)(this.managerUniversalID ^ this.managerUniversalID >>> 32);
        result = 31 * result + this.length;
        return result;
    }
}

