/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.ByteField;
import db.DBHandle;
import db.IntField;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.program.database.code.CommentHistoryAdapterNoTable;
import ghidra.program.database.code.CommentHistoryAdapterV0;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class CommentHistoryAdapter {
    static final String COMMENT_HISTORY_TABLE_NAME = "Comment History";
    static final Schema COMMENT_HISTORY_SCHEMA = new Schema(0, "Key", new Class[]{LongField.class, ByteField.class, IntField.class, IntField.class, StringField.class, StringField.class, LongField.class}, new String[]{"Address", "Comment Type", "Pos1", "Pos2", "String Data", "User", "Date"});
    static final int HISTORY_ADDRESS_COL = 0;
    static final int HISTORY_TYPE_COL = 1;
    static final int HISTORY_POS1_COL = 2;
    static final int HISTORY_POS2_COL = 3;
    static final int HISTORY_STRING_COL = 4;
    static final int HISTORY_USER_COL = 5;
    static final int HISTORY_DATE_COL = 6;

    CommentHistoryAdapter() {
    }

    static CommentHistoryAdapter getAdapter(DBHandle dbHandle, int openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode == 0) {
            return new CommentHistoryAdapterV0(dbHandle, addrMap, true);
        }
        try {
            CommentHistoryAdapterV0 adapter = new CommentHistoryAdapterV0(dbHandle, addrMap, false);
            if (addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            CommentHistoryAdapter adapter = CommentHistoryAdapter.findReadOnlyAdapter(dbHandle, addrMap);
            if (openMode == 3) {
                adapter = CommentHistoryAdapter.upgrade(dbHandle, addrMap, adapter, monitor);
            }
            return adapter;
        }
    }

    private static CommentHistoryAdapter findReadOnlyAdapter(DBHandle handle, AddressMap addrMap) throws VersionException, IOException {
        try {
            return new CommentHistoryAdapterV0(handle, addrMap.getOldAddressMap(), false);
        }
        catch (VersionException versionException) {
            return new CommentHistoryAdapterNoTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CommentHistoryAdapter upgrade(DBHandle dbHandle, AddressMap addrMap, CommentHistoryAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        try (DBHandle tmpHandle = new DBHandle();){
            tmpHandle.startTransaction();
            monitor.setMessage("Upgrading Comment History...");
            monitor.initialize((long)(oldAdapter.getRecordCount() * 2));
            int count = 0;
            CommentHistoryAdapterV0 tmpAdapter = new CommentHistoryAdapterV0(tmpHandle, addrMap, true);
            RecordIterator iter = oldAdapter.getAllRecords();
            while (iter.hasNext()) {
                monitor.checkCanceled();
                Record rec = iter.next();
                Address addr = oldAddrMap.decodeAddress(rec.getLongValue(0));
                rec.setLongValue(0, addrMap.getKey(addr, true));
                ((CommentHistoryAdapter)tmpAdapter).updateRecord(rec);
                monitor.setProgress((long)(++count));
            }
            dbHandle.deleteTable(COMMENT_HISTORY_TABLE_NAME);
            CommentHistoryAdapterV0 newAdapter = new CommentHistoryAdapterV0(dbHandle, addrMap, true);
            iter = ((CommentHistoryAdapter)tmpAdapter).getAllRecords();
            while (iter.hasNext()) {
                monitor.checkCanceled();
                Record rec = iter.next();
                ((CommentHistoryAdapter)newAdapter).updateRecord(rec);
                monitor.setProgress((long)(++count));
            }
            CommentHistoryAdapterV0 commentHistoryAdapterV0 = newAdapter;
            return commentHistoryAdapterV0;
        }
    }

    abstract int getRecordCount();

    abstract void createRecord(long var1, byte var3, int var4, int var5, String var6) throws IOException;

    abstract void updateRecord(Record var1) throws IOException;

    abstract boolean deleteRecords(Address var1, Address var2) throws IOException;

    abstract RecordIterator getRecordsByAddress(Address var1) throws IOException;

    abstract RecordIterator getAllRecords() throws IOException;
}

