/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import ghidra.docking.settings.Settings;
import java.util.ArrayList;

class TypedefSettings
implements Settings {
    private Settings defaultSettings;
    private Settings instanceSettings;

    TypedefSettings(Settings defaultSettings, Settings instanceSettings) {
        this.defaultSettings = defaultSettings;
        this.instanceSettings = instanceSettings;
    }

    public void clearAllSettings() {
        this.defaultSettings.clearAllSettings();
    }

    public void clearSetting(String name) {
        this.defaultSettings.clearSetting(name);
    }

    public byte[] getByteArray(String name) {
        byte[] b = this.instanceSettings.getByteArray(name);
        if (b == null) {
            b = this.defaultSettings.getByteArray(name);
        }
        return b;
    }

    public Long getLong(String name) {
        Long value = this.instanceSettings.getLong(name);
        if (value == null) {
            value = this.defaultSettings.getLong(name);
        }
        return value;
    }

    public String[] getNames() {
        ArrayList<String> list = new ArrayList<String>();
        String[] instNames = this.instanceSettings.getNames();
        for (int i = 0; i < instNames.length; ++i) {
            list.add(instNames[i]);
        }
        String[] defNames = this.defaultSettings.getNames();
        for (int i = 0; i < defNames.length; ++i) {
            if (list.contains(defNames[i])) continue;
            list.add(defNames[i]);
        }
        String[] names = new String[list.size()];
        return list.toArray(names);
    }

    public String getString(String name) {
        String value = this.instanceSettings.getString(name);
        if (value == null) {
            value = this.defaultSettings.getString(name);
        }
        return value;
    }

    public Object getValue(String name) {
        Object value = this.instanceSettings.getValue(name);
        if (value == null) {
            value = this.defaultSettings.getValue(name);
        }
        return value;
    }

    public boolean isEmpty() {
        return this.instanceSettings.isEmpty() && this.defaultSettings.isEmpty();
    }

    public void setByteArray(String name, byte[] value) {
        this.defaultSettings.setByteArray(name, value);
    }

    public void setLong(String name, long value) {
        this.defaultSettings.setLong(name, value);
    }

    public void setString(String name, String value) {
        this.defaultSettings.setString(name, value);
    }

    public void setValue(String name, Object value) {
        this.defaultSettings.setValue(name, value);
    }

    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }
}

