/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.mgr;

import db.TerminatedTransactionException;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.AbortedTransactionListener;
import ghidra.framework.model.DomainObjectException;
import ghidra.framework.model.DomainObjectLockedException;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.mgr.ToolTaskManager;
import ghidra.util.Msg;
import ghidra.util.TaskUtilities;
import ghidra.util.exception.ClosedException;
import ghidra.util.exception.RollbackException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.rmi.ConnectException;

class BackgroundCommandTask
extends Task
implements AbortedTransactionListener {
    private BackgroundCommand cmd;
    private ToolTaskManager taskMgr;
    private UndoableDomainObject obj;
    private TaskMonitor taskMonitor;
    private boolean doneQueueProcessing;

    public BackgroundCommandTask(ToolTaskManager taskMgr, UndoableDomainObject obj, BackgroundCommand cmd) {
        super(cmd.getName(), cmd.canCancel(), cmd.hasProgress(), cmd.isModal());
        this.cmd = cmd;
        this.taskMgr = taskMgr;
        this.obj = obj;
    }

    public UndoableDomainObject getDomainObject() {
        return this.obj;
    }

    public BackgroundCommand getCommand() {
        return this.cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run(TaskMonitor monitor) {
        boolean success;
        block39: {
            int id;
            TaskUtilities.addTrackedTask((Task)this, (TaskMonitor)monitor);
            this.taskMonitor = monitor;
            try {
                id = this.obj.startTransaction(this.cmd.getName(), this);
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)"Transaction error", (Throwable)t);
                monitor.cancel();
                ToolTaskManager toolTaskManager = this.taskMgr;
                synchronized (toolTaskManager) {
                    this.doneQueueProcessing = true;
                    this.taskMgr.clearTasks(this.obj);
                    this.taskMgr.taskFailed(this.obj, this.cmd, monitor);
                }
                return;
            }
            finally {
                ToolTaskManager toolTaskManager = this.taskMgr;
                synchronized (toolTaskManager) {
                    this.taskMgr.notifyAll();
                }
            }
            success = false;
            boolean error = true;
            success = this.cmd.applyTo(this.obj, monitor);
            if (success) {
                this.taskMgr.taskCompleted(this.obj, this, monitor);
            }
            error = false;
            TaskUtilities.removeTrackedTask((Task)this);
            try {
                this.obj.endTransaction(id, !error);
            }
            catch (DomainObjectException e) {
                Throwable cause = e.getCause();
                if (!error && !(cause instanceof ClosedException)) {
                    Msg.showError((Object)this, null, null, null, (Throwable)cause);
                    success = false;
                }
                break block39;
            }
            catch (Throwable t) {
                Object cause;
                block42: {
                    block40: {
                        block41: {
                            try {
                                cause = this.taskMgr;
                                synchronized (cause) {
                                    this.doneQueueProcessing = true;
                                    this.taskMgr.clearQueuedCommands(this.obj);
                                }
                                if (t instanceof DomainObjectException) {
                                    t = t.getCause();
                                }
                                if (!this.ignoreException(t)) break block40;
                                monitor.cancel();
                                this.taskMgr.clearTasks(this.obj);
                            }
                            catch (Throwable throwable) {
                                block43: {
                                    TaskUtilities.removeTrackedTask((Task)this);
                                    try {
                                        this.obj.endTransaction(id, !error);
                                    }
                                    catch (DomainObjectException e) {
                                        Throwable cause2 = e.getCause();
                                        if (error || cause2 instanceof ClosedException) break block43;
                                        Msg.showError((Object)this, null, null, null, (Throwable)cause2);
                                        success = false;
                                    }
                                }
                                throw throwable;
                            }
                            TaskUtilities.removeTrackedTask((Task)this);
                            try {
                                this.obj.endTransaction(id, !error);
                            }
                            catch (DomainObjectException e) {
                                Throwable cause3 = e.getCause();
                                if (error || cause3 instanceof ClosedException) break block41;
                                Msg.showError((Object)this, null, null, null, (Throwable)cause3);
                                success = false;
                            }
                        }
                        return;
                    }
                    if (t instanceof RollbackException) break block42;
                    Msg.showError((Object)this, null, (String)"Command Failure", (Object)("An unexpected error occurred while processing the command: " + this.cmd.getName()), (Throwable)t);
                }
                TaskUtilities.removeTrackedTask((Task)this);
                try {
                    this.obj.endTransaction(id, !error);
                }
                catch (DomainObjectException e) {
                    cause = e.getCause();
                    if (!error && !(cause instanceof ClosedException)) {
                        Msg.showError((Object)this, null, null, null, (Throwable)cause);
                        success = false;
                    }
                }
            }
        }
        if (!success) {
            this.taskMgr.taskFailed(this.obj, this.cmd, monitor);
        }
    }

    private boolean ignoreException(Throwable t) {
        return t instanceof ConnectException || t instanceof TerminatedTransactionException || t instanceof DomainObjectLockedException || t instanceof ClosedException;
    }

    @Override
    public void transactionAborted(long transactionID) {
        this.taskMonitor.cancel();
    }

    void setDoneQueueProcessing() {
        this.doneQueueProcessing = true;
    }

    boolean isDoneQueueProcessing() {
        return this.doneQueueProcessing;
    }
}

