/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.util;

import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginConfigurationModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.framework.plugintool.dialog.ExtensionDetails;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.AssertException;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PluginUtils {
    public static List<PluginDescription> getPluginDescriptions(PluginTool tool, List<Class<?>> plugins) {
        ArrayList<PluginDescription> retPlugins = new ArrayList<PluginDescription>();
        PluginConfigurationModel model = new PluginConfigurationModel(tool, null);
        List<PluginDescription> allPluginDescriptions = model.getAllPluginDescriptions();
        for (Class<?> plugin : plugins) {
            String pluginName = plugin.getSimpleName();
            Optional<PluginDescription> desc = allPluginDescriptions.stream().filter(d -> pluginName.equals(d.getName())).findAny();
            if (!desc.isPresent()) continue;
            retPlugins.add(desc.get());
        }
        return retPlugins;
    }

    public static List<Class<?>> findLoadedPlugins(Set<ExtensionDetails> extensions) {
        ArrayList pluginClasses = new ArrayList();
        for (ExtensionDetails extension : extensions) {
            if (extension == null || extension.getInstallPath() == null) continue;
            List<Class<?>> classes = PluginUtils.findLoadedPlugins(new File(extension.getInstallPath()));
            pluginClasses.addAll(classes);
        }
        return pluginClasses;
    }

    private static List<Class<?>> findLoadedPlugins(File dir) {
        ArrayList retPlugins = new ArrayList();
        ArrayList<File> jarFiles = new ArrayList<File>();
        PluginUtils.findJarFiles(dir, jarFiles);
        Set plugins = ClassSearcher.getClasses(Plugin.class);
        for (Class plugin : plugins) {
            URL location = plugin.getResource("/" + plugin.getName().replace('.', '/') + ".class");
            if (location == null) {
                Msg.warn(null, (Object)("Class location for plugin [" + plugin.getName() + "] could not be determined."));
                continue;
            }
            String pluginLocation = location.getPath();
            for (File jar : jarFiles) {
                URL jarUrl = null;
                try {
                    jarUrl = jar.toURI().toURL();
                    if (!pluginLocation.contains(jarUrl.getPath())) continue;
                    retPlugins.add(plugin);
                }
                catch (MalformedURLException e) {}
            }
        }
        return retPlugins;
    }

    private static void findJarFiles(File dir, List<File> jarFiles) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                PluginUtils.findJarFiles(f, jarFiles);
            }
            if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
            jarFiles.add(f);
        }
    }

    public static <T extends Plugin> T instantiatePlugin(Class<T> pluginClass, PluginTool tool) throws PluginException {
        String className = pluginClass.getName();
        try {
            Constructor<T> ctor = pluginClass.getConstructor(PluginTool.class);
            ctor.setAccessible(true);
            return (T)((Plugin)ctor.newInstance(tool));
        }
        catch (NoSuchMethodException e) {
            throw new PluginException(className, "Possibly missing plugin constructor");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            String message = t == null ? "" : t.getMessage();
            Msg.error(PluginUtils.class, (Object)("Unexpected Exception: " + message), (Throwable)t);
            throw new PluginException("Error constructing plugin: " + pluginClass, e);
        }
        catch (InstantiationException e) {
            throw new PluginException(className, "Could not instantiate plugin class " + e);
        }
        catch (IllegalAccessException e) {
            throw new PluginException(className, "Illegal Access exception, make sure plugin class and constructor is public");
        }
    }

    public static Class<? extends Plugin> forName(String pluginClassName) throws PluginException {
        try {
            Class<?> tmpClass = Class.forName(pluginClassName);
            if (!Plugin.class.isAssignableFrom(tmpClass)) {
                throw new PluginException("Class " + pluginClassName + " is not derived from Plugin");
            }
            return tmpClass.asSubclass(Plugin.class);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Plugin class not found");
        }
    }

    private static String getStaticStringFieldValue(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getField(fieldName);
            return (String)field.get(null);
        }
        catch (NoSuchFieldException field) {
        }
        catch (IllegalAccessException ex) {
            throw new AssertException("default provider class for " + clazz.getName() + " is not declared to be public!");
        }
        return null;
    }

    public static Class<? extends Plugin> getDefaultProviderForServiceClass(Class<?> serviceClass) {
        String defaultProviderClassName = null;
        ServiceInfo sia = serviceClass.getAnnotation(ServiceInfo.class);
        if (sia != null) {
            if (sia.defaultProvider().length > 0) {
                return sia.defaultProvider()[0];
            }
            defaultProviderClassName = sia.defaultProviderName().trim();
        }
        if (defaultProviderClassName == null || defaultProviderClassName.isEmpty()) {
            defaultProviderClassName = PluginUtils.getStaticStringFieldValue(serviceClass, "defaultProvider");
        }
        if (defaultProviderClassName != null) {
            try {
                Class<?> tmpClass = Class.forName(defaultProviderClassName);
                return tmpClass.asSubclass(Plugin.class);
            }
            catch (ClassCastException cce) {
                Msg.error(PluginUtils.class, (Object)("The default provider specified for service " + serviceClass.getName() + " (" + defaultProviderClassName + ") is not a Plugin!"));
            }
            catch (ClassNotFoundException e) {
                throw new AssertException("default provider class for " + serviceClass.getName() + " not found!");
            }
        }
        return null;
    }

    public static String getPluginNameFromClass(Class<? extends Plugin> pluginClass) {
        return pluginClass.getSimpleName();
    }

    public static void assertUniquePluginName(Class<? extends Plugin> pluginClass) throws PluginException {
        String pluginName = PluginUtils.getPluginNameFromClass(pluginClass);
        for (Class otherPluginClass : ClassSearcher.getClasses(Plugin.class)) {
            if (otherPluginClass == pluginClass || !PluginUtils.getPluginNameFromClass(otherPluginClass).equals(pluginName)) continue;
            throw new PluginException("Duplicate Plugin name: " + pluginClass.getName() + " and " + otherPluginClass.getName());
        }
    }

    public static boolean isValidPluginClass(Class<? extends Plugin> pluginClass) {
        try {
            pluginClass.getConstructor(PluginTool.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }
}

