/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.format.pdb.PdbMember;
import ghidra.app.util.bin.format.pdb.PdbParserNEW;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.RangeMap;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlTreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class CompositeMember {
    private static int MAX_CONSTRUCTION_DEPTH = 20;
    private DataTypeManager dataTypeManager;
    private CompositeMember parent;
    private String memberName;
    private String memberDataTypeName;
    private int memberOffset;
    private String memberKind;
    private int memberLength;
    private DataType memberDataType;
    private boolean memberIsZeroLengthArray;
    private DataTypeResolver memberDataTypeResolver;
    private Map<Integer, CompositeMember> structureMemberOffsetMap;
    private RangeMap structureMemberRangeMap;
    private List<CompositeMember> unionMemberList;
    private boolean isBitFieldUnion;
    private int bitFieldUnionLength;
    private static long nextTemporaryValue;

    private static synchronized String allocateTemporaryContainerName() {
        return "_tmp_" + nextTemporaryValue++;
    }

    CompositeMember(DataTypeResolver dataTypeResolver, DataTypeManager dataTypeManager) throws CancelledException {
        this.memberOffset = -1;
        this.memberDataTypeResolver = dataTypeResolver;
        this.dataTypeManager = dataTypeManager;
        this.resolve();
    }

    private CompositeMember(PdbMember member, DataTypeResolver dataTypeResolver, DataTypeManager dataTypeManager, TaskMonitor monitor) throws CancelledException {
        this.memberName = member.memberName;
        this.memberDataTypeName = member.memberDataTypeName;
        this.memberOffset = member.memberOffset;
        this.memberKind = member.memberKind;
        this.memberLength = member.memberLength;
        this.memberDataTypeResolver = dataTypeResolver;
        this.dataTypeManager = dataTypeManager;
        this.resolve();
    }

    private CompositeMember(CompositeMember member) {
        this.memberName = member.memberName;
        this.memberDataTypeName = member.memberDataTypeName;
        this.memberDataType = member.memberDataType;
        this.memberIsZeroLengthArray = member.memberIsZeroLengthArray;
        this.memberOffset = member.memberOffset;
        this.memberKind = member.memberKind;
        this.memberLength = member.memberLength;
        this.memberDataTypeResolver = member.memberDataTypeResolver;
        this.dataTypeManager = member.dataTypeManager;
        this.structureMemberOffsetMap = member.structureMemberOffsetMap;
        this.structureMemberRangeMap = member.structureMemberRangeMap;
        this.unionMemberList = member.unionMemberList;
        this.isBitFieldUnion = member.isBitFieldUnion;
        this.bitFieldUnionLength = member.bitFieldUnionLength;
    }

    String getName() {
        return this.memberName;
    }

    String getKind() {
        return this.memberKind;
    }

    String getDataTypeName() {
        return this.memberDataType != null ? this.memberDataType.getName() : this.memberDataTypeName;
    }

    DataType getDataType() {
        return this.memberDataType;
    }

    private void updateContainerNameAndCategoryPath(String typeMnemonic) {
        if (this.parent == null || !this.isContainer()) {
            return;
        }
        String baseName = this.parent.getDataTypeName();
        String oldMemberName = this.memberName;
        String name = "_" + typeMnemonic + "_";
        if (this.parent.isUnionContainer()) {
            try {
                name = name + this.parent.getOrdinal(oldMemberName);
            }
            catch (NotFoundException e) {
                Msg.error((Object)this, (Object)("Failed to rename anonymous compsite: " + this.getDataTypeName()));
            }
        } else {
            name = name + this.memberOffset;
        }
        try {
            this.memberDataType.setName(baseName + name);
            this.memberDataType.setCategoryPath(this.parent.getChildCategoryPath());
            this.memberName = name;
            this.parent.memberNameChanged(oldMemberName, this.memberName);
        }
        catch (InvalidNameException | DuplicateNameException e) {
            throw new AssertException(e);
        }
    }

    void finalizeDataType(int preferredSize) {
        if (!this.isContainer()) {
            return;
        }
        if (this.isStructureContainer()) {
            this.updateContainerNameAndCategoryPath("s");
            CompositeMember lastMember = null;
            for (CompositeMember member : this.structureMemberOffsetMap.values()) {
                member.finalizeDataType(0);
                lastMember = member;
            }
            if (lastMember != null && lastMember.memberIsZeroLengthArray) {
                Structure struct = (Structure)this.memberDataType;
                Array array = (Array)lastMember.getDataType();
                struct.setFlexibleArrayComponent(array.getDataType(), lastMember.getName(), null);
                struct.delete(struct.getNumComponents() - 1);
            }
        } else if (this.isUnionContainer()) {
            if (this.isBitFieldUnionContainer()) {
                this.updateContainerNameAndCategoryPath("bitfield");
            } else {
                this.updateContainerNameAndCategoryPath("u");
                for (CompositeMember member : this.unionMemberList) {
                    member.finalizeDataType(0);
                }
            }
        }
        if (this.testContainerAlignment(preferredSize)) {
            ((Composite)this.memberDataType).setInternallyAligned(true);
        }
    }

    private boolean testContainerAlignment(int preferredSize) {
        Composite copy = (Composite)this.memberDataType.copy(this.dataTypeManager);
        copy.setInternallyAligned(true);
        if (preferredSize <= 0) {
            return copy.getLength() == this.memberDataType.getLength();
        }
        return copy.getLength() == preferredSize;
    }

    int getOffset() {
        return this.memberOffset;
    }

    int getLength() {
        return this.memberDataType != null ? this.memberDataType.getLength() : this.memberLength;
    }

    private void resolve() throws CancelledException {
        PdbParserNEW.WrappedDataType wrappedDataType = this.memberDataTypeResolver.resolveDataType(this);
        if (wrappedDataType != null) {
            this.memberDataType = wrappedDataType.dataType.clone(this.dataTypeManager);
            this.memberIsZeroLengthArray = wrappedDataType.isZeroLengthArray;
        }
        if (this.isContainer()) {
            this.initializeContainer();
        }
    }

    private void initializeContainer() {
        if (!(this.memberDataType instanceof Composite)) {
            throw new AssertException("Root must resolve to a composite type");
        }
        if (this.memberDataType instanceof Structure) {
            this.memberKind = "Structure";
            this.structureMemberOffsetMap = new TreeMap<Integer, CompositeMember>();
            this.structureMemberRangeMap = new RangeMap(-1);
            this.unionMemberList = null;
        } else {
            this.memberKind = "Union";
            this.unionMemberList = new ArrayList<CompositeMember>();
            this.structureMemberOffsetMap = null;
            this.structureMemberRangeMap = null;
        }
        this.isBitFieldUnion = false;
        this.bitFieldUnionLength = 0;
        this.memberLength = 0;
    }

    boolean isContainer() {
        return this.memberDataTypeName == null;
    }

    boolean isUnionContainer() {
        return this.unionMemberList != null;
    }

    boolean isStructureContainer() {
        return this.structureMemberOffsetMap != null;
    }

    boolean isBitFieldMember() {
        if (this.memberName == null || this.memberLength == 0) {
            return false;
        }
        int colonPos = this.memberName.indexOf(58);
        if (colonPos == -1) {
            return false;
        }
        int nextColonPos = this.memberName.indexOf(58, colonPos + 1);
        if (nextColonPos != -1) {
            return false;
        }
        String[] split = this.memberName.split(":");
        try {
            int bitIndex = XmlUtilities.parseInt((String)split[1]);
            if (bitIndex < 0) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean isBitFieldUnionContainer() {
        if (!this.isUnionContainer() || this.unionMemberList.size() < 2) {
            return false;
        }
        CompositeMember member0 = this.unionMemberList.get(0);
        CompositeMember member1 = this.unionMemberList.get(1);
        return member0.isBitFieldMember() && member0.isCompanionBitField(member1);
    }

    private int getDepth() {
        int depth = 0;
        CompositeMember p = this.parent;
        while (p != null) {
            p = p.parent;
            ++depth;
        }
        return depth;
    }

    public String toString() {
        String type = this.isUnionContainer() ? "Union" : (this.isStructureContainer() ? "Structure" : this.memberDataTypeName);
        return "[CompositeMember: " + this.memberOffset + " " + this.memberName + " " + type + "]";
    }

    boolean addMember(PdbMember child, TaskMonitor monitor) throws CancelledException {
        if (!this.isContainer()) {
            throw new AssertException("addMember only permitted on root members");
        }
        if (!(this.memberDataType instanceof Composite)) {
            throw new AssertException();
        }
        if (!child.memberKind.equals("Member")) {
            throw new AssertException();
        }
        return this.addMember(new CompositeMember(child, this.memberDataTypeResolver, this.dataTypeManager, monitor));
    }

    private CategoryPath getChildCategoryPath() {
        return new CategoryPath(this.memberDataType.getCategoryPath(), this.getDataTypeName());
    }

    private String getOutermostDataTypeName() {
        if (this.parent != null) {
            return this.parent.getOutermostDataTypeName();
        }
        return this.getDataTypeName();
    }

    private boolean transformIntoUnionContainer() {
        if (this.parent == null) {
            throw new AssertException();
        }
        if (this.getDepth() >= MAX_CONSTRUCTION_DEPTH) {
            Msg.error((Object)this, (Object)("PDB composite reconstruction exceeded maximum allowed depth: " + this.getOutermostDataTypeName()));
            return false;
        }
        List<CompositeMember> elderSiblings = this.kidnapElderSiblingsFromParentStructure();
        CompositeMember memberCopy = new CompositeMember(this);
        memberCopy.memberOffset = 0;
        CategoryPath tempCategoryPath = this.parent.getDataType().getCategoryPath();
        String tempName = CompositeMember.allocateTemporaryContainerName();
        UnionDataType nestedUnion = new UnionDataType(tempCategoryPath, tempName, this.dataTypeManager);
        nestedUnion.add(this.memberDataType, this.memberName, null);
        String oldName = this.memberName;
        this.memberName = tempName;
        this.memberDataType = nestedUnion;
        this.memberIsZeroLengthArray = false;
        this.memberDataTypeName = null;
        this.initializeContainer();
        this.unionMemberList.add(memberCopy);
        memberCopy.parent = this;
        if (!elderSiblings.isEmpty()) {
            memberCopy.transformIntoStructureContainer();
            for (CompositeMember sibling : elderSiblings) {
                sibling.memberOffset -= this.memberOffset;
                if (memberCopy.addStructureMember(sibling)) continue;
                return false;
            }
        }
        this.isBitFieldUnion = memberCopy.isBitFieldMember();
        if (this.isBitFieldUnion) {
            this.bitFieldUnionLength = memberCopy.memberLength;
        }
        if (this.parent != null) {
            this.parent.memberChanged(oldName, this);
        }
        return true;
    }

    private boolean transformIntoStructureContainer() {
        if (this.parent == null) {
            throw new AssertException();
        }
        if (this.getDepth() >= MAX_CONSTRUCTION_DEPTH) {
            Msg.error((Object)this, (Object)("PDB composite reconstruction exceeded maximum allowed depth: " + this.getOutermostDataTypeName()));
            return false;
        }
        CompositeMember memberCopy = new CompositeMember(this);
        memberCopy.memberOffset = 0;
        CategoryPath tempCategoryPath = this.parent.getDataType().getCategoryPath();
        String tempName = CompositeMember.allocateTemporaryContainerName();
        StructureDataType nestedStructure = new StructureDataType(tempCategoryPath, tempName, 0, this.dataTypeManager);
        nestedStructure.insertAtOffset(0, this.memberDataType, this.memberDataType.getLength(), this.memberName, this.getStructureMemberComment());
        String oldName = this.memberName;
        this.memberName = tempName;
        this.memberDataType = nestedStructure;
        this.memberIsZeroLengthArray = false;
        this.memberDataTypeName = null;
        this.initializeContainer();
        this.structureMemberRangeMap.paintRange(0L, (long)(memberCopy.getLength() - 1), 0);
        this.structureMemberOffsetMap.put(0, memberCopy);
        memberCopy.parent = this;
        if (this.parent != null) {
            this.parent.memberChanged(oldName, this);
        }
        return true;
    }

    private String getStructureMemberComment() {
        if (this.memberIsZeroLengthArray) {
            return "warning: zero length array forced to have one element";
        }
        return null;
    }

    private boolean addStructureMember(CompositeMember member) {
        int conflictOffset = this.structureMemberRangeMap.getValue((long)member.memberOffset);
        if (conflictOffset < 0) {
            this.structureMemberOffsetMap.put(member.memberOffset, member);
            this.structureMemberRangeMap.paintRange((long)member.memberOffset, (long)(member.memberOffset + member.getLength() - 1), member.memberOffset);
            member.parent = this;
            ((Structure)this.memberDataType).insertAtOffset(member.memberOffset, member.memberDataType, member.getLength(), member.memberName, member.getStructureMemberComment());
            if (this.parent != null) {
                this.parent.sizeChanged(this);
            }
            return true;
        }
        CompositeMember conflictMember = this.structureMemberOffsetMap.get(conflictOffset);
        member.memberOffset -= conflictMember.memberOffset;
        return conflictMember.addMember(member);
    }

    private boolean addUnionMember(CompositeMember member) {
        if (member.memberOffset == 0) {
            CompositeMember lastUnionMember;
            if (this.isBitFieldUnion && !this.isCompanionBitField(member)) {
                this.transformIntoUnionContainer();
                return this.addUnionMember(member);
            }
            if (!this.isBitFieldUnion && this.unionMemberList.size() != 0 && member.isBitFieldMember() && (lastUnionMember = this.unionMemberList.get(this.unionMemberList.size() - 1)).isCompanionBitField(member)) {
                return lastUnionMember.addMember(member);
            }
            this.unionMemberList.add(member);
            member.parent = this;
            ((Union)this.memberDataType).add(member.memberDataType, member.memberName, null);
            if (this.isBitFieldUnion) {
                this.bitFieldUnionLength += member.memberLength;
            }
            if (this.parent != null) {
                this.parent.sizeChanged(this);
            }
            return true;
        }
        for (CompositeMember unionMember : this.unionMemberList) {
            if ((!member.isBitFieldMember() || !unionMember.isCompanionBitField(member)) && (member.isBitFieldMember() || member.memberOffset < unionMember.memberOffset + unionMember.getLength())) continue;
            member.memberOffset -= unionMember.memberOffset;
            return unionMember.addMember(member);
        }
        CompositeMember lastUnionMember = this.unionMemberList.get(this.unionMemberList.size() - 1);
        if (lastUnionMember.isUnionContainer() && !lastUnionMember.transformIntoStructureContainer()) {
            return false;
        }
        return lastUnionMember.addMember(member);
    }

    private boolean isCompanionBitField(CompositeMember member) {
        if (!member.isBitFieldMember()) {
            return false;
        }
        if (this.isContainer()) {
            if (this.isBitFieldUnion) {
                if (this.unionMemberList.size() == 0 || member.memberOffset != 0) {
                    return false;
                }
                if (!SystemUtilities.isEqual((Object)this.unionMemberList.get((int)0).memberDataTypeName, (Object)member.memberDataTypeName)) {
                    return false;
                }
                int combinedBitfieldLength = this.bitFieldUnionLength + member.memberLength;
                return combinedBitfieldLength <= member.getDataType().getLength() * 8;
            }
            return false;
        }
        if (!this.isBitFieldMember()) {
            return false;
        }
        if (this.memberOffset != member.memberOffset) {
            return false;
        }
        return SystemUtilities.isEqual((Object)this.memberDataTypeName, (Object)member.memberDataTypeName);
    }

    private void sizeChanged(CompositeMember pdbMember) {
        if (this.structureMemberRangeMap != null) {
            this.structureMemberRangeMap.paintRange((long)pdbMember.memberOffset, (long)(pdbMember.memberOffset + pdbMember.getLength() - 1), pdbMember.memberOffset);
        }
        if (this.parent != null) {
            this.parent.sizeChanged(this);
        }
    }

    private void memberChanged(String fieldName, CompositeMember newMember) {
        if (this.isUnionContainer()) {
            Union union = (Union)this.memberDataType;
            int count = union.getNumComponents();
            for (int i = 0; i < count; ++i) {
                DataTypeComponent component = union.getComponent(i);
                if (!fieldName.equals(component.getFieldName())) continue;
                union.delete(i);
                union.insert(i, newMember.getDataType(), newMember.getLength(), newMember.memberName, null);
                break;
            }
        } else if (this.isStructureContainer()) {
            Structure struct = (Structure)this.memberDataType;
            struct.replaceAtOffset(newMember.getOffset(), newMember.getDataType(), newMember.getLength(), newMember.getName(), null);
        }
    }

    private void memberNameChanged(String oldFieldName, String newFieldName) {
        if (this.isContainer()) {
            Composite composite = (Composite)this.memberDataType;
            int count = composite.getNumComponents();
            for (int i = 0; i < count; ++i) {
                DataTypeComponent component = composite.getComponent(i);
                if (!oldFieldName.equals(component.getFieldName())) continue;
                try {
                    component.setFieldName(newFieldName);
                }
                catch (DuplicateNameException e) {
                    Msg.error((Object)this, (Object)("Failed to rename temporary component name: " + this.getDataTypeName() + "." + oldFieldName + " -> " + newFieldName));
                }
                break;
            }
        }
    }

    private int getOrdinal(String fieldName) throws NotFoundException {
        if (!this.isContainer()) {
            throw new AssertException();
        }
        Composite composite = (Composite)this.memberDataType;
        int count = composite.getNumComponents();
        for (int i = 0; i < count; ++i) {
            DataTypeComponent component = composite.getComponent(i);
            if (!fieldName.equals(component.getFieldName())) continue;
            return i;
        }
        throw new NotFoundException();
    }

    private boolean addMember(CompositeMember member) {
        if (member.memberDataType == null || member.memberDataType.getLength() <= 0) {
            return false;
        }
        if (!this.isContainer() && (member.memberOffset != 0 ? !this.transformIntoStructureContainer() : !this.transformIntoUnionContainer())) {
            return false;
        }
        if (this.isUnionContainer()) {
            return this.addUnionMember(member);
        }
        return this.addStructureMember(member);
    }

    private List<CompositeMember> kidnapElderSiblingsFromParentStructure() {
        ArrayList<CompositeMember> list = new ArrayList<CompositeMember>();
        if (this.parent == null || !this.parent.isStructureContainer()) {
            return list;
        }
        Structure parentStruct = (Structure)this.parent.memberDataType;
        for (DataTypeComponent component : parentStruct.getComponents()) {
            if (component.getOffset() <= this.memberOffset) continue;
            parentStruct.clearComponent(component.getOrdinal());
            CompositeMember member = this.parent.structureMemberOffsetMap.remove(component.getOffset());
            if (member != null) {
                list.add(member);
                continue;
            }
            if (component.getDataType() == DataType.DEFAULT) continue;
            throw new AssertException("Data Type component parsing issues " + parentStruct.getName() + " kidnapping " + component.getFieldName());
        }
        this.parent.structureMemberRangeMap.paintRange((long)(this.memberOffset + this.getLength()), (long)this.parent.getLength(), -1);
        return list;
    }

    static boolean applyDataTypeMembers(PdbParserNEW pdbParser, Composite composite, int preferredCompositeSize, XmlTreeNode compositeNode, TaskMonitor monitor) throws CancelledException {
        Composite editComposite = composite;
        CompositeMember rootMember = new CompositeMember(member -> member.isContainer() ? new PdbParserNEW.WrappedDataType((DataType)editComposite, false) : pdbParser.findDataType(member.getDataTypeName(), monitor), pdbParser.getProgramDataTypeManager());
        Iterator children = compositeNode.getChildren();
        while (children.hasNext()) {
            monitor.checkCanceled();
            XmlTreeNode child = (XmlTreeNode)children.next();
            PdbMember member2 = new PdbMember(child, monitor);
            if (!member2.memberKind.equals("Member") || rootMember.addMember(member2, monitor)) continue;
            return false;
        }
        rootMember.finalizeDataType(preferredCompositeSize);
        return true;
    }

    static interface DataTypeResolver {
        public PdbParserNEW.WrappedDataType resolveDataType(CompositeMember var1) throws CancelledException;
    }
}

