/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ArchiveRootNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import javax.swing.tree.TreePath;

public class RenameAction
extends DockingAction {
    public RenameAction(DataTypeManagerPlugin plugin) {
        super("Rename", plugin.getName());
        this.setPopupMenuData(new MenuData(new String[]{"Rename"}, null, "Edit"));
    }

    public boolean isAddToPopup(ActionContext context) {
        GTreeNode node = this.getSelectedNode(context);
        return node != null && !(node instanceof ArchiveRootNode) && !(node instanceof ArchiveNode);
    }

    public boolean isEnabledForContext(ActionContext context) {
        GTreeNode node = this.getSelectedNode(context);
        return node != null && node.isEditable();
    }

    private GTreeNode getSelectedNode(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return null;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return null;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        return node;
    }

    public void actionPerformed(ActionContext context) {
        DataTypeArchiveGTree gtree = (DataTypeArchiveGTree)((Object)context.getContextObject());
        this.rename(gtree);
    }

    void rename(DataTypeArchiveGTree tree) {
        TreePath path = tree.getSelectionPath();
        GTreeNode node = (GTreeNode)path.getLastPathComponent();
        tree.startEditing(node.getParent(), node.getName());
    }
}

