/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.util;

import docking.DialogComponentProvider;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import resources.ResourceManager;

public class ConflictDialog
extends DialogComponentProvider {
    static final int REPLACE = 1;
    static final int USE_EXISTING = 2;
    static final int RENAME = 3;
    private boolean applyToAll;
    private JRadioButton replaceRB;
    private JRadioButton useExistingRB;
    private JRadioButton renameRB;
    private JButton applyToAllButton;
    private int selectedOption = 3;
    private ImageIcon INFORM_ICON = ResourceManager.loadImage((String)"images/warning.png");

    public ConflictDialog(String dtName, String categoryPath, String newDTName) {
        super("Data Type Conflict for " + dtName);
        this.setHelpLocation(new HelpLocation("DataManagerPlugin", "DataTypeConflicts"));
        this.addWorkPanel(this.buildMainPanel(dtName, categoryPath, newDTName));
        this.addOKButton();
        this.applyToAllButton = new JButton("Apply to All");
        this.applyToAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConflictDialog.this.applyToAll = true;
                ConflictDialog.this.close();
            }
        });
        this.addButton(this.applyToAllButton);
    }

    protected void okCallback() {
        this.close();
    }

    protected void cancelCallback() {
        this.close();
    }

    int getSelectedOption() {
        return this.selectedOption;
    }

    boolean applyChoiceToAll() {
        return this.applyToAll;
    }

    private JPanel buildMainPanel(String dtName, String categoryPath, String newDTName) {
        JPanel outerPanel = new JPanel(new BorderLayout(20, 0));
        outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createTitledBorder("Resolve Data Type Conflict"));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object source = e.getSource();
                    ConflictDialog.this.selectedOption = source == ConflictDialog.this.replaceRB ? 1 : (source == ConflictDialog.this.useExistingRB ? 2 : 3);
                }
            }
        };
        ButtonGroup bg = new ButtonGroup();
        this.renameRB = new JRadioButton("Rename new data type to " + newDTName, true);
        this.replaceRB = new JRadioButton("Replace existing data type");
        this.useExistingRB = new JRadioButton("Use existing data type");
        this.renameRB.addItemListener(listener);
        this.useExistingRB.addItemListener(listener);
        this.replaceRB.addItemListener(listener);
        bg.add(this.renameRB);
        bg.add(this.replaceRB);
        bg.add(this.useExistingRB);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(this.renameRB);
        mainPanel.add(this.replaceRB);
        mainPanel.add(this.useExistingRB);
        outerPanel.add((Component)this.createLabelPanel(dtName, categoryPath), "North");
        outerPanel.add((Component)mainPanel, "Center");
        return outerPanel;
    }

    private JPanel createLabelPanel(String dtName, String categoryPath) {
        JLabel imageLabel = new JLabel(this.INFORM_ICON);
        JLabel infoLabel = new JLabel("Conflict exists in " + categoryPath + " for " + dtName);
        JPanel labelPanel = new JPanel();
        labelPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 20));
        BoxLayout bl = new BoxLayout(labelPanel, 0);
        labelPanel.setLayout(bl);
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add(imageLabel);
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add(infoLabel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(labelPanel);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
        return panel;
    }
}

