/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.navigation.locationreferences.DataTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesPlugin;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesProvider;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import java.awt.Color;

class LocationReferencesHighlighter {
    private static final String MARKER_SET_DESCRIPTION = "Shows the location of references currently displayed in the Location References window.";
    private static final String OPTIONS_TITLE = "Listing Fields";
    private static final String HIGHLIGHT_COLOR = "References Highlight.Color";
    private static Color DEFAULT_HIGHLIGHT_COLOR = new Color(168, 202, 242);
    private boolean isHighlighting = false;
    private final Navigatable navigatable;
    private LocationReferencesProvider provider;
    private LocationReferencesPlugin locationReferencesPlugin;
    private HighlightProvider highlightProvider;
    private MarkerRemover markerRemover;
    private Color highlightColor;
    private OptionsChangeListener optionsListener = new OptionsChangeListener(){

        public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
            if (name.equals(LocationReferencesHighlighter.HIGHLIGHT_COLOR)) {
                LocationReferencesHighlighter.this.highlightColor = (Color)newValue;
            }
        }
    };

    LocationReferencesHighlighter(LocationReferencesPlugin locationReferencesPlugin, LocationReferencesProvider provider, Navigatable navigatable) {
        this.locationReferencesPlugin = locationReferencesPlugin;
        this.navigatable = navigatable;
        if (provider == null) {
            throw new NullPointerException("null provider not allowed.");
        }
        this.provider = provider;
        ToolOptions options = locationReferencesPlugin.getTool().getOptions(OPTIONS_TITLE);
        options.registerOption(HIGHLIGHT_COLOR, (Object)DEFAULT_HIGHLIGHT_COLOR, null, null);
        this.highlightColor = options.getColor(HIGHLIGHT_COLOR, DEFAULT_HIGHLIGHT_COLOR);
        options.addOptionsChangeListener(this.optionsListener);
    }

    void setHighlightingEnabled(boolean enabled) {
        this.isHighlighting = enabled;
        this.updateHighlights();
    }

    private void updateHighlights() {
        PluginTool tool = this.locationReferencesPlugin.getTool();
        if (tool == null) {
            return;
        }
        if (!this.navigatable.supportsHighlight()) {
            return;
        }
        Program activeProgram = this.navigatable.getProgram();
        Program providerProgram = this.provider.getProgram();
        if (this.isHighlighting && activeProgram != providerProgram) {
            return;
        }
        LocationDescriptor locationDescriptor = this.provider.getLocationDescriptor();
        DataTypeManagerService dataTypeManagerService = (DataTypeManagerService)tool.getService(DataTypeManagerService.class);
        if (this.isHighlighting) {
            AddressSet set = this.provider.getReferenceAddresses(providerProgram);
            this.setHighlightMarkers(tool, set);
            this.highlightProvider = new LocationReferencesHighlightProvider();
            this.navigatable.setHighlightProvider(this.highlightProvider, providerProgram);
            this.selectDataType(dataTypeManagerService, locationDescriptor, true);
        } else {
            this.clearMarkers();
            this.selectDataType(dataTypeManagerService, locationDescriptor, false);
        }
    }

    private void setHighlightMarkers(PluginTool tool, AddressSet addressSet) {
        if (!this.navigatable.supportsMarkers()) {
            return;
        }
        this.clearMarkers();
        MarkerService markerService = (MarkerService)tool.getService(MarkerService.class);
        if (markerService == null) {
            return;
        }
        Program program = this.navigatable.getProgram();
        MarkerSet currentMarkerSet = markerService.createPointMarker("References To", MARKER_SET_DESCRIPTION, program, 50, false, true, false, this.highlightColor, null);
        markerService.removeMarker(currentMarkerSet, program);
        markerService.setMarkerForGroup("HIGHLIGHT_GROUP", currentMarkerSet, program);
        currentMarkerSet.add((AddressSetView)addressSet);
        this.markerRemover = new MarkerRemover(currentMarkerSet, markerService, program);
    }

    private void clearMarkers() {
        if (this.markerRemover != null) {
            this.markerRemover.dispose();
            this.markerRemover = null;
        }
        Program providerProgram = this.provider.getProgram();
        this.navigatable.removeHighlightProvider(this.highlightProvider, providerProgram);
    }

    private void selectDataType(DataTypeManagerService dataTypeManagerService, LocationDescriptor locationDescriptor, boolean enable) {
        if (!(locationDescriptor instanceof DataTypeLocationDescriptor)) {
            return;
        }
        if (dataTypeManagerService == null) {
            return;
        }
        DataTypeLocationDescriptor dataTypeDescriptor = (DataTypeLocationDescriptor)locationDescriptor;
        DataType locationDataType = null;
        if (enable) {
            locationDataType = dataTypeDescriptor.getSourceDataType();
        }
        dataTypeManagerService.setDataTypeSelected(locationDataType);
    }

    LocationReferencesProvider getCurrentHighlightProvider() {
        return this.provider;
    }

    void dispose() {
        ToolOptions options = this.locationReferencesPlugin.getTool().getOptions(OPTIONS_TITLE);
        options.removeOptionsChangeListener(this.optionsListener);
        this.clearMarkers();
    }

    private class MarkerRemover {
        private final MarkerSet markerSet;
        private final MarkerService markerSerivce;
        private final Program program;

        private MarkerRemover(MarkerSet markerSet, MarkerService markerSerivce, Program program) {
            this.markerSet = markerSet;
            this.markerSerivce = markerSerivce;
            this.program = program;
        }

        void dispose() {
            this.markerSerivce.removeMarker(this.markerSet, this.program);
        }

        public String toString() {
            return "MarkerRemover [MarkerSet=" + this.markerSet.getName() + "]";
        }
    }

    private class LocationReferencesHighlightProvider
    implements HighlightProvider {
        private final Highlight[] NO_HIGHLIGHTS = new Highlight[0];

        private LocationReferencesHighlightProvider() {
        }

        @Override
        public Highlight[] getHighlights(String text, Object obj, Class<? extends FieldFactory> fieldFactoryClass, int cursorTextOffset) {
            if (text == null) {
                return this.NO_HIGHLIGHTS;
            }
            LocationDescriptor locationDescriptor = LocationReferencesHighlighter.this.provider.getLocationDescriptor();
            return locationDescriptor.getHighlights(text, obj, fieldFactoryClass, LocationReferencesHighlighter.this.highlightColor);
        }
    }
}

