/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.ThunkData;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.DataConverter;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ImportDescriptor
implements StructConverter,
ByteArrayConverter {
    public static final String NAME = "IMAGE_IMPORT_DESCRIPTOR";
    public static final int SIZEOF = 20;
    public static final int NOT_BOUND = 0;
    private int characteristics = 0;
    private int originalFirstThunk = 0;
    private int timeDateStamp = 0;
    private int forwarderChain = 0;
    private int name = 0;
    private int firstThunk = 0;
    private String dll;
    private List<ThunkData> intList = new ArrayList<ThunkData>();
    private List<ThunkData> iatList = new ArrayList<ThunkData>();

    static ImportDescriptor createImportDescriptor(FactoryBundledWithBinaryReader reader, int index) throws IOException {
        ImportDescriptor importDescriptor = (ImportDescriptor)reader.getFactory().create(ImportDescriptor.class, new Object[0]);
        importDescriptor.initImportDescriptor(reader, index);
        return importDescriptor;
    }

    private void initImportDescriptor(FactoryBundledWithBinaryReader reader, int index) throws IOException {
        this.characteristics = reader.readInt(index);
        this.originalFirstThunk = this.characteristics;
        this.timeDateStamp = reader.readInt(index += 4);
        this.forwarderChain = reader.readInt(index += 4);
        this.name = reader.readInt(index += 4);
        this.firstThunk = reader.readInt(index += 4);
        index += 4;
    }

    void setDLL(String dll) {
        this.dll = dll;
    }

    public String getDLL() {
        return this.dll;
    }

    void addImportNameTableThunkData(ThunkData thunk) {
        this.intList.add(thunk);
    }

    void addImportAddressTableThunkData(ThunkData thunk) {
        this.iatList.add(thunk);
    }

    public ThunkData[] getImportNameTableThunkData() {
        ThunkData[] data = new ThunkData[this.intList.size()];
        this.intList.toArray(data);
        return data;
    }

    public ThunkData[] getImportAddressTableThunkData() {
        ThunkData[] data = new ThunkData[this.iatList.size()];
        this.iatList.toArray(data);
        return data;
    }

    public int getCharacteristics() {
        return this.characteristics;
    }

    public int getOriginalFirstThunk() {
        return this.originalFirstThunk;
    }

    public int getFirstThunk() {
        return this.firstThunk;
    }

    public int getForwarderChain() {
        return this.forwarderChain;
    }

    public int getName() {
        return this.name;
    }

    public int getTimeDateStamp() {
        return this.timeDateStamp;
    }

    public boolean isBound() {
        return this.timeDateStamp != 0;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        UnionDataType union = new UnionDataType("union");
        union.add(DWORD, "Characteristics", null);
        union.add(DWORD, "OriginalFirstThunk", null);
        union.setCategoryPath(new CategoryPath("/PE"));
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add((DataType)union, "union", null);
        struct.add(DWORD, "TimeDateStamp", null);
        struct.add(DWORD, "ForwarderChain", null);
        struct.add(DWORD, "Name", null);
        struct.add(DWORD, "FirstThunk", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        byte[] bytes = new byte[20];
        int pos = 0;
        dc.getBytes(this.originalFirstThunk, bytes, pos);
        dc.getBytes(this.timeDateStamp, bytes, pos += 4);
        dc.getBytes(this.forwarderChain, bytes, pos += 4);
        dc.getBytes(this.name, bytes, pos += 4);
        dc.getBytes(this.firstThunk, bytes, pos += 4);
        pos += 4;
        return bytes;
    }

    public void setOriginalFirstThunk(int i) {
        this.originalFirstThunk = i;
    }

    public void setTimeDateStamp(int i) {
        this.timeDateStamp = i;
    }

    public void setForwarderChain(int i) {
        this.forwarderChain = i;
    }

    public void setName(int i) {
        this.name = i;
    }

    public void setFirstThunk(int i) {
        this.firstThunk = i;
    }

    public boolean isNullEntry() {
        return this.characteristics == 0 && this.timeDateStamp == 0 && this.forwarderChain == 0 && this.name == 0 && this.firstThunk == 0;
    }
}

