/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.xcoff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.xcoff.XCoffFileHeader;
import ghidra.app.util.bin.format.xcoff.XCoffFileHeaderMagic;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class XCoffSectionHeader
implements StructConverter {
    private static final char NL = '\n';
    private byte[] s_name;
    private long s_paddr;
    private long s_vaddr;
    private long s_size;
    private long s_scnptr;
    private long s_relptr;
    private long s_lnnoptr;
    private int s_nreloc;
    private int s_nlnno;
    private int s_flags;
    private int _sizeof = -1;

    XCoffSectionHeader(BinaryReader reader, XCoffFileHeader header) throws IOException {
        this.s_name = reader.readNextByteArray(8);
        if (XCoffFileHeaderMagic.is32bit(header)) {
            this.s_paddr = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.s_vaddr = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.s_size = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.s_scnptr = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.s_relptr = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.s_lnnoptr = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.s_nreloc = reader.readNextShort() & 0xFFFF;
            this.s_nlnno = reader.readNextShort() & 0xFFFF;
            this.s_flags = reader.readNextShort() & 0xFFFF;
            this._sizeof = 40;
        } else if (XCoffFileHeaderMagic.is64bit(header)) {
            this.s_paddr = reader.readNextLong();
            this.s_vaddr = reader.readNextLong();
            this.s_size = reader.readNextLong();
            this.s_scnptr = reader.readNextLong();
            this.s_relptr = reader.readNextLong();
            this.s_lnnoptr = reader.readNextLong();
            this.s_nreloc = reader.readNextInt();
            this.s_nlnno = reader.readNextInt();
            this.s_flags = reader.readNextInt();
            this._sizeof = 72;
        }
    }

    public int sizeof() {
        return this._sizeof;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(XCoffSectionHeader.class);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SECTION HEADER VALUES").append('\n');
        buffer.append(new String(this.s_name)).append('\n');
        buffer.append("s_paddr = ").append(this.s_paddr).append('\n');
        buffer.append("s_vaddr = ").append(this.s_vaddr).append('\n');
        buffer.append("s_size = ").append(this.s_size).append('\n');
        buffer.append("s_scnptr = ").append(this.s_scnptr).append('\n');
        buffer.append("s_relptr = ").append(this.s_relptr).append('\n');
        buffer.append("s_lnnoptr = ").append(this.s_lnnoptr).append('\n');
        buffer.append("s_nreloc = ").append(this.s_nreloc).append('\n');
        buffer.append("s_nlnno = ").append(this.s_nlnno).append('\n');
        buffer.append("s_flags = ").append(this.s_flags).append('\n');
        return buffer.toString();
    }
}

