/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.format.pdb.PdbInfoDotNetIface;
import ghidra.app.util.bin.format.pdb.PdbInfoIface;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFLineNumber;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbol;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbolAux;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbolTable;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbolsHeader;
import ghidra.app.util.bin.format.pe.debug.DebugCodeView;
import ghidra.app.util.bin.format.pe.debug.DebugCodeViewSymbolTable;
import ghidra.app.util.bin.format.pe.debug.DebugDirectory;
import ghidra.app.util.bin.format.pe.debug.DebugDirectoryParser;
import ghidra.app.util.bin.format.pe.debug.DebugFixup;
import ghidra.app.util.bin.format.pe.debug.DebugMisc;
import ghidra.app.util.bin.format.pe.debug.DebugSymbol;
import ghidra.app.util.bin.format.pe.debug.OMFGlobal;
import ghidra.app.util.bin.format.pe.debug.OMFSrcModule;
import ghidra.app.util.bin.format.pe.debug.OMFSrcModuleFile;
import ghidra.app.util.bin.format.pe.debug.OMFSrcModuleLine;
import ghidra.app.util.datatype.microsoft.GUID;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerUtil;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Conv;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class AbstractPeDebugLoader
extends AbstractLibrarySupportLoader {
    private HashMap<Address, StringBuffer> plateCommentMap = new HashMap();
    private HashMap<Address, StringBuffer> preCommentMap = new HashMap();
    private HashMap<Address, StringBuffer> postCommentMap = new HashMap();
    private HashMap<Address, StringBuffer> eolCommentMap = new HashMap();

    AbstractPeDebugLoader() {
    }

    protected void processComments(Listing listing, TaskMonitor monitor) {
        ArrayList<HashMap<Address, StringBuffer>> maps = new ArrayList<HashMap<Address, StringBuffer>>();
        maps.add(this.plateCommentMap);
        maps.add(this.preCommentMap);
        maps.add(this.postCommentMap);
        maps.add(this.eolCommentMap);
        int[] types = new int[]{3, 1, 2, 0};
        String[] typeNames = new String[]{"PLATE", "PRE", "POST", "EOL"};
        int index = 0;
        for (HashMap hashMap : maps) {
            List<Address> list = this.convertSetToSortedList(hashMap.keySet());
            for (Address addr : list) {
                if (monitor.isCancelled()) break;
                monitor.setMessage("Setting " + typeNames[index] + " comments at " + addr);
                StringBuffer buffer = (StringBuffer)hashMap.get(addr);
                if (buffer == null) continue;
                listing.setComment(addr, types[index], buffer.toString());
            }
            if (monitor.isCancelled()) break;
            ++index;
        }
        for (HashMap hashMap : maps) {
            hashMap.clear();
        }
    }

    private List<Address> convertSetToSortedList(Set<Address> set) {
        ArrayList<Address> list = new ArrayList<Address>(set);
        Collections.sort(list);
        return list;
    }

    protected void processDebug(DebugDirectoryParser parser, Map<Integer, Address> sectionNumberToAddress, Program program, TaskMonitor monitor) {
        if (parser == null) {
            return;
        }
        monitor.setMessage("Processing misc debug...");
        this.processDebugMisc(program, parser.getDebugMisc());
        monitor.setMessage("Processing fixup debug...");
        this.processDebugFixup(parser.getDebugFixup());
        monitor.setMessage("Processing code view debug...");
        this.processDebugCodeView(parser.getDebugCodeView(), sectionNumberToAddress, program, monitor);
        monitor.setMessage("Processing coff debug...");
        this.processDebugCOFF(parser.getDebugCOFFSymbolsHeader(), sectionNumberToAddress, program, monitor);
    }

    private void processDebugCodeView(DebugCodeView dcv, Map<Integer, Address> sectionNumberToAddress, Program program, TaskMonitor monitor) {
        DebugCodeViewSymbolTable dcvst;
        PdbInfoDotNetIface dotnetPdbInfo;
        if (dcv == null) {
            return;
        }
        Options proplist = program.getOptions("Program Information");
        PdbInfoIface cvPdbInfo = dcv.getPdbInfo();
        if (cvPdbInfo != null) {
            byte[] magic = cvPdbInfo.getMagic();
            int sig = cvPdbInfo.getSig();
            int age = cvPdbInfo.getAge();
            String name = cvPdbInfo.getPdbName();
            proplist.setString("PDB Version", Conv.toString((byte[])magic));
            proplist.setString("PDB Signature", Conv.toHexString((int)sig));
            proplist.setString("PDB Age", Conv.toHexString((int)age));
            proplist.setString("PDB File", name);
        }
        if ((dotnetPdbInfo = dcv.getDotNetPdbInfo()) != null) {
            byte[] magic = dotnetPdbInfo.getMagic();
            GUID guid = dotnetPdbInfo.getGUID();
            int age = dotnetPdbInfo.getAge();
            String name = dotnetPdbInfo.getPdbName();
            proplist.setString("PDB Version", Conv.toString((byte[])magic));
            proplist.setString("PDB GUID", guid.toString());
            proplist.setString("PDB Age", Conv.toHexString((int)age));
            proplist.setString("PDB File", name);
        }
        if ((dcvst = dcv.getSymbolTable()) == null) {
            return;
        }
        List<OMFSrcModule> srcModules = dcvst.getOMFSrcModules();
        for (OMFSrcModule module : srcModules) {
            OMFSrcModuleFile[] files;
            short[] segs = module.getSegments();
            int segIndex = 0;
            for (OMFSrcModuleFile file : files = module.getOMFSrcModuleFiles()) {
                this.processFiles(file, segs[segIndex++], sectionNumberToAddress, monitor);
                this.processLineNumbers(sectionNumberToAddress, file.getOMFSrcModuleLines(), monitor);
                if (!monitor.isCancelled()) continue;
                return;
            }
            if (!monitor.isCancelled()) continue;
            return;
        }
        SymbolTable symTable = program.getSymbolTable();
        int errorCount = 0;
        List<OMFGlobal> globals = dcvst.getOMFGlobals();
        for (OMFGlobal global : globals) {
            List<DebugSymbol> symbols = global.getSymbols();
            for (DebugSymbol symbol : symbols) {
                if (monitor.isCancelled()) {
                    return;
                }
                String name = symbol.getName();
                if (name == null) continue;
                short segVal = symbol.getSection();
                int offVal = symbol.getOffset();
                if (segVal == 0 && offVal == 0) continue;
                Address address = sectionNumberToAddress.get(Conv.shortToInt((short)segVal));
                if (address != null) {
                    address = address.add(Conv.intToLong((int)offVal));
                    try {
                        symTable.createLabel(address, name, SourceType.IMPORTED);
                    }
                    catch (InvalidInputException e) {
                        Msg.error((Object)this, (Object)("Error creating label " + name + "at address " + address + ": " + e.getMessage()));
                    }
                    this.demangle(address, name, program);
                    continue;
                }
                ++errorCount;
            }
        }
        if (errorCount != 0) {
            Msg.error((Object)this, (Object)("Failed to apply " + errorCount + " debug Code View symbols contained within unknown sections."));
        }
    }

    private void demangle(Address address, String name, Program program) {
        DemangledObject demangledObj = null;
        try {
            demangledObj = DemanglerUtil.demangle(program, name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (demangledObj != null) {
            this.setComment(3, address, demangledObj.getSignature(true));
        }
    }

    private void processFiles(OMFSrcModuleFile file, short segment, Map<Integer, Address> sectionNumberToAddress, TaskMonitor monitor) {
        int[] starts = file.getStarts();
        int[] ends = file.getEnds();
        for (int k = 0; k < starts.length; ++k) {
            Address addr;
            if (starts[k] == 0 || ends[k] == 0 || (addr = sectionNumberToAddress.get(Conv.shortToInt((short)segment))) == null) continue;
            Address startAddr = addr.add(Conv.intToLong((int)starts[k]));
            String cmt = "START-> " + file.getName() + ": ?";
            this.setComment(1, startAddr, cmt);
            Address endAddr = addr.add(Conv.intToLong((int)ends[k]));
            cmt = "END-> " + file.getName() + ": ?";
            this.setComment(1, endAddr, cmt);
            if (!monitor.isCancelled()) continue;
            return;
        }
    }

    private void processLineNumbers(Map<Integer, Address> sectionNumberToAddress, OMFSrcModuleLine[] lines, TaskMonitor monitor) {
        for (OMFSrcModuleLine line : lines) {
            if (monitor.isCancelled()) {
                return;
            }
            Address addr = sectionNumberToAddress.get(Conv.shortToInt((short)line.getSegmentIndex()));
            if (addr == null) continue;
            int[] offsets = line.getOffsets();
            short[] lineNumbers = line.getLinenumbers();
            for (int j = 0; j < offsets.length; ++j) {
                if (monitor.isCancelled()) {
                    return;
                }
                if (offsets[j] == 0) {
                    System.out.println("");
                }
                if (offsets[j] == 1) {
                    System.out.println("");
                }
                if (offsets[j] <= 0) continue;
                this.addLineComment(addr.add(Conv.intToLong((int)offsets[j])), Conv.shortToInt((short)lineNumbers[j]));
            }
        }
    }

    private void processDebugCOFF(DebugCOFFSymbolsHeader dcsh, Map<Integer, Address> sectionNumberToAddress, Program program, TaskMonitor monitor) {
        DebugCOFFLineNumber[] lineNumbers;
        if (dcsh == null) {
            return;
        }
        DebugCOFFSymbolTable dcst = dcsh.getSymbolTable();
        if (dcst == null) {
            return;
        }
        DebugCOFFSymbol[] symbols = dcst.getSymbols();
        int errorCount = 0;
        for (DebugCOFFSymbol symbol : symbols) {
            if (monitor.isCancelled()) {
                return;
            }
            if (this.processDebugCoffSymbol(symbol, sectionNumberToAddress, program, monitor)) continue;
            ++errorCount;
        }
        if (errorCount != 0) {
            Msg.error((Object)this, (Object)("Failed to apply " + errorCount + " debug COFF symbols contained within unknown sections."));
        }
        if ((lineNumbers = dcsh.getLineNumbers()) != null) {
            for (DebugCOFFLineNumber lineNumber : lineNumbers) {
                if (monitor.isCancelled()) {
                    return;
                }
                if (lineNumber.getLineNumber() == 0) continue;
                this.addLineComment(program.getImageBase().add(Conv.intToLong((int)lineNumber.getVirtualAddress())), lineNumber.getLineNumber());
            }
        }
    }

    protected boolean processDebugCoffSymbol(DebugCOFFSymbol symbol, Map<Integer, Address> sectionNumberToAddress, Program program, TaskMonitor monitor) {
        DebugCOFFSymbolAux[] auxs;
        if (symbol.getSectionNumber() == 0) {
            return true;
        }
        String sym = symbol.getName();
        if (sym == null || sym.length() == 0) {
            return true;
        }
        int val = symbol.getValue();
        if (val == 0) {
            return true;
        }
        if (symbol.getSectionNumber() == -1) {
            return true;
        }
        if (symbol.getSectionNumber() == -2) {
            return true;
        }
        long symbolOffset = Conv.intToLong((int)val);
        Address address = sectionNumberToAddress.get(symbol.getSectionNumber());
        if (address == null) {
            return false;
        }
        address = address.add(symbolOffset);
        try {
            program.getSymbolTable().createLabel(address, sym, SourceType.IMPORTED);
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Error creating label named " + sym + " at address " + address + ": " + e.getMessage()));
        }
        this.demangle(address, sym, program);
        for (DebugCOFFSymbolAux aux : auxs = symbol.getAuxiliarySymbols()) {
            if (monitor.isCancelled()) break;
            if (aux == null) continue;
            this.setComment(1, address, aux.toString());
        }
        return true;
    }

    private void processDebugFixup(DebugFixup df) {
        if (df == null) {
            return;
        }
    }

    private void processDebugMisc(Program program, DebugMisc dm) {
        if (dm == null) {
            return;
        }
        String actualData = dm.getActualData();
        int datatype = dm.getDataType();
        DebugDirectory dd = dm.getDebugDirectory();
        if (dd.getAddressOfRawData() > 0) {
            Address address = program.getImageBase().add((long)dd.getAddressOfRawData());
            try {
                program.getListing().createData(address, (DataType)new StringDataType(), actualData.length());
                program.getListing().setComment(address, 3, "Debug Misc");
                address = address.add((long)actualData.length());
                program.getListing().createData(address, (DataType)new DWordDataType());
            }
            catch (CodeUnitInsertionException codeUnitInsertionException) {
                // empty catch block
            }
        }
        Options proplist = program.getOptions("Program Information");
        proplist.setString("Debug Misc", actualData);
        proplist.setString("Debug Misc Datatype", "0x" + Conv.toHexString((int)datatype));
    }

    private void addLineComment(Address addr, int line) {
        String cmt = addr + " -> Line #" + line;
        this.setComment(1, addr, cmt);
    }

    protected boolean hasComment(int type, Address address) {
        switch (type) {
            case 3: {
                return this.plateCommentMap.get(address) != null;
            }
            case 1: {
                return this.preCommentMap.get(address) != null;
            }
            case 2: {
                return this.postCommentMap.get(address) != null;
            }
            case 0: {
                return this.eolCommentMap.get(address) != null;
            }
        }
        return false;
    }

    protected void setComment(int type, Address address, String comment) {
        StringBuffer buffer = null;
        switch (type) {
            case 3: {
                buffer = this.plateCommentMap.get(address);
                if (buffer != null) break;
                buffer = new StringBuffer();
                this.plateCommentMap.put(address, buffer);
                break;
            }
            case 1: {
                buffer = this.preCommentMap.get(address);
                if (buffer != null) break;
                buffer = new StringBuffer();
                this.preCommentMap.put(address, buffer);
                break;
            }
            case 2: {
                buffer = this.postCommentMap.get(address);
                if (buffer != null) break;
                buffer = new StringBuffer();
                this.postCommentMap.put(address, buffer);
                break;
            }
            case 0: {
                buffer = this.eolCommentMap.get(address);
                if (buffer != null) break;
                buffer = new StringBuffer();
                this.eolCommentMap.put(address, buffer);
            }
        }
        if (buffer != null) {
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            buffer.append(comment);
        }
    }
}

