/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.MemoryBlockUtil;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfRelocationTable;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class MIPS_ElfRelocationHandler
extends ElfRelocationHandler {
    private static final String GP_DISP_SYMBOL_NAME = "_gp_disp";
    private static final String GP_GNU_LOCAL_SYMBOL_NAME = "__gnu_local_gp";

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 8;
    }

    public MIPS_ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, ElfRelocationTable relocationTable, Map<ElfSymbol, Address> symbolMap) {
        return new MIPS_ElfRelocationContext(this, loadHelper, relocationTable, symbolMap);
    }

    public void relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (elf.e_machine() != 8) {
            return;
        }
        MIPS_ElfRelocationContext mipsRelocationContext = (MIPS_ElfRelocationContext)elfRelocationContext;
        int type = relocation.getType();
        int symbolIndex = relocation.getSymbolIndex();
        boolean saveValueForNextReloc = mipsRelocationContext.nextRelocationHasSameOffset(relocation);
        if (elf.is64Bit()) {
            for (int n = 0; n < 3; ++n) {
                int relocType = type & 0xFF;
                int nextRelocType = n < 2 ? (type >>= 8) & 0xFF : 0;
                this.doRelocate(mipsRelocationContext, relocType, symbolIndex, relocation, relocationAddress, nextRelocType != 0 || saveValueForNextReloc);
                symbolIndex = 0;
                if (nextRelocType != 0) {
                    continue;
                }
                break;
            }
        } else {
            this.doRelocate(mipsRelocationContext, type, symbolIndex, relocation, relocationAddress, saveValueForNextReloc);
        }
    }

    private void doRelocate(MIPS_ElfRelocationContext mipsRelocationContext, int relocType, int symbolIndex, ElfRelocation relocation, Address relocationAddress, boolean saveValue) throws MemoryAccessException, NotFoundException, AddressOutOfBoundsException {
        if (relocType == 0) {
            return;
        }
        Program program = mipsRelocationContext.getProgram();
        Memory memory = program.getMemory();
        MessageLog log = mipsRelocationContext.getLog();
        long offset = (int)relocationAddress.getOffset();
        ElfSymbol elfSymbol = mipsRelocationContext.getSymbol(symbolIndex);
        long symbolValue = mipsRelocationContext.getSymbolValue(elfSymbol);
        String symbolName = elfSymbol.getNameAsString();
        long addend = 0L;
        if (mipsRelocationContext.useSavedAddend) {
            if (mipsRelocationContext.savedAddendHasError) {
                MIPS_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Stacked relocation failure", (MessageLog)log);
                mipsRelocationContext.useSavedAddend = saveValue;
                mipsRelocationContext.savedAddend = 0L;
                return;
            }
            addend = mipsRelocationContext.savedAddend;
        } else if (relocation.hasAddend()) {
            addend = relocation.getAddend();
        }
        if (!elfSymbol.isLocal()) {
            if (relocType == 20) {
                relocType = 19;
                addend = 0L;
            } else if (relocType == 146) {
                relocType = 145;
                addend = 0L;
            }
        }
        mipsRelocationContext.useSavedAddend = saveValue;
        mipsRelocationContext.savedAddendHasError = false;
        mipsRelocationContext.savedAddend = 0L;
        boolean isGpDisp = false;
        if (GP_DISP_SYMBOL_NAME.equals(symbolName)) {
            isGpDisp = true;
        } else if (GP_GNU_LOCAL_SYMBOL_NAME.equals(symbolName)) {
            MIPS_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"__gnu_local_gp relocation not yet supported", (MessageLog)log);
            if (saveValue) {
                mipsRelocationContext.savedAddendHasError = true;
            }
            return;
        }
        int oldValue = this.unshuffle(memory.getInt(relocationAddress), relocType, mipsRelocationContext);
        int value = 0;
        int newValue = 0;
        boolean writeNewValue = false;
        switch (relocType) {
            case 21: 
            case 147: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = oldValue & 0xFFFF;
                }
                long pageOffset = symbolValue + addend + 32768L & 0xFFFFFFFFFFFF0000L;
                value = (int)(symbolValue + addend - pageOffset);
                newValue = oldValue & 0xFFFF0000 | value & 0xFFFF;
                writeNewValue = true;
                break;
            }
            case 20: 
            case 146: {
                long pageOffset;
                Address gotAddr;
                if (mipsRelocationContext.extractAddend()) {
                    addend = oldValue & 0xFFFF;
                }
                if ((gotAddr = mipsRelocationContext.getSectionGotAddress(pageOffset = symbolValue + addend + 32768L & 0xFFFFFFFFFFFF0000L)) == null) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)elfSymbol.getNameAsString(), (String)("Relocation Failed, unable to allocate GOT entry for relocation symbol: " + elfSymbol.getNameAsString()), (MessageLog)mipsRelocationContext.getLog());
                    return;
                }
                value = (int)this.getGpOffset(mipsRelocationContext, gotAddr.getOffset());
                if (value == -1) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                    if (saveValue) {
                        mipsRelocationContext.savedAddendHasError = true;
                    }
                    return;
                }
                newValue = oldValue & 0xFFFF0000 | value & 0xFFFF;
                writeNewValue = true;
                break;
            }
            case 19: 
            case 22: 
            case 145: 
            case 148: {
                Address gotAddr = mipsRelocationContext.getSectionGotAddress(symbolValue);
                if (gotAddr == null) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)elfSymbol.getNameAsString(), (String)("Relocation Failed, unable to allocate GOT entry for relocation symbol: " + elfSymbol.getNameAsString()), (MessageLog)mipsRelocationContext.getLog());
                    return;
                }
                value = (int)this.getGpOffset(mipsRelocationContext, gotAddr.getOffset());
                if (value == -1) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                    if (saveValue) {
                        mipsRelocationContext.savedAddendHasError = true;
                    }
                    return;
                }
                int appliedValue = relocType == 19 ? value & 0xFFFF : value + 32768 >> 16 & 0xFFFF;
                newValue = oldValue & 0xFFFF0000 | appliedValue;
                writeNewValue = true;
                break;
            }
            case 9: 
            case 102: 
            case 138: {
                if (elfSymbol.isLocal()) {
                    MIPS_DeferredRelocation got16reloc = new MIPS_DeferredRelocation(relocType, elfSymbol, relocationAddress, oldValue, (int)addend, isGpDisp);
                    mipsRelocationContext.addGOT16Relocation(got16reloc);
                    break;
                }
            }
            case 11: 
            case 103: 
            case 142: {
                Address gotAddr = mipsRelocationContext.getSectionGotAddress(symbolValue + addend);
                if (gotAddr == null) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)elfSymbol.getNameAsString(), (String)("Relocation Failed, unable to allocate GOT entry for relocation symbol: " + elfSymbol.getNameAsString()), (MessageLog)mipsRelocationContext.getLog());
                    return;
                }
                value = (int)this.getGpOffset(mipsRelocationContext, gotAddr.getOffset());
                if (value == -1) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                    if (saveValue) {
                        mipsRelocationContext.savedAddendHasError = true;
                    }
                    return;
                }
                newValue = oldValue & 0xFFFF0000 | value & 0xFFFF;
                writeNewValue = true;
                break;
            }
            case 30: 
            case 153: {
                Address gotAddr = mipsRelocationContext.getSectionGotAddress(symbolValue + addend);
                if (gotAddr == null) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)elfSymbol.getNameAsString(), (String)("Relocation Failed, unable to allocate GOT entry for relocation symbol: " + elfSymbol.getNameAsString()), (MessageLog)mipsRelocationContext.getLog());
                    return;
                }
                value = (int)this.getGpOffset(mipsRelocationContext, gotAddr.getOffset());
                if (value == -1) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                    if (saveValue) {
                        mipsRelocationContext.savedAddendHasError = true;
                    }
                    return;
                }
                newValue = oldValue & 0xFFFF0000 | value + 32768 >> 16 & 0xFFFF;
                writeNewValue = true;
                break;
            }
            case 5: 
            case 104: 
            case 134: {
                MIPS_DeferredRelocation hi16reloc = new MIPS_DeferredRelocation(relocType, elfSymbol, relocationAddress, oldValue, (int)addend, isGpDisp);
                mipsRelocationContext.addHI16Relocation(hi16reloc);
                break;
            }
            case 6: 
            case 105: 
            case 135: 
            case 157: {
                this.processHI16Relocations(mipsRelocationContext, relocType, elfSymbol, (int)addend);
                this.processGOT16Relocations(mipsRelocationContext, relocType, elfSymbol, (int)addend);
                if (isGpDisp) {
                    value = (int)mipsRelocationContext.getGPValue();
                    if (value == -1) {
                        MIPS_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                        if (saveValue) {
                            mipsRelocationContext.savedAddendHasError = true;
                        }
                        return;
                    }
                    value = relocType == 105 ? (int)((long)value - (offset & 0xFFFFFFFFFFFFFFFCL)) : (int)((long)value - (offset - 4L));
                } else {
                    value = (int)symbolValue;
                }
                value = (int)((long)value + (mipsRelocationContext.extractAddend() ? (long)(oldValue & 0xFFFF) : addend));
                newValue = oldValue & 0xFFFF0000 | value & 0xFFFF;
                writeNewValue = true;
                break;
            }
            case 2: {
                value = (int)symbolValue;
                newValue = value = (int)((long)value + (mipsRelocationContext.extractAddend() ? (long)oldValue : addend));
                writeNewValue = true;
                break;
            }
            case 3: {
                if (symbolIndex == 0) {
                    symbolValue = program.getImageBase().getOffset();
                }
                value = (int)symbolValue;
                newValue = value = (int)((long)value + (mipsRelocationContext.extractAddend() ? (long)oldValue : addend));
                writeNewValue = true;
                break;
            }
            case 4: 
            case 100: 
            case 133: {
                int shift;
                int n = shift = relocType == 133 ? 1 : 2;
                if (mipsRelocationContext.extractAddend()) {
                    addend = oldValue;
                    addend &= 0x3FFFFFFL;
                    addend <<= shift;
                }
                value = elfSymbol.isLocal() ? (int)((addend | (offset + 4L & (long)(-67108864 << shift)) + symbolValue) >> shift) : this.signExtend((int)addend, 26 + shift) + (int)symbolValue >> shift;
                newValue = oldValue & 0xFC000000 | (value &= 0x3FFFFFF);
                writeNewValue = true;
                break;
            }
            case 10: {
                newValue = mipsRelocationContext.extractAddend() ? (oldValue & 0xFFFF) << 2 : (int)addend;
                long newValueBig = this.signExtend(newValue, 18);
                value = (int)(newValueBig += symbolValue - offset);
                newValue = oldValue & 0xFFFF0000 | (int)(newValueBig >> 2) & 0xFFFF;
                writeNewValue = true;
                break;
            }
            case 18: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = memory.getLong(relocationAddress);
                }
                long newValueBig = symbolValue + addend;
                if (saveValue) {
                    mipsRelocationContext.savedAddend = newValueBig;
                    break;
                }
                memory.setLong(relocationAddress, newValueBig);
                break;
            }
            case 28: 
            case 151: {
                long newValueBig = (mipsRelocationContext.extractAddend() ? (long)oldValue : addend) & 0xFFFFL;
                value = (int)((newValueBig += symbolValue + 0x80008000L) >> 32 & 0xFFFFL);
                newValue = oldValue & 0xFFFF0000 | value;
                writeNewValue = true;
                break;
            }
            case 29: 
            case 152: {
                long newValueBig = (mipsRelocationContext.extractAddend() ? (long)oldValue : addend) & 0xFFFFL;
                value = (int)((newValueBig += symbolValue + 0x800080008000L) >> 48 & 0xFFFFL);
                newValue = oldValue & 0xFFFF0000 | value;
                writeNewValue = true;
                break;
            }
            case 139: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = (oldValue & 0x7F0000) >> 15;
                }
                value = (int)(symbolValue + addend - offset >> 1) & 0x7F;
                newValue = oldValue & 0xFF80FFFF | value << 16;
                writeNewValue = true;
                break;
            }
            case 140: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = (oldValue & 0x3FF0000) >> 15;
                }
                value = (int)(symbolValue + addend - offset >> 1) & 0x3FF;
                newValue = oldValue & 0xFC00FFFF | value << 16;
                writeNewValue = true;
                break;
            }
            case 141: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = (oldValue & 0xFFFF) << 1;
                }
                value = (int)(symbolValue + addend - offset >> 1) & 0xFFFF;
                newValue = oldValue & 0xFFFF0000 | value;
                writeNewValue = true;
                break;
            }
            case 7: 
            case 8: 
            case 101: 
            case 136: 
            case 137: 
            case 172: {
                long gp;
                if (mipsRelocationContext.extractAddend()) {
                    addend = relocType == 172 ? (long)((oldValue & 0x7F0000) >> 14) : (long)(oldValue & 0xFFFF);
                    addend = this.signExtend((int)addend, 16);
                }
                if ((gp = mipsRelocationContext.getGPValue()) == -1L) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                    if (saveValue) {
                        mipsRelocationContext.savedAddendHasError = true;
                    }
                    return;
                }
                value = elfSymbol.isSection() ? (int)(offset - gp - 16L) : (int)(symbolValue + addend - gp);
                newValue = relocType == 172 ? oldValue & 0xFF80FFFF | (value & 0x7F) << 16 : oldValue & 0xFFFF0000 | value & 0xFFFF;
                writeNewValue = true;
                break;
            }
            case 24: 
            case 150: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = oldValue;
                }
                long newValueBig = symbolValue - addend;
                if (saveValue) {
                    mipsRelocationContext.savedAddend = newValueBig;
                    break;
                }
                memory.setLong(relocationAddress, newValueBig);
                break;
            }
            case 126: {
                MIPS_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_MIPS_COPY", (String)symbolName, (long)symbolIndex, (String)"Runtime copy not supported", (MessageLog)log);
                if (!saveValue) break;
                mipsRelocationContext.savedAddendHasError = true;
                break;
            }
            case 127: {
                if (saveValue) {
                    mipsRelocationContext.savedAddend = symbolValue;
                    break;
                }
                if (mipsRelocationContext.getElfHeader().is64Bit()) {
                    memory.setLong(relocationAddress, symbolValue);
                    break;
                }
                memory.setInt(relocationAddress, (int)symbolValue);
                break;
            }
            case 37: 
            case 156: {
                MemoryBlock block;
                boolean success = false;
                Address symAddr = mipsRelocationContext.getSymbolAddress(elfSymbol);
                if (symAddr != null && (block = memory.getBlock(symAddr)) != null) {
                    if ("EXTERNAL".equals(block.getName())) {
                        boolean bl = success = mipsRelocationContext.getLoadHelper().createExternalFunctionLinkage(symbolName, symAddr, null) != null;
                        if (success) {
                            if (relocType == 156) {
                                int offsetBits = (int)(symAddr.getOffset() >> 1) & 0x3FFFFFF;
                                int microJalrBits = 0xF4000000 | offsetBits;
                                memory.setShort(relocationAddress, (short)(microJalrBits >>> 16));
                                memory.setShort(relocationAddress.add(2L), (short)microJalrBits);
                            } else {
                                int offsetBits = (int)(symAddr.getOffset() >> 2) & 0x3FFFFFF;
                                int jalrBits = 0xC000000 | offsetBits;
                                memory.setInt(relocationAddress, jalrBits);
                            }
                        }
                    } else {
                        success = true;
                    }
                }
                if (success) break;
                MIPS_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)(relocType == 37 ? "R_MIPS_JALR" : "R_MICROMIPS_JALR"), (String)symbolName, (String)"Failed to establish external linkage", (MessageLog)log);
                break;
            }
            default: {
                MIPS_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)relocType, (long)symbolIndex, (String)elfSymbol.getNameAsString(), (MessageLog)log);
                if (!saveValue) break;
                mipsRelocationContext.savedAddendHasError = true;
            }
        }
        if (writeNewValue) {
            if (saveValue) {
                mipsRelocationContext.savedAddend = value;
            } else {
                memory.setInt(relocationAddress, this.shuffle(newValue, relocType, mipsRelocationContext));
            }
        }
    }

    private boolean isMIPS16Reloc(int type) {
        return type >= 100 && type <= 112;
    }

    private boolean isMicroMIPSReloc(int type) {
        return type >= 133 && type <= 173;
    }

    private boolean shuffleRequired(int type) {
        return this.isMIPS16Reloc(type) || this.isMicroMIPSReloc(type) && type != 139 && type != 140;
    }

    private boolean isMIPS16_26_JAL_Reloc(int type, ElfRelocationContext elfRelocationContext) {
        return type == 100 && elfRelocationContext.getElfHeader().isRelocatable();
    }

    private int unshuffle(int value, int type, ElfRelocationContext elfRelocationContext) {
        int second;
        int first;
        if (!this.shuffleRequired(type)) {
            return value;
        }
        if (elfRelocationContext.isBigEndian()) {
            first = value >>> 16;
            second = value & 0xFFFF;
        } else {
            first = value & 0xFFFF;
            second = value >>> 16;
        }
        value = this.isMIPS16_26_JAL_Reloc(type, elfRelocationContext) ? (first & 0xF800) << 16 | (second & 0xFFE0) << 11 | (first & 0x1F) << 11 | first & 0x7E0 | second & 0x1F : (this.isMicroMIPSReloc(type) || type == 100 ? first << 16 | second : (first & 0xFC00) << 16 | (first & 0x3E0) << 11 | (first & 0x1F) << 21 | second);
        return value;
    }

    private int shuffle(int value, int type, ElfRelocationContext elfRelocationContext) {
        short second;
        short first;
        if (!this.shuffleRequired(type)) {
            return value;
        }
        if (this.isMIPS16_26_JAL_Reloc(type, elfRelocationContext)) {
            first = (short)(value >> 16 & 0xF800 | value >> 11 & 0x1F | value & 0x7E0);
            second = (short)(value >> 11 & 0xFFE0 | value & 0x1F);
        } else if (this.isMicroMIPSReloc(type) || type == 100) {
            first = (short)(value >> 16);
            second = (short)value;
        } else {
            first = (short)(value >> 16 & 0xFC00 | value >> 11 & 0x3E0 | value >> 21 & 0x1F);
            second = (short)value;
        }
        value = elfRelocationContext.isBigEndian() ? first << 16 | second & 0xFFFF : second << 16 | first & 0xFFFF;
        return value;
    }

    private boolean matchingHiLo16Types(int hi16Type, int lo16Type) {
        switch (hi16Type) {
            case 5: 
            case 9: {
                return lo16Type == 6;
            }
            case 102: 
            case 104: {
                return lo16Type == 105;
            }
            case 134: 
            case 138: {
                return lo16Type == 135;
            }
        }
        return false;
    }

    private int signExtend(int val, int bits) {
        int shift = 32 - bits;
        return val << shift >> shift;
    }

    private void processHI16Relocations(MIPS_ElfRelocationContext mipsRelocationContext, int lo16RelocType, ElfSymbol lo16ElfSymbol, int lo16Addend) {
        Iterator<MIPS_DeferredRelocation> iterateHi16 = mipsRelocationContext.iterateHi16();
        while (iterateHi16.hasNext()) {
            MIPS_DeferredRelocation hi16reloc = iterateHi16.next();
            if (!this.matchingHiLo16Types(hi16reloc.relocType, lo16RelocType) || hi16reloc.elfSymbol != lo16ElfSymbol) continue;
            this.processHI16Relocation(mipsRelocationContext, hi16reloc, lo16Addend);
            iterateHi16.remove();
        }
    }

    private void processHI16Relocation(MIPS_ElfRelocationContext mipsRelocationContext, MIPS_DeferredRelocation hi16reloc, int lo16Addend) {
        int newValue;
        if (hi16reloc.isGpDisp) {
            newValue = (int)mipsRelocationContext.getGPValue();
            if (newValue == -1) {
                MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)hi16reloc.relocAddr, (String)Integer.toString(hi16reloc.relocType), (String)hi16reloc.elfSymbol.getNameAsString(), (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                return;
            }
            newValue = hi16reloc.relocType == 104 ? (int)((long)newValue - (hi16reloc.relocAddr.getOffset() + 4L & 0xFFFFFFFFFFFFFFFCL)) : (int)((long)newValue - hi16reloc.relocAddr.getOffset());
        } else {
            newValue = (int)mipsRelocationContext.getSymbolValue(hi16reloc.elfSymbol);
        }
        int addend = mipsRelocationContext.extractAddend() ? ((hi16reloc.oldValue & 0xFFFF) << 16) + lo16Addend : hi16reloc.addend;
        newValue = newValue + addend + 32768 >> 16;
        newValue = hi16reloc.oldValue & 0xFFFF0000 | newValue & 0xFFFF;
        Memory memory = mipsRelocationContext.getProgram().getMemory();
        try {
            memory.setInt(hi16reloc.relocAddr, this.shuffle(newValue, hi16reloc.relocType, mipsRelocationContext));
        }
        catch (MemoryAccessException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private void processGOT16Relocations(MIPS_ElfRelocationContext mipsRelocationContext, int lo16RelocType, ElfSymbol lo16ElfSymbol, int lo16Addend) {
        Iterator<MIPS_DeferredRelocation> iterateGot16 = mipsRelocationContext.iterateGot16();
        while (iterateGot16.hasNext()) {
            MIPS_DeferredRelocation hi16reloc = iterateGot16.next();
            if (!this.matchingHiLo16Types(hi16reloc.relocType, lo16RelocType) || hi16reloc.elfSymbol != lo16ElfSymbol) continue;
            this.processGOT16Relocation(mipsRelocationContext, hi16reloc, lo16Addend);
            iterateGot16.remove();
        }
    }

    private void processGOT16Relocation(MIPS_ElfRelocationContext mipsRelocationContext, MIPS_DeferredRelocation got16reloc, int lo16Addend) {
        long addend = mipsRelocationContext.extractAddend() ? (long)(((got16reloc.oldValue & 0xFFFF) << 16) + lo16Addend) : (long)got16reloc.addend;
        long symbolValue = (int)mipsRelocationContext.getSymbolValue(got16reloc.elfSymbol);
        String symbolName = got16reloc.elfSymbol.getNameAsString();
        long value = symbolValue + addend + 32768L & 0xFFFFFFFFFFFF0000L;
        Address gotAddr = mipsRelocationContext.getSectionGotAddress(value);
        if (gotAddr == null) {
            MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)got16reloc.relocAddr, (String)Integer.toString(got16reloc.relocType), (String)symbolName, (String)("Relocation Failed, unable to allocate GOT entry for relocation symbol: " + symbolName), (MessageLog)mipsRelocationContext.getLog());
            return;
        }
        value = this.getGpOffset(mipsRelocationContext, gotAddr.getOffset());
        if (value == -1L) {
            MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)got16reloc.relocAddr, (String)Integer.toString(got16reloc.relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
            return;
        }
        int newValue = got16reloc.oldValue & 0xFFFF0000 | (int)value & 0xFFFF;
        Memory memory = mipsRelocationContext.getProgram().getMemory();
        try {
            memory.setInt(got16reloc.relocAddr, this.shuffle(newValue, got16reloc.relocType, mipsRelocationContext));
        }
        catch (MemoryAccessException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private long getGpOffset(MIPS_ElfRelocationContext mipsRelocationContext, long value) {
        long gp = mipsRelocationContext.getGPValue();
        if (gp == -1L) {
            return -1L;
        }
        return value - gp;
    }

    private static class MIPS_DeferredRelocation {
        final int relocType;
        final ElfSymbol elfSymbol;
        final Address relocAddr;
        final int oldValue;
        final int addend;
        final boolean isGpDisp;

        MIPS_DeferredRelocation(int relocType, ElfSymbol elfSymbol, Address relocAddr, int oldValue, int addend, boolean isGpDisp) {
            this.relocType = relocType;
            this.elfSymbol = elfSymbol;
            this.relocAddr = relocAddr;
            this.oldValue = oldValue;
            this.addend = addend;
            this.isGpDisp = isGpDisp;
        }

        void markUnprocessed(MIPS_ElfRelocationContext mipsRelocationContext, String missingDependencyName) {
            ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)this.relocAddr, (String)Integer.toString(this.relocType), (String)this.elfSymbol.getNameAsString(), (String)("Relocation missing required " + missingDependencyName), (MessageLog)mipsRelocationContext.getLog());
        }
    }

    private static class MIPS_ElfRelocationContext
    extends ElfRelocationContext {
        private LinkedList<MIPS_DeferredRelocation> hi16list = new LinkedList();
        private LinkedList<MIPS_DeferredRelocation> got16list = new LinkedList();
        private AddressRange sectionGotLimits;
        private Address sectionGotAddress;
        private Address lastSectionGotEntryAddress;
        private Address nextSectionGotEntryAddress;
        private Map<Long, Address> gotMap;
        private boolean useSavedAddend = false;
        private boolean savedAddendHasError = false;
        private long savedAddend;

        MIPS_ElfRelocationContext(MIPS_ElfRelocationHandler handler, ElfLoadHelper loadHelper, ElfRelocationTable relocationTable, Map<ElfSymbol, Address> symbolMap) {
            super((ElfRelocationHandler)handler, loadHelper, relocationTable, symbolMap);
        }

        private void allocateSectionGot() {
            int alignment = this.getLoadAdapter().getLinkageBlockAlignment();
            this.sectionGotLimits = this.getLoadHelper().allocateLinkageBlock(alignment, 65536, this.getSectionGotName());
            this.nextSectionGotEntryAddress = this.sectionGotAddress = this.sectionGotLimits != null ? this.sectionGotLimits.getMinAddress() : Address.NO_ADDRESS;
            if (this.sectionGotLimits == null) {
                this.loadHelper.log("Failed to allocate " + this.getSectionGotName() + " block required for relocation processing");
            } else {
                this.loadHelper.log("Created " + this.getSectionGotName() + " block required for relocation processing (gp=0x" + Long.toHexString(this.getGPValue()) + ")");
            }
        }

        private Address getNextSectionGotEntryAddress() {
            Address addr;
            block6: {
                if (this.nextSectionGotEntryAddress == null) {
                    this.allocateSectionGot();
                }
                if ((addr = this.nextSectionGotEntryAddress) != Address.NO_ADDRESS) {
                    try {
                        int pointerSize = this.loadHelper.getProgram().getDefaultPointerSize();
                        Address lastAddr = this.nextSectionGotEntryAddress.addNoWrap((long)(pointerSize - 1));
                        if (this.sectionGotLimits.contains(lastAddr)) {
                            this.lastSectionGotEntryAddress = lastAddr;
                            this.nextSectionGotEntryAddress = this.lastSectionGotEntryAddress.addNoWrap(1L);
                            if (!this.sectionGotLimits.contains(this.nextSectionGotEntryAddress)) {
                                this.nextSectionGotEntryAddress = Address.NO_ADDRESS;
                            }
                            break block6;
                        }
                        this.nextSectionGotEntryAddress = Address.NO_ADDRESS;
                        return Address.NO_ADDRESS;
                    }
                    catch (AddressOverflowException e) {
                        this.nextSectionGotEntryAddress = Address.NO_ADDRESS;
                    }
                }
            }
            return addr != Address.NO_ADDRESS ? addr : null;
        }

        public long getGPValue() {
            long gp = this.getAdjustedGPValue();
            if (gp == -1L) {
                if (this.sectionGotAddress == null) {
                    this.allocateSectionGot();
                }
                if (this.sectionGotAddress == Address.NO_ADDRESS) {
                    return -1L;
                }
                return this.sectionGotAddress.getOffset() + 32752L;
            }
            return gp;
        }

        public boolean extractAddend() {
            return !this.relocationTable.hasAddendRelocations() && !this.useSavedAddend;
        }

        boolean nextRelocationHasSameOffset(ElfRelocation relocation) {
            ElfRelocation[] relocations = this.relocationTable.getRelocations();
            int relocIndex = relocation.getRelocationIndex();
            if (relocIndex < 0 || relocIndex >= relocations.length - 1) {
                return false;
            }
            return relocations[relocIndex].getOffset() == relocations[relocIndex + 1].getOffset() && relocations[relocIndex + 1].getType() != 0;
        }

        public Address getSectionGotAddress(long symbolValue) {
            Address addr = null;
            if (this.gotMap == null) {
                this.gotMap = new HashMap<Long, Address>();
            } else {
                addr = this.gotMap.get(symbolValue);
            }
            if (addr == null) {
                addr = this.getNextSectionGotEntryAddress();
                if (addr == null) {
                    return null;
                }
                this.gotMap.put(symbolValue, addr);
            }
            return addr;
        }

        private String getSectionGotName() {
            String sectionName = this.relocationTable.getSectionToBeRelocated().getNameAsString();
            return "%got" + sectionName;
        }

        private void createGot() {
            if (this.lastSectionGotEntryAddress == null) {
                return;
            }
            MemoryBlockUtil mbu = this.loadHelper.getMemoryBlockUtil();
            int size = (int)this.lastSectionGotEntryAddress.subtract(this.sectionGotAddress) + 1;
            String sectionName = this.relocationTable.getSectionToBeRelocated().getNameAsString();
            String blockName = this.getSectionGotName();
            try {
                MemoryBlock block = mbu.createInitializedBlock(blockName, this.sectionGotAddress, null, (long)size, "GOT for " + sectionName + " section", "MIPS-Elf Loader", true, false, false, TaskMonitor.DUMMY);
                BigEndianDataConverter converter = this.program.getMemory().isBigEndian() ? BigEndianDataConverter.INSTANCE : LittleEndianDataConverter.INSTANCE;
                for (long symbolValue : this.gotMap.keySet()) {
                    Address addr = this.gotMap.get(symbolValue);
                    byte[] bytes = this.program.getDefaultPointerSize() == 4 ? converter.getBytes((int)symbolValue) : converter.getBytes(symbolValue);
                    block.putBytes(addr, bytes);
                    this.loadHelper.createData(addr, (DataType)PointerDataType.dataType);
                }
            }
            catch (AddressOverflowException | MemoryAccessException e) {
                throw new AssertException(e);
            }
        }

        long getAdjustedGPValue() {
            Symbol symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)this.program, (String)"_mips_gp_value", err -> this.getLog().error("MIPS_ELF", err));
            if (symbol == null) {
                return -1L;
            }
            return symbol.getAddress().getOffset();
        }

        public long getSymbolValue(ElfSymbol symbol) {
            if (MIPS_ElfRelocationHandler.GP_GNU_LOCAL_SYMBOL_NAME.equals(symbol.getNameAsString())) {
                return this.getAdjustedGPValue();
            }
            return super.getSymbolValue(symbol);
        }

        Iterator<MIPS_DeferredRelocation> iterateHi16() {
            return this.hi16list.iterator();
        }

        void addHI16Relocation(MIPS_DeferredRelocation hi16reloc) {
            this.hi16list.add(hi16reloc);
        }

        Iterator<MIPS_DeferredRelocation> iterateGot16() {
            return this.got16list.iterator();
        }

        void addGOT16Relocation(MIPS_DeferredRelocation got16reloc) {
            this.got16list.add(got16reloc);
        }

        public void dispose() {
            for (MIPS_DeferredRelocation reloc : this.hi16list) {
                reloc.markUnprocessed(this, "LO16 Relocation");
            }
            this.hi16list.clear();
            for (MIPS_DeferredRelocation reloc : this.got16list) {
                reloc.markUnprocessed(this, "LO16 Relocation");
            }
            this.got16list.clear();
            this.createGot();
            super.dispose();
        }
    }
}

