/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.plugin.core.decompile.actions.CreateStructureVariableAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.FunctionParameterFieldLocation;
import ghidra.program.util.FunctionReturnTypeFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;

public class ListingStructureVariableAction
extends CreateStructureVariableAction {
    public ListingStructureVariableAction(String owner, PluginTool tool, DecompilerController controller) {
        super(owner, tool, controller);
        this.setPopupMenuData(new MenuData(new String[]{"Set Data Type", "Auto Create Structure"}, "Array"));
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        DataType dt = null;
        boolean isThisParam = false;
        if (!(context instanceof ListingActionContext)) {
            return false;
        }
        ListingActionContext listingContext = (ListingActionContext)context;
        ProgramLocation location = listingContext.getLocation();
        Program currentProgram = listingContext.getProgram();
        if (location instanceof VariableLocation) {
            VariableLocation varLoc = (VariableLocation)location;
            Variable variable = varLoc.getVariable();
            if (variable instanceof Parameter && ((Parameter)variable).getAutoParameterType() == AutoParameterType.THIS) {
                isThisParam = true;
            }
            dt = variable.getDataType();
        } else if (location instanceof FunctionParameterFieldLocation) {
            FunctionParameterFieldLocation funcPFL = (FunctionParameterFieldLocation)location;
            Parameter parameter = funcPFL.getParameter();
            if (parameter.getAutoParameterType() == AutoParameterType.THIS) {
                isThisParam = true;
            }
            dt = parameter.getDataType();
        } else if (location instanceof FunctionReturnTypeFieldLocation) {
            FunctionReturnTypeFieldLocation funcRTFL = (FunctionReturnTypeFieldLocation)location;
            Function func = currentProgram.getFunctionManager().getFunctionAt(funcRTFL.getFunctionAddress());
            dt = func.getReturnType();
        }
        if (dt == null) {
            return false;
        }
        this.adjustCreateStructureMenuText(dt, isThisParam);
        return true;
    }
}

