/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store;

import ghidra.framework.store.FileSystemListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class FileSystemListenerList
implements FileSystemListener {
    private List<FileSystemListener> listenerList = new CopyOnWriteArrayList<FileSystemListener>();
    private List<FileSystemEvent> events = Collections.synchronizedList(new LinkedList());
    private boolean enableAsynchronousDispatching;
    private boolean isEventProcessingThreadWaiting;
    private boolean alive = true;
    private Object lock = new Object();
    private Thread thread;

    public FileSystemListenerList(boolean enableAsynchronousDispatching) {
        this.enableAsynchronousDispatching = enableAsynchronousDispatching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.alive = false;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public synchronized void add(FileSystemListener listener) {
        this.listenerList.add(listener);
        if (this.thread == null && this.enableAsynchronousDispatching) {
            this.thread = new FileSystemEventProcessingThread();
            this.thread.setName("File System Listener");
            this.thread.start();
        }
    }

    public void remove(FileSystemListener listener) {
        this.listenerList.remove(listener);
    }

    public void clear() {
        this.listenerList.clear();
    }

    @Override
    public void itemMoved(String parentPath, String name, String newParentPath, String newName) {
        if (this.enableAsynchronousDispatching) {
            this.add(new ItemMovedEvent(parentPath, name, newParentPath, newName));
        } else {
            for (FileSystemListener l : this.listenerList) {
                l.itemMoved(parentPath, name, newParentPath, newName);
            }
        }
    }

    @Override
    public void itemRenamed(String parentPath, String itemName, String newName) {
        if (this.enableAsynchronousDispatching) {
            this.add(new ItemRenamedEvent(parentPath, itemName, newName));
        } else {
            for (FileSystemListener l : this.listenerList) {
                l.itemRenamed(parentPath, itemName, newName);
            }
        }
    }

    @Override
    public void itemDeleted(String parentPath, String itemName) {
        if (this.enableAsynchronousDispatching) {
            this.add(new ItemDeletedEvent(parentPath, itemName));
        } else {
            for (FileSystemListener l : this.listenerList) {
                l.itemDeleted(parentPath, itemName);
            }
        }
    }

    @Override
    public void folderRenamed(String parentPath, String folderName, String newFolderName) {
        if (this.enableAsynchronousDispatching) {
            this.add(new FolderRenamedEvent(parentPath, folderName, newFolderName));
        } else {
            for (FileSystemListener l : this.listenerList) {
                l.folderRenamed(parentPath, folderName, newFolderName);
            }
        }
    }

    @Override
    public void folderMoved(String parentPath, String folderName, String newParentPath) {
        if (this.enableAsynchronousDispatching) {
            this.add(new FolderMovedEvent(parentPath, folderName, newParentPath));
        } else {
            for (FileSystemListener l : this.listenerList) {
                l.folderMoved(parentPath, folderName, newParentPath);
            }
        }
    }

    @Override
    public void folderDeleted(String parentPath, String folderName) {
        if (this.enableAsynchronousDispatching) {
            this.add(new FolderDeletedEvent(parentPath, folderName));
        } else {
            for (FileSystemListener l : this.listenerList) {
                l.folderDeleted(parentPath, folderName);
            }
        }
    }

    @Override
    public void itemCreated(String parentPath, String itemName) {
        if (this.enableAsynchronousDispatching) {
            this.add(new ItemCreatedEvent(parentPath, itemName));
        } else {
            for (FileSystemListener l : this.listenerList) {
                l.itemCreated(parentPath, itemName);
            }
        }
    }

    @Override
    public void folderCreated(String parentPath, String folderName) {
        if (this.enableAsynchronousDispatching) {
            this.add(new FolderCreatedEvent(parentPath, folderName));
        } else {
            for (FileSystemListener l : this.listenerList) {
                l.folderCreated(parentPath, folderName);
            }
        }
    }

    @Override
    public void itemChanged(String parentPath, String itemName) {
        if (this.enableAsynchronousDispatching) {
            this.add(new ItemChangedEvent(parentPath, itemName));
        } else {
            for (FileSystemListener l : this.listenerList) {
                l.itemChanged(parentPath, itemName);
            }
        }
    }

    @Override
    public void syncronize() {
        if (this.enableAsynchronousDispatching) {
            this.add(new SynchronizeEvent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(FileSystemEvent ev) {
        if (!this.listenerList.isEmpty()) {
            this.events.add(ev);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessingEvents() {
        Object object = this;
        synchronized (object) {
            if (this.thread == null) {
                return false;
            }
        }
        object = this.lock;
        synchronized (object) {
            return !this.isEventProcessingThreadWaiting || this.events.size() > 0;
        }
    }

    private static class SynchronizeEvent
    extends FileSystemEvent {
        SynchronizeEvent() {
            super(null, null, null, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.syncronize();
        }
    }

    private static class ItemChangedEvent
    extends FileSystemEvent {
        ItemChangedEvent(String parentPath, String name) {
            super(parentPath, name, null, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.itemChanged(this.parentPath, this.name);
        }
    }

    private static class FolderCreatedEvent
    extends FileSystemEvent {
        FolderCreatedEvent(String parentPath, String name) {
            super(parentPath, name, null, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.folderCreated(this.parentPath, this.name);
        }
    }

    private static class ItemCreatedEvent
    extends FileSystemEvent {
        ItemCreatedEvent(String parentPath, String name) {
            super(parentPath, name, null, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.itemCreated(this.parentPath, this.name);
        }
    }

    private static class FolderDeletedEvent
    extends FileSystemEvent {
        FolderDeletedEvent(String parentPath, String name) {
            super(parentPath, name, null, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.folderDeleted(this.parentPath, this.name);
        }
    }

    private static class FolderRenamedEvent
    extends FileSystemEvent {
        FolderRenamedEvent(String parentPath, String name, String newName) {
            super(parentPath, name, null, newName);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.folderRenamed(this.parentPath, this.name, this.newName);
        }
    }

    private static class FolderMovedEvent
    extends FileSystemEvent {
        FolderMovedEvent(String parentPath, String name, String newParentPath) {
            super(parentPath, name, newParentPath, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.folderMoved(this.parentPath, this.name, this.newParentPath);
        }
    }

    private static class ItemDeletedEvent
    extends FileSystemEvent {
        ItemDeletedEvent(String parentPath, String name) {
            super(parentPath, name, null, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.itemDeleted(this.parentPath, this.name);
        }
    }

    private static class ItemRenamedEvent
    extends FileSystemEvent {
        ItemRenamedEvent(String parentPath, String name, String newName) {
            super(parentPath, name, null, newName);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.itemRenamed(this.parentPath, this.name, this.newName);
        }
    }

    private static class ItemMovedEvent
    extends FileSystemEvent {
        ItemMovedEvent(String parentPath, String name, String newParentPath, String newName) {
            super(parentPath, name, newParentPath, newName);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.itemMoved(this.parentPath, this.name, this.newParentPath, this.newName);
        }
    }

    private static abstract class FileSystemEvent {
        String parentPath;
        String name;
        String newParentPath;
        String newName;

        FileSystemEvent(String parentPath, String name, String newParentPath, String newName) {
            this.parentPath = parentPath;
            this.name = name;
            this.newParentPath = newParentPath;
            this.newName = newName;
        }

        abstract void dispatch(FileSystemListener var1);
    }

    private class FileSystemEventProcessingThread
    extends Thread {
        FileSystemEventProcessingThread() {
            super("File System Event Processor");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (FileSystemListenerList.this.alive) {
                while (!FileSystemListenerList.this.events.isEmpty()) {
                    FileSystemEvent event;
                    Object object = FileSystemListenerList.this.lock;
                    synchronized (object) {
                        event = FileSystemListenerList.this.events.remove(0);
                    }
                    object = FileSystemListenerList.this;
                    synchronized (object) {
                        for (FileSystemListener l : FileSystemListenerList.this.listenerList) {
                            event.dispatch(l);
                        }
                    }
                }
                this.doWait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doWait() {
            try {
                Object object = FileSystemListenerList.this.lock;
                synchronized (object) {
                    if (FileSystemListenerList.this.alive && FileSystemListenerList.this.events.isEmpty()) {
                        FileSystemListenerList.this.isEventProcessingThreadWaiting = true;
                        FileSystemListenerList.this.lock.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                FileSystemListenerList.this.isEventProcessingThreadWaiting = false;
            }
        }
    }
}

