/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.plugin.core.searchmem.RegExSearchData;
import ghidra.app.plugin.core.searchmem.SearchData;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.ListAccumulator;
import ghidra.util.search.memory.MemSearchResult;
import ghidra.util.search.memory.RegExMemSearcherAlgorithm;
import ghidra.util.search.memory.SearchInfo;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class ARMPreAnalyzer
extends AbstractAnalyzer {
    private static String DESCRIPTION = "Analyze ARM binaries for switch8_r3 functions.  This will be replaced by a general hashing algorithm next release.";

    public ARMPreAnalyzer() {
        super("ARM Pre-Pattern Analyzer", DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.BLOCK_ANALYSIS.after());
        this.setDefaultEnablement(true);
        this.setSupportsOneTimeAnalysis();
    }

    public boolean canAnalyze(Program program) {
        Processor processor = program.getLanguage().getProcessor();
        return processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"ARM"));
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        String switch_fn = "\\x01\\xc0\\x5e\\xe5\\x0c\\x00\\x53\\xe1(\\x03\\x30\\xde\\x37\\x0c\\x30\\xde\\x27|\\x0c\\x30\\xde\\x27\\x03\\x30\\xde\\x37)(\\x83\\xc0\\x8e\\xe0\\x1c\\xff\\x2f\\xe1|\\x83\\xe0\\x8e\\xe0\\x1e\\xff\\x2f\\xe1)";
        RegExSearchData searchData = RegExSearchData.createRegExSearchData((String)switch_fn);
        SearchInfo searchInfo = new SearchInfo((SearchData)searchData, 30, false, true, 4, false, null);
        AddressSet intersection = program.getMemory().getLoadedAndInitializedAddressSet().intersect(set);
        RegExMemSearcherAlgorithm searcher = new RegExMemSearcherAlgorithm(searchInfo, (AddressSetView)intersection, program, true);
        ListAccumulator accumulator = new ListAccumulator();
        searcher.search((Accumulator)accumulator, monitor);
        List results = accumulator.asList();
        for (MemSearchResult result : results) {
            Address addr = result.getAddress();
            DisassembleCommand disassembleCommand = new DisassembleCommand(addr, null, true);
            disassembleCommand.applyTo((DomainObject)program);
            CreateFunctionCmd createFunctionCmd = new CreateFunctionCmd(addr, false);
            createFunctionCmd.applyTo((DomainObject)program);
            Function func = program.getFunctionManager().getFunctionAt(addr);
            if (func != null) {
                func.setCallFixup("switch8_r3");
            }
            BookmarkManager bookmarkManager = program.getBookmarkManager();
            bookmarkManager.setBookmark(addr, "Analysis", this.getName(), "Found Switch8_r3 Function");
        }
        return true;
    }
}

