/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.fs;

import org.catacombae.jparted.lib.fs.FSAttributes;
import org.catacombae.jparted.lib.fs.FSFile;
import org.catacombae.jparted.lib.fs.FSFolder;
import org.catacombae.jparted.lib.fs.FileSystemHandler;

public abstract class FSEntry {
    protected final FileSystemHandler parentFileSystem;

    protected FSEntry(FileSystemHandler iParentFileSystem) {
        this.parentFileSystem = iParentFileSystem;
    }

    public abstract FSAttributes getAttributes();

    public abstract String getName();

    protected FileSystemHandler getParentFileSystem() {
        return this.parentFileSystem;
    }

    public boolean isFile() {
        return this instanceof FSFile;
    }

    public boolean isFolder() {
        return this instanceof FSFolder;
    }

    public FSFile asFile() {
        if (this instanceof FSFile) {
            return (FSFile)this;
        }
        throw new RuntimeException("Not a file!");
    }

    public FSFolder asFolder() {
        if (this instanceof FSFolder) {
            return (FSFolder)this;
        }
        throw new RuntimeException("Not a folder!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FILE,
        FOLDER,
        SYMLINK,
        CHARACTER_DEVICE,
        BLOCK_DEVICE,
        FIFO,
        SOCKET;

    }
}

