/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tray;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.os.Mouse;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.tools.JCLParser;
import org.rzo.yajsw.tray.Console;
import org.rzo.yajsw.tray.WrapperTrayIcon;
import org.rzo.yajsw.util.DaemonThreadFactory;
import org.rzo.yajsw.wrapper.AbstractWrappedProcessMBean;

public class WrapperTrayIconImpl
implements WrapperTrayIcon {
    volatile boolean _dialogDisplayed;
    Image iconRunning;
    Image iconIdle;
    Image iconWaitForApp;
    Image iconElse;
    Image iconOffline;
    TrayIcon ti;
    Image tiImage;
    final JPopupMenu popup = new JPopupMenu();
    Image currentImage = this.iconIdle;
    String toolTipPrefix;
    String currentToolTip;
    final SystemTray tray = SystemTray.getSystemTray();
    boolean init = false;
    Console _console = null;
    volatile AbstractWrappedProcessMBean _process;
    protected static final Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory("console"));
    volatile boolean stop = false;
    int _currentState = 0;
    JMenuItem _stopItem = new JMenuItem();
    JMenuItem _closeItem = new JMenuItem();
    JMenuItem _startItem = new JMenuItem();
    JMenuItem _restartItem = new JMenuItem();
    JMenuItem _consoleItem = new JMenuItem();
    JMenuItem _stopTimerItem = new JMenuItem();
    JMenuItem _threadDumpItem = new JMenuItem();
    JMenuItem _gcItem = new JMenuItem();
    JMenuItem _dumpHeapItem = new JMenuItem();
    JMenuItem _exitItem = new JMenuItem();
    JMenuItem _exitWrapperItem = new JMenuItem();
    JMenuItem _threadDumpWrapperItem = new JMenuItem();
    JMenuItem _closeConsoleItem = new JMenuItem();
    JMenuItem _startServiceItem = new JMenuItem();
    JMenuItem _responseItem = new JMenuItem();
    JMenuItem _updateItem = new JMenuItem();
    String _inquireMessage = null;
    boolean _waitForAppReady = false;
    volatile boolean _trayDialog = false;
    private YajswConfigurationImpl _config;
    static Mouse m = OperatingSystem.instance().mouseInstance();
    JMenuItem _stopServiceItem = new JMenuItem();
    JMenuItem _restartServiceItem = new JMenuItem();
    Color _currentUserColor = null;
    Image _baseImage;

    public WrapperTrayIconImpl(String name, String icon, YajswConfigurationImpl config) {
        List menueList;
        try {
            Class<?> cl = this.getClass().getClassLoader().loadClass("java.awt.GraphicsEnvironment");
            Method m = cl.getMethod("isHeadless", null);
            Boolean b = (Boolean)m.invoke(null, null);
            if (b.booleanValue()) {
                System.out.println("SystemTray not supported on this platform: headless");
                return;
            }
        }
        catch (Exception ex) {
            System.out.println("SystemTray not supported on this platform: " + ex.getMessage() + " error getting java.awt.GraphicsEnvironment");
            return;
        }
        if (!SystemTray.isSupported()) {
            System.out.println("SystemTray not supported on this platform");
            return;
        }
        this._config = config;
        if (this._config != null) {
            this._waitForAppReady = this._config.getBoolean("wrapper.ntservice.autoreport.waitready", false);
            this._trayDialog = this._config.getBoolean("wrapper.tray.dialog", true);
            String lookAndFeel = this._config.getString("wrapper.tray.look_and_feel", null);
            try {
                if (lookAndFeel != null && lookAndFeel.length() > 0) {
                    UIManager.setLookAndFeel(lookAndFeel);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        this._dialogDisplayed = new Boolean(false);
        this.toolTipPrefix = name + " - ";
        InputStream f = null;
        try {
            f = this.getImage(icon);
            this.ti = new TrayIcon(this.createColorImage(f, null, null));
            this.ti.setImageAutoSize(true);
            Dimension d = this.ti.getSize();
            f = this.getImage(icon);
            this.iconRunning = this.createColorImage(f, Color.GREEN, d);
            f = this.getImage(icon);
            this.iconIdle = this.createColorImage(f, Color.RED, d);
            f = this.getImage(icon);
            this.iconElse = this.createColorImage(f, Color.ORANGE, d);
            f = this.getImage(icon);
            this.iconOffline = this.createColorImage(f, Color.BLACK, d);
            f = this.getImage(icon);
            this.iconWaitForApp = this.createColorImage(f, Color.BLUE.brighter(), d);
        }
        catch (Exception ex) {
            System.out.println("System Tray: file type not supported -> abort");
            return;
        }
        this.ti = new TrayIcon(this.iconOffline);
        this.ti.setImageAutoSize(true);
        try {
            SwingUtilities.windowForComponent(this.popup.getInvoker()).setAlwaysOnTop(true);
        }
        catch (Throwable tr) {
            // empty catch block
        }
        this._exitItem.setAction(new AbstractAction("Stop Tray", WrapperTrayIconImpl.createImageIcon("/resources/exit.png")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block7: {
                    try {
                        WrapperTrayIconImpl.this._dialogDisplayed = true;
                        WrapperTrayIconImpl.this.closePopup();
                        int userChoice = 0;
                        if (WrapperTrayIconImpl.this._trayDialog) {
                            userChoice = JOptionPane.showConfirmDialog(null, WrapperTrayIconImpl.this._config.getString("wrapper.tray.text.dialog_exit_tray", "Terminate wrapper Tray ?"), UIManager.getString("OptionPane.titleText"), 0);
                        }
                        if (false != userChoice) break block7;
                        WrapperTrayIconImpl.this.closePopup();
                        WrapperTrayIconImpl.this.stop = true;
                        SystemTray systemTray = WrapperTrayIconImpl.this.tray;
                        synchronized (systemTray) {
                            WrapperTrayIconImpl.this.tray.remove(WrapperTrayIconImpl.this.ti);
                        }
                        System.exit(0);
                    }
                    finally {
                        WrapperTrayIconImpl.this._dialogDisplayed = false;
                    }
                }
            }
        });
        this._stopItem.setAction(new AbstractAction("Stop", WrapperTrayIconImpl.createImageIcon("/resources/stop.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WrapperTrayIconImpl.this._process != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                WrapperTrayIconImpl.this._dialogDisplayed = true;
                                WrapperTrayIconImpl.this.closePopup();
                                int userChoice = 0;
                                if (WrapperTrayIconImpl.this._trayDialog) {
                                    userChoice = JOptionPane.showConfirmDialog(null, WrapperTrayIconImpl.this._config.getString("wrapper.tray.text.dialog_stop", "Stop the application ?"), UIManager.getString("OptionPane.titleText"), 0);
                                }
                                if (0 == userChoice) {
                                    executor.execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                WrapperTrayIconImpl.this._process.stop("TRAY");
                                            }
                                            catch (Throwable ex) {
                                                ex.printStackTrace();
                                            }
                                        }
                                    });
                                }
                            }
                            finally {
                                WrapperTrayIconImpl.this._dialogDisplayed = false;
                            }
                        }
                    });
                }
            }
        });
        this._closeItem.setAction(new AbstractAction("Close Popup", WrapperTrayIconImpl.createImageIcon("/resources/close.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WrapperTrayIconImpl.this.closePopup();
            }
        });
        this._startItem.setAction(new AbstractAction("Start", WrapperTrayIconImpl.createImageIcon("/resources/start.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WrapperTrayIconImpl.this._process != null) {
                    try {
                        WrapperTrayIconImpl.this._process.start();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                WrapperTrayIconImpl.this.closePopup();
            }
        });
        this._restartItem.setAction(new AbstractAction("Restart", WrapperTrayIconImpl.createImageIcon("/resources/restart.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WrapperTrayIconImpl.this._process != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                WrapperTrayIconImpl.this._dialogDisplayed = true;
                                WrapperTrayIconImpl.this.closePopup();
                                int userChoice = 0;
                                if (WrapperTrayIconImpl.this._trayDialog) {
                                    userChoice = JOptionPane.showConfirmDialog(null, WrapperTrayIconImpl.this._config.getString("wrapper.tray.text.dialog_restart", "Restart the application ?"), UIManager.getString("OptionPane.titleText"), 0);
                                }
                                if (0 == userChoice) {
                                    executor.execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                WrapperTrayIconImpl.this._process.restart();
                                            }
                                            catch (Throwable ex) {
                                                ex.printStackTrace();
                                            }
                                        }
                                    });
                                }
                            }
                            finally {
                                WrapperTrayIconImpl.this._dialogDisplayed = false;
                            }
                        }
                    });
                }
            }
        });
        this._consoleItem.setAction(new AbstractAction("Console", WrapperTrayIconImpl.createImageIcon("/resources/console.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WrapperTrayIconImpl.this._process != null) {
                    WrapperTrayIconImpl.this.openConsole();
                }
                WrapperTrayIconImpl.this.closePopup();
            }
        });
        this._threadDumpItem.setAction(new AbstractAction("Thread Dump", WrapperTrayIconImpl.createImageIcon("/resources/lightning.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WrapperTrayIconImpl.this._process != null) {
                    try {
                        WrapperTrayIconImpl.this._process.threadDump();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                WrapperTrayIconImpl.this.closePopup();
            }
        });
        this._gcItem.setAction(new AbstractAction("GC", WrapperTrayIconImpl.createImageIcon("/resources/recycle.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WrapperTrayIconImpl.this._process != null) {
                    try {
                        WrapperTrayIconImpl.this._process.gc();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                WrapperTrayIconImpl.this.closePopup();
            }
        });
        this._dumpHeapItem.setAction(new AbstractAction("Dump Heap", WrapperTrayIconImpl.createImageIcon("/resources/document-save.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WrapperTrayIconImpl.this._process != null) {
                    try {
                        String s = JOptionPane.showInputDialog("Dump File Name (Empty == default) ?", (Object)"");
                        WrapperTrayIconImpl.this._process.dumpHeap(s);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                WrapperTrayIconImpl.this.closePopup();
            }
        });
        this._stopTimerItem.setAction(new AbstractAction("Stop Timer/Condition", WrapperTrayIconImpl.createImageIcon("/resources/clock_stop.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WrapperTrayIconImpl.this._process != null) {
                    try {
                        WrapperTrayIconImpl.this._process.stopTimerCondition();
                        if (WrapperTrayIconImpl.this._console != null) {
                            WrapperTrayIconImpl.this._console.setTimer(WrapperTrayIconImpl.this._process.isTimerActive());
                            WrapperTrayIconImpl.this._console.setCondition(WrapperTrayIconImpl.this._process.isConditionActive());
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                WrapperTrayIconImpl.this.closePopup();
            }
        });
        this._exitWrapperItem.setAction(new AbstractAction("Stop Wrapper", WrapperTrayIconImpl.createImageIcon("/resources/exitWrapper.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WrapperTrayIconImpl.this._process != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                WrapperTrayIconImpl.this._dialogDisplayed = true;
                                WrapperTrayIconImpl.this.closePopup();
                                int userChoice = 0;
                                if (WrapperTrayIconImpl.this._trayDialog) {
                                    userChoice = JOptionPane.showConfirmDialog(null, WrapperTrayIconImpl.this._config.getString("wrapper.tray.text.dialog_exit_wrapper", "Stop the wrapper ?"), UIManager.getString("OptionPane.titleText"), 0);
                                }
                                if (0 == userChoice) {
                                    executor.execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                WrapperTrayIconImpl.this._process.stopWrapper();
                                            }
                                            catch (Throwable ex) {
                                                ex.printStackTrace();
                                            }
                                        }
                                    });
                                }
                            }
                            finally {
                                WrapperTrayIconImpl.this._dialogDisplayed = false;
                            }
                        }
                    });
                }
            }
        });
        this._threadDumpWrapperItem.setAction(new AbstractAction("TDump Wrapper", WrapperTrayIconImpl.createImageIcon("/resources/lightning.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WrapperTrayIconImpl.this._process != null) {
                    try {
                        WrapperTrayIconImpl.this._process.wrapperThreadDump();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                WrapperTrayIconImpl.this.closePopup();
            }
        });
        this._closeConsoleItem.setAction(new AbstractAction("Close Console"){

            @Override
            public void actionPerformed(ActionEvent e) {
                WrapperTrayIconImpl.this.closeConsole();
                WrapperTrayIconImpl.this.closePopup();
            }
        });
        this._startServiceItem.setAction(new AbstractAction("Start Service", WrapperTrayIconImpl.createImageIcon("/resources/startService.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WrapperTrayIconImpl.this._process == null) {
                    WrapperTrayIconImpl.this.startService();
                }
                WrapperTrayIconImpl.this.closePopup();
            }
        });
        this._responseItem.setAction(new AbstractAction("Response", WrapperTrayIconImpl.createImageIcon("/resources/Help16.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                String message;
                String s;
                if (WrapperTrayIconImpl.this._process != null && WrapperTrayIconImpl.this._inquireMessage != null && (s = JOptionPane.showInputDialog(message = WrapperTrayIconImpl.this._inquireMessage, (Object)"")) != null && WrapperTrayIconImpl.this._process != null) {
                    try {
                        WrapperTrayIconImpl.this._process.writeInquireResponse(s);
                        WrapperTrayIconImpl.this._inquireMessage = null;
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                WrapperTrayIconImpl.this.closePopup();
            }
        });
        this._updateItem.setAction(new AbstractAction("Update", WrapperTrayIconImpl.createImageIcon("/resources/update.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s;
                if (WrapperTrayIconImpl.this._process != null && (s = JOptionPane.showInputDialog("Update configuration file", (Object)"")) != null && WrapperTrayIconImpl.this._process != null) {
                    try {
                        WrapperTrayIconImpl.this._process.update(s);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                WrapperTrayIconImpl.this.closePopup();
            }
        });
        this._stopServiceItem.setAction(new AbstractAction("Stop Service", WrapperTrayIconImpl.createImageIcon("/resources/stopService.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            WrapperTrayIconImpl.this._dialogDisplayed = true;
                            WrapperTrayIconImpl.this.closePopup();
                            int userChoice = 0;
                            if (WrapperTrayIconImpl.this._trayDialog) {
                                userChoice = JOptionPane.showConfirmDialog(null, WrapperTrayIconImpl.this._config.getString("wrapper.tray.text.dialog_restart_service", "Stop the service ?"), UIManager.getString("OptionPane.titleText"), 0);
                            }
                            if (0 == userChoice) {
                                WrapperTrayIconImpl.this.stopService();
                            }
                        }
                        finally {
                            WrapperTrayIconImpl.this._dialogDisplayed = false;
                        }
                    }
                });
            }
        });
        this._restartServiceItem.setAction(new AbstractAction("Restart Service", WrapperTrayIconImpl.createImageIcon("/resources/restartService.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            WrapperTrayIconImpl.this._dialogDisplayed = true;
                            WrapperTrayIconImpl.this.closePopup();
                            int userChoice = 0;
                            if (WrapperTrayIconImpl.this._trayDialog) {
                                userChoice = JOptionPane.showConfirmDialog(null, WrapperTrayIconImpl.this._config.getString("wrapper.tray.text.dialog_restart_service", "Restart the service ?"), UIManager.getString("OptionPane.titleText"), 0);
                            }
                            if (0 == userChoice) {
                                WrapperTrayIconImpl.this.restartService();
                            }
                        }
                        finally {
                            WrapperTrayIconImpl.this._dialogDisplayed = false;
                        }
                    }
                });
            }
        });
        List list = menueList = this._config == null ? Arrays.asList("start", "stop") : this._config.getList("wrapper.tray.commands", Arrays.asList("close", "start", "stop", "restart", "console", "response", "exitWrapper", "startService", "stopService", "restartService", "updateService", "exitTray"));
        if (menueList.contains("start")) {
            this.popup.add(this._startItem);
        }
        if (menueList.contains("stop")) {
            this.popup.add(this._stopItem);
        }
        if (menueList.contains("restart")) {
            this.popup.add(this._restartItem);
        }
        if (menueList.contains("console")) {
            this.popup.add(this._consoleItem);
        }
        if (menueList.contains("response")) {
            this.popup.add(this._responseItem);
        }
        if (menueList.contains("exitWrapper")) {
            this.popup.add(this._exitWrapperItem);
        }
        if (menueList.contains("startService")) {
            this.popup.add(this._startServiceItem);
        }
        if (menueList.contains("stopService")) {
            this.popup.add(this._stopServiceItem);
        }
        if (menueList.contains("restartService")) {
            this.popup.add(this._restartServiceItem);
        }
        if (menueList.contains("exitTray")) {
            this.popup.add(this._exitItem);
        }
        if (menueList.contains("updateService")) {
            this.popup.add(this._updateItem);
        }
        this.popup.add(this._closeItem);
        this.popup.validate();
        this.ti.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!OperatingSystem.instance().getOperatingSystemName().toLowerCase().contains("mac")) {
                    return;
                }
                if (!WrapperTrayIconImpl.this._dialogDisplayed && !WrapperTrayIconImpl.this._dialogDisplayed) {
                    int xPos = e.getXOnScreen() > WrapperTrayIconImpl.this.popup.getWidth() ? e.getXOnScreen() - WrapperTrayIconImpl.this.popup.getWidth() : e.getXOnScreen();
                    int yPos = e.getYOnScreen() > WrapperTrayIconImpl.this.popup.getHeight() ? e.getYOnScreen() - WrapperTrayIconImpl.this.popup.getHeight() : e.getYOnScreen();
                    WrapperTrayIconImpl.this.popup.show(e.getComponent(), xPos, yPos);
                    if (m != null) {
                        m.registerMouseUpListner(new Runnable(){

                            @Override
                            public void run() {
                                WrapperTrayIconImpl.this.closePopup();
                            }
                        }, executor);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!WrapperTrayIconImpl.this._dialogDisplayed && !WrapperTrayIconImpl.this._dialogDisplayed) {
                    int xPos = e.getXOnScreen() > WrapperTrayIconImpl.this.popup.getWidth() ? e.getXOnScreen() - WrapperTrayIconImpl.this.popup.getWidth() : e.getXOnScreen();
                    int yPos = e.getYOnScreen() > WrapperTrayIconImpl.this.popup.getHeight() ? e.getYOnScreen() - WrapperTrayIconImpl.this.popup.getHeight() : e.getYOnScreen();
                    WrapperTrayIconImpl.this.popup.show(e.getComponent(), xPos, yPos);
                    if (m != null) {
                        m.registerMouseUpListner(new Runnable(){

                            @Override
                            public void run() {
                                WrapperTrayIconImpl.this.closePopup();
                            }
                        }, executor);
                    }
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WrapperTrayIconImpl.this.stop = true;
                SystemTray systemTray = WrapperTrayIconImpl.this.tray;
                synchronized (systemTray) {
                    WrapperTrayIconImpl.this.tray.remove(WrapperTrayIconImpl.this.ti);
                }
            }
        });
        try {
            this.tray.add(this.ti);
        }
        catch (AWTException e1) {
            e1.printStackTrace();
            System.exit(0);
        }
        this.init = true;
    }

    private void startService() {
        try {
            int myPid = OperatingSystem.instance().processManagerInstance().currentProcessId();
            Process me = OperatingSystem.instance().processManagerInstance().getProcess(myPid);
            String cmd = me.getCommand();
            me.destroy();
            JCLParser parser = JCLParser.parse(cmd);
            String[] startCmd = new String[]{parser.getJava(), "-jar", new File(WrapperLoader.getWrapperJar()).getCanonicalPath(), "-t", parser.getArgs().get(1)};
            Process startProcess = OperatingSystem.instance().processManagerInstance().createProcess();
            startProcess.setCommand(startCmd);
            startProcess.setDebug(false);
            startProcess.start();
            startProcess.waitFor();
            startProcess.destroy();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private void stopService() {
        try {
            int myPid = OperatingSystem.instance().processManagerInstance().currentProcessId();
            Process me = OperatingSystem.instance().processManagerInstance().getProcess(myPid);
            String cmd = me.getCommand();
            me.destroy();
            JCLParser parser = JCLParser.parse(cmd);
            String[] startCmd = new String[]{parser.getJava(), "-jar", new File(WrapperLoader.getWrapperJar()).getCanonicalPath(), "-p", parser.getArgs().get(1)};
            Process startProcess = OperatingSystem.instance().processManagerInstance().createProcess();
            startProcess.setCommand(startCmd);
            startProcess.setDebug(false);
            startProcess.start();
            startProcess.waitFor();
            startProcess.destroy();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private void restartService() {
        try {
            this.stopService();
            Thread.sleep(15000L);
            this.startService();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private void closePopup() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WrapperTrayIconImpl.this.popup.setVisible(false);
                        if (m != null) {
                            m.unregisterMouseUpListner();
                        }
                    }
                });
            }
        });
    }

    private InputStream getImage(String icon) {
        InputStream f = null;
        if (icon == null) {
            f = this.findFile("/resources/console.png");
        } else {
            f = this.findFile(icon);
            if (f == null) {
                try {
                    System.out.println("System Tray: " + new File(icon).getCanonicalPath() + " not found -> default icon");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                f = this.findFile("/resources/console.png");
            }
        }
        if (f == null) {
            System.out.println("System Tray: no icon found -> abort");
            return null;
        }
        return f;
    }

    public Image getStateImage(int state) {
        switch (state) {
            case 4: {
                return this.iconRunning;
            }
            case 0: {
                return this.iconIdle;
            }
            case 11: {
                return this.iconWaitForApp;
            }
        }
        return this.iconElse;
    }

    public Image getColorImage(Color color) {
        if (this._currentUserColor == null || !this._currentUserColor.equals(color)) {
            if (color != null) {
                return this.createColorImage(this.iconElse, color, this.ti.getSize());
            }
            return this.getStateImage(this._currentState);
        }
        return null;
    }

    public String getStateToolTip(int state) {
        switch (state) {
            case 4: {
                return "Running";
            }
            case 0: {
                return "Idle";
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                return "Restarting";
            }
            case 1: {
                return "Starting";
            }
            case 3: 
            case 8: {
                return "Stopping";
            }
            case 11: {
                return "Waiting";
            }
        }
        return "Other";
    }

    @Override
    public synchronized void showState(int state) {
        Image image;
        int oldState = this._currentState;
        if (this._waitForAppReady && state == 4 && !this._process.isAppReportedReady()) {
            state = 11;
        }
        this._currentState = state;
        String strState = this.getStateToolTip(state);
        if (oldState != this._currentState) {
            this.message("STATE CHANGED", this.getStateToolTip(oldState) + " -> " + this.getStateToolTip(this._currentState));
        }
        if (this._console != null && this._process != null) {
            try {
                this._console.setState(strState);
                this._console.setAppRestartCount(this._process.getTotalRestartCount(), this._process.getRestartCount());
                this._console.setAppPid(this._process.getAppPid());
                this._console.setAppStarted(this._process.getAppStarted());
                this._console.setAppStopped(this._process.getAppStopped());
                this._console.setExitCode(this._process.getExitCode());
                this._console.setTimer(this._process.isTimerActive());
                this._console.setCondition(this._process.isConditionActive());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((image = this.getStateImage(state)) != this.currentImage) {
            this._currentUserColor = null;
            this.currentToolTip = this.toolTipPrefix + strState;
            this.showImage(image);
        }
    }

    private void showImage(Image image) {
        if (image != this.currentImage) {
            this._currentUserColor = null;
            this.ti.setImage(image);
            this.currentImage = image;
            this.ti.setToolTip(this.currentToolTip);
        }
    }

    public void showColor(Color color) {
        Image image = this.getColorImage(color);
        if (image != null) {
            this.showImage(image);
        }
    }

    static ImageIcon createImageIcon(String path) {
        Image image = WrapperTrayIconImpl.createImage(path);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    static Image createImage(String path) {
        URL imgURL = WrapperTrayIconImpl.class.getResource(path);
        if (imgURL != null) {
            return Toolkit.getDefaultToolkit().getImage(imgURL);
        }
        if (new File(path).exists()) {
            return Toolkit.getDefaultToolkit().getImage(path);
        }
        return null;
    }

    private InputStream findFile(String path) {
        InputStream result = null;
        try {
            result = this.getClass().getResourceAsStream(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result != null) {
            return result;
        }
        File f = null;
        if (result == null) {
            f = new File(path);
        }
        if (f.exists()) {
            try {
                result = new FileInputStream(f);
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Image createColorImage(Image image, Color color, Dimension d) {
        if (d != null) {
            BufferedImage bufferedResizedImage = new BufferedImage(d.width, d.height, 1);
            Graphics2D g2d = bufferedResizedImage.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.drawImage(image, 0, 0, d.width, d.height, null);
            g2d.dispose();
            image = bufferedResizedImage;
        }
        if (color != null) {
            Graphics g = image.getGraphics();
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            int rw = w / 2;
            int rh = h / 2;
            Color c = new Color(color.getRed(), color.getGreen(), color.getBlue(), 200);
            g.setColor(c);
            g.fillRoundRect(0, h - rh, rw, rh, rw, rh);
        }
        return image;
    }

    private Image createColorImage(InputStream imageFile, Color color, Dimension d) throws Exception {
        BufferedImage image = ImageIO.read(imageFile);
        imageFile.close();
        return this.createColorImage(image, color, d);
    }

    public static void main(String[] args) throws InterruptedException {
        WrapperTrayIconImpl t = new WrapperTrayIconImpl("test", null, null);
        Thread.sleep(2000L);
        t.showState(4);
        Thread.sleep(2000L);
        t.showState(0);
        Thread.sleep(2000L);
        t.showState(2);
    }

    @Override
    public boolean isInit() {
        return this.init;
    }

    public void openConsole() {
        if (this._console != null) {
            return;
        }
        this._console = new Console(this);
        this._console.setWrapperPid(this._process.getWrapperPid());
        this._console.setWrapperStarted(this._process.getWrapperStarted());
        this._console.setWrapperType(this._process.getType());
    }

    @Override
    public void closeConsole() {
        if (this._console == null) {
            return;
        }
        this._console.close();
        this._console = null;
    }

    @Override
    public void error(String caption, String message) {
        this.ti.displayMessage(this.toolTipPrefix + caption, message, TrayIcon.MessageType.ERROR);
    }

    @Override
    public void info(String caption, String message) {
        this.ti.displayMessage(this.toolTipPrefix + caption, message, TrayIcon.MessageType.INFO);
    }

    @Override
    public void message(String caption, String message) {
        this.ti.displayMessage(this.toolTipPrefix + caption, message, TrayIcon.MessageType.NONE);
    }

    @Override
    public void warning(String caption, String message) {
        this.ti.displayMessage(this.toolTipPrefix + caption, message, TrayIcon.MessageType.WARNING);
    }

    @Override
    public void setProcess(AbstractWrappedProcessMBean proxy) {
        this._process = proxy;
        if (this._process == null) {
            Image image = this.iconOffline;
            if (image != this.currentImage) {
                this.ti.setImage(image);
                this.currentImage = image;
                this.currentToolTip = this.toolTipPrefix + "OFFLINE";
                this.ti.setToolTip(this.currentToolTip);
                this.message("STATE CHANGED", this.currentToolTip);
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this._exitWrapperItem.setEnabled(true);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WrapperTrayIconImpl.this._exitWrapperItem.setEnabled(true);
                    }
                });
            }
        }
    }

    @Override
    public boolean isStop() {
        return this.stop;
    }
}

