/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.simpleframework.transport.Appender;
import org.simpleframework.transport.Packet;
import org.simpleframework.transport.PacketException;
import org.simpleframework.transport.PacketManager;
import org.simpleframework.transport.Wrapper;

class PacketAllocator {
    private final PacketManager manager;
    private final AtomicLong count;

    public PacketAllocator() {
        this(3);
    }

    public PacketAllocator(int allow) {
        this(allow, 4096);
    }

    public PacketAllocator(int allow, int size) {
        this.manager = new PacketManager(allow, size);
        this.count = new AtomicLong();
    }

    public Packet allocate() throws PacketException {
        long sequence = this.count.getAndIncrement();
        ByteBuffer buffer = this.manager.allocate();
        return new Appender(buffer, this.manager, sequence);
    }

    public Packet allocate(ByteBuffer buffer) throws PacketException {
        long sequence = this.count.getAndIncrement();
        return new Wrapper(buffer, sequence);
    }
}

