/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndex;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/CliVirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "index", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndex;", "scope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "(Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndex;Lcom/intellij/psi/search/GlobalSearchScope;)V", "findBinaryClass", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "fileName", "", "findBuiltInsData", "Ljava/io/InputStream;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "findMetadata", "findVirtualFileWithHeader", "hasMetadataPackage", "", "fqName", "cli"})
public final class CliVirtualFileFinder
extends VirtualFileFinder {
    private final JvmDependenciesIndex index;
    private final GlobalSearchScope scope;

    @Override
    @Nullable
    public VirtualFile findVirtualFileWithHeader(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        StringBuilder stringBuilder = new StringBuilder();
        String string = classId.getRelativeClassName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classId.relativeClassName.asString()");
        return this.findBinaryClass(classId, stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'$', (boolean)false, (int)4, null)).append(".class").toString());
    }

    @Override
    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        boolean bl = !classId.isNestedClass();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Nested classes are not supported here: " + classId;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        VirtualFile virtualFile2 = this.findBinaryClass(classId, classId.getShortClassName().asString() + ".kotlin_metadata");
        return virtualFile2 != null ? virtualFile2.getInputStream() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasMetadataPackage(@NotNull FqName fqName2) {
        void found;
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        JvmDependenciesIndex.DefaultImpls.traverseDirectoriesInPackage$default(this.index, fqName2, null, (Function2)new Function2<VirtualFile, JavaRoot.RootType, Boolean>((Ref.BooleanRef)found){
            final /* synthetic */ Ref.BooleanRef $found;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull VirtualFile dir, @NotNull JavaRoot.RootType $noName_1) {
                boolean bl;
                boolean bl2;
                block1: {
                    void $this$any$iv;
                    Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$noName_1), (String)"<anonymous parameter 1>");
                    boolean bl3 = this.$found.element;
                    VirtualFile[] virtualFileArray = dir.getChildren();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"dir.children");
                    VirtualFile[] virtualFileArray2 = virtualFileArray;
                    bl2 = bl3;
                    Ref.BooleanRef booleanRef = this.$found;
                    boolean $i$f$any = false;
                    void var5_7 = $this$any$iv;
                    int n = ((void)var5_7).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = var5_7[i];
                        boolean bl4 = false;
                        void v2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                        if (!Intrinsics.areEqual((Object)v2.getExtension(), (Object)"kotlin_metadata")) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                boolean bl5 = bl;
                booleanRef.element = bl2 | bl5;
                return !this.$found.element;
            }
            {
                this.$found = booleanRef;
                super(2);
            }
        }, 2, null);
        return found.element;
    }

    @Override
    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        ClassId classId = new ClassId(packageFqName, Name.special("<builtins-metadata>"));
        VirtualFile virtualFile2 = this.findBinaryClass(classId, BuiltInSerializerProtocol.INSTANCE.getBuiltInsFileName(packageFqName));
        return virtualFile2 != null ? virtualFile2.getInputStream() : null;
    }

    private final VirtualFile findBinaryClass(ClassId classId, String fileName) {
        VirtualFile virtualFile2;
        VirtualFile virtualFile3 = (VirtualFile)this.index.findClass(classId, JavaRoot.RootTypes.getOnlyBinary(), (Function2)new Function2<VirtualFile, JavaRoot.RootType, VirtualFile>(fileName){
            final /* synthetic */ String $fileName;

            @Nullable
            public final VirtualFile invoke(@NotNull VirtualFile dir, @NotNull JavaRoot.RootType $noName_1) {
                VirtualFile virtualFile2;
                Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                Intrinsics.checkParameterIsNotNull((Object)((Object)$noName_1), (String)"<anonymous parameter 1>");
                VirtualFile virtualFile3 = dir.findChild(this.$fileName);
                if (virtualFile3 != null) {
                    VirtualFile virtualFile4 = virtualFile3;
                    boolean bl = false;
                    boolean bl2 = false;
                    VirtualFile p1 = virtualFile4;
                    boolean bl3 = false;
                    virtualFile2 = p1.isValid() ? virtualFile4 : null;
                } else {
                    virtualFile2 = null;
                }
                return virtualFile2;
            }
            {
                this.$fileName = string;
                super(2);
            }
        });
        if (virtualFile3 != null) {
            VirtualFile virtualFile4 = virtualFile3;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile4;
            boolean bl3 = false;
            virtualFile2 = this.scope.contains(it) ? virtualFile4 : null;
        } else {
            virtualFile2 = null;
        }
        return virtualFile2;
    }

    public CliVirtualFileFinder(@NotNull JvmDependenciesIndex index2, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        this.index = index2;
        this.scope = scope;
    }
}

