/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.operation.IncrementTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;

public final class UnaryOperationTranslator {
    private UnaryOperationTranslator() {
    }

    @NotNull
    public static JsExpression translate(@NotNull KtUnaryExpression expression2, @NotNull TranslationContext context) {
        Object baseExpression;
        IElementType operationToken;
        if (expression2 == null) {
            UnaryOperationTranslator.$$$reportNull$$$1(0);
        }
        if (context == null) {
            UnaryOperationTranslator.$$$reportNull$$$1(1);
        }
        if (expression2 == null) {
            UnaryOperationTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            UnaryOperationTranslator.$$$reportNull$$$0(1);
        }
        if ((operationToken = expression2.getOperationReference().getReferencedNameElementType()) == KtTokens.EXCLEXCL) {
            KtExpression baseExpression2 = PsiUtils.getBaseExpression(expression2);
            JsExpression translatedExpression = Translation.translateAsExpression(baseExpression2, context);
            JsExpression jsExpression = TranslationUtils.sure(baseExpression2, translatedExpression, context);
            if (jsExpression == null) {
                UnaryOperationTranslator.$$$reportNull$$$0(2);
            }
            if (jsExpression == null) {
                UnaryOperationTranslator.$$$reportNull$$$1(2);
            }
            return jsExpression;
        }
        if (operationToken == KtTokens.MINUS && (baseExpression = PsiUtils.getBaseExpression(expression2)) instanceof KtConstantExpression) {
            CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression2, context.bindingContext());
            assert (compileTimeValue != null) : ErrorReportingUtils.message(expression2, "Expression is not compile time value: " + expression2.getText() + " ");
            Object value = BindingUtils.getCompileTimeValue(context.bindingContext(), expression2, compileTimeValue);
            if (value instanceof Long) {
                JsExpression jsExpression = JsAstUtils.newLong((Long)value);
                if (jsExpression == null) {
                    UnaryOperationTranslator.$$$reportNull$$$0(3);
                }
                if (jsExpression == null) {
                    UnaryOperationTranslator.$$$reportNull$$$1(3);
                }
                return jsExpression;
            }
        }
        if (IncrementTranslator.isIncrement(operationToken)) {
            JsExpression jsExpression = IncrementTranslator.translate(expression2, context);
            if (jsExpression == null) {
                UnaryOperationTranslator.$$$reportNull$$$0(4);
            }
            if (jsExpression == null) {
                UnaryOperationTranslator.$$$reportNull$$$1(4);
            }
            return jsExpression;
        }
        baseExpression = TranslationUtils.translateBaseExpression(context, expression2);
        if (UnaryOperationTranslator.isExclForBinaryEqualLikeExpr(expression2, (JsExpression)baseExpression)) {
            JsExpression jsExpression = TranslationUtils.translateExclForBinaryEqualLikeExpr((JsBinaryOperation)baseExpression);
            if (jsExpression == null) {
                UnaryOperationTranslator.$$$reportNull$$$0(5);
            }
            if (jsExpression == null) {
                UnaryOperationTranslator.$$$reportNull$$$1(5);
            }
            return jsExpression;
        }
        ResolvedCall<? extends FunctionDescriptor> resolvedCall2 = CallUtilKt.getFunctionResolvedCallWithAssert(expression2, context.bindingContext());
        JsExpression jsExpression = CallTranslator.translate(context, resolvedCall2, (JsExpression)baseExpression);
        if (jsExpression == null) {
            UnaryOperationTranslator.$$$reportNull$$$0(6);
        }
        if (jsExpression == null) {
            UnaryOperationTranslator.$$$reportNull$$$1(6);
        }
        return jsExpression;
    }

    private static boolean isExclForBinaryEqualLikeExpr(@NotNull KtUnaryExpression expression2, @NotNull JsExpression baseExpression) {
        if (expression2 == null) {
            UnaryOperationTranslator.$$$reportNull$$$1(7);
        }
        if (baseExpression == null) {
            UnaryOperationTranslator.$$$reportNull$$$1(8);
        }
        if (expression2 == null) {
            UnaryOperationTranslator.$$$reportNull$$$0(7);
        }
        if (baseExpression == null) {
            UnaryOperationTranslator.$$$reportNull$$$0(8);
        }
        if (PsiUtils.getOperationToken(expression2).equals(KtTokens.EXCL) && baseExpression instanceof JsBinaryOperation) {
            return TranslationUtils.isEqualLikeOperator(((JsBinaryOperation)baseExpression).getOperator());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isExclForBinaryEqualLikeExpr";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isExclForBinaryEqualLikeExpr";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

