/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationDetails;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationType;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.protocol.events.InternalOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalPluginIdentifier;
import org.gradle.tooling.internal.provider.BuildClientSubscriptions;
import org.gradle.tooling.internal.provider.events.AbstractTaskResult;
import org.gradle.tooling.internal.provider.events.DefaultFailure;
import org.gradle.tooling.internal.provider.events.DefaultTaskDescriptor;
import org.gradle.tooling.internal.provider.events.DefaultTaskFailureResult;
import org.gradle.tooling.internal.provider.events.DefaultTaskFinishedProgressEvent;
import org.gradle.tooling.internal.provider.events.DefaultTaskSkippedResult;
import org.gradle.tooling.internal.provider.events.DefaultTaskStartedProgressEvent;
import org.gradle.tooling.internal.provider.events.DefaultTaskSuccessResult;
import org.gradle.tooling.internal.provider.events.OperationResultPostProcessor;
import org.gradle.tooling.internal.provider.runner.OperationDependenciesResolver;
import org.gradle.tooling.internal.provider.runner.OperationDependencyLookup;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;
import org.gradle.tooling.internal.provider.runner.SubtreeFilteringBuildOperationListener;
import org.gradle.tooling.internal.provider.runner.TaskOriginTracker;

class ClientForwardingTaskOperationListener
extends SubtreeFilteringBuildOperationListener<ExecuteTaskBuildOperationDetails>
implements OperationDependencyLookup {
    private final Map<TaskIdentity<?>, DefaultTaskDescriptor> descriptors = new ConcurrentHashMap();
    private final OperationResultPostProcessor operationResultPostProcessor;
    private final TaskOriginTracker taskOriginTracker;
    private final OperationDependenciesResolver operationDependenciesResolver;

    ClientForwardingTaskOperationListener(ProgressEventConsumer eventConsumer, BuildClientSubscriptions clientSubscriptions, BuildOperationListener delegate, OperationResultPostProcessor operationResultPostProcessor, TaskOriginTracker taskOriginTracker, OperationDependenciesResolver operationDependenciesResolver) {
        super(eventConsumer, clientSubscriptions, delegate, OperationType.TASK, ExecuteTaskBuildOperationDetails.class);
        this.operationResultPostProcessor = operationResultPostProcessor;
        this.taskOriginTracker = taskOriginTracker;
        this.operationDependenciesResolver = operationDependenciesResolver;
    }

    @Override
    public InternalOperationDescriptor lookupExistingOperationDescriptor(Node node) {
        if (this.isEnabled() && node instanceof TaskNode) {
            TaskNode taskNode = (TaskNode)node;
            return (InternalOperationDescriptor)this.descriptors.get(taskNode.getTask().getTaskIdentity());
        }
        return null;
    }

    @Override
    protected InternalOperationStartedProgressEvent toStartedEvent(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent, ExecuteTaskBuildOperationDetails details) {
        return new DefaultTaskStartedProgressEvent(startEvent.getStartTime(), this.toTaskDescriptor(buildOperation, details));
    }

    @Override
    protected InternalOperationFinishedProgressEvent toFinishedEvent(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent, ExecuteTaskBuildOperationDetails details) {
        TaskInternal task = details.getTask();
        AbstractTaskResult taskResult = this.operationResultPostProcessor.process(ClientForwardingTaskOperationListener.toTaskResult(task, finishEvent), (Object)buildOperation.getId());
        return new DefaultTaskFinishedProgressEvent(finishEvent.getEndTime(), this.toTaskDescriptor(buildOperation, details), taskResult);
    }

    private DefaultTaskDescriptor toTaskDescriptor(BuildOperationDescriptor buildOperation, ExecuteTaskBuildOperationDetails details) {
        return this.descriptors.computeIfAbsent(details.getTask().getTaskIdentity(), taskIdentity -> {
            OperationIdentifier id = buildOperation.getId();
            String taskIdentityPath = buildOperation.getName();
            String displayName = buildOperation.getDisplayName();
            String taskPath = taskIdentity.identityPath.getPath();
            Object parentId = this.eventConsumer.findStartedParentId(buildOperation);
            Set<InternalOperationDescriptor> dependencies = this.operationDependenciesResolver.resolveDependencies((Node)details.getTaskNode());
            InternalPluginIdentifier originPlugin = this.taskOriginTracker.getOriginPlugin((TaskIdentity<?>)taskIdentity);
            return new DefaultTaskDescriptor((Object)id, taskIdentityPath, taskPath, displayName, parentId, dependencies, originPlugin);
        });
    }

    private static AbstractTaskResult toTaskResult(TaskInternal task, OperationFinishEvent finishEvent) {
        boolean incremental;
        TaskStateInternal state = task.getState();
        long startTime = finishEvent.getStartTime();
        long endTime = finishEvent.getEndTime();
        ExecuteTaskBuildOperationType.Result result = (ExecuteTaskBuildOperationType.Result)finishEvent.getResult();
        boolean bl = incremental = result != null && result.isIncremental();
        if (state.getUpToDate()) {
            return new DefaultTaskSuccessResult(startTime, endTime, true, state.isFromCache(), state.getSkipMessage(), incremental, Collections.emptyList());
        }
        if (state.getSkipped()) {
            return new DefaultTaskSkippedResult(startTime, endTime, state.getSkipMessage(), incremental);
        }
        List executionReasons = result != null ? result.getUpToDateMessages() : null;
        Throwable failure = finishEvent.getFailure();
        if (failure == null) {
            return new DefaultTaskSuccessResult(startTime, endTime, false, state.isFromCache(), "SUCCESS", incremental, executionReasons);
        }
        return new DefaultTaskFailureResult(startTime, endTime, Collections.singletonList(DefaultFailure.fromThrowable((Throwable)failure)), incremental, executionReasons);
    }
}

