/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.Optional;
import java.util.SortedMap;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.execution.AfterPreviousExecutionContext;
import org.gradle.internal.execution.BeforeExecutionContext;
import org.gradle.internal.execution.CachingResult;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.impl.DefaultBeforeExecutionState;
import org.gradle.internal.execution.impl.OutputFilterUtil;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureStateBeforeExecutionStep
implements Step<AfterPreviousExecutionContext, CachingResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptureStateBeforeExecutionStep.class);
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ValueSnapshotter valueSnapshotter;
    private final Step<? super BeforeExecutionContext, ? extends CachingResult> delegate;

    public CaptureStateBeforeExecutionStep(ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ValueSnapshotter valueSnapshotter, Step<? super BeforeExecutionContext, ? extends CachingResult> delegate) {
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.valueSnapshotter = valueSnapshotter;
        this.delegate = delegate;
    }

    @Override
    public CachingResult execute(final AfterPreviousExecutionContext context) {
        final BeforeExecutionState beforeExecutionState = context.getWork().isTaskHistoryMaintained() ? this.createExecutionState(context) : null;
        return this.delegate.execute(new BeforeExecutionContext(){

            @Override
            public Optional<BeforeExecutionState> getBeforeExecutionState() {
                return Optional.ofNullable(beforeExecutionState);
            }

            @Override
            public Optional<String> getRebuildReason() {
                return context.getRebuildReason();
            }

            @Override
            public Optional<AfterPreviousExecutionState> getAfterPreviousExecutionState() {
                return context.getAfterPreviousExecutionState();
            }

            @Override
            public UnitOfWork getWork() {
                return context.getWork();
            }
        });
    }

    private BeforeExecutionState createExecutionState(AfterPreviousExecutionContext context) {
        Optional<AfterPreviousExecutionState> afterPreviousExecutionState = context.getAfterPreviousExecutionState();
        UnitOfWork work = context.getWork();
        ImplementationsBuilder implementationsBuilder = new ImplementationsBuilder(this.classLoaderHierarchyHasher);
        work.visitImplementations(implementationsBuilder);
        ImplementationSnapshot implementation = implementationsBuilder.getImplementation();
        ImmutableList<ImplementationSnapshot> additionalImplementations = implementationsBuilder.getAdditionalImplementations();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Implementation for {}: {}", (Object)work.getDisplayName(), (Object)implementation);
            LOGGER.debug("Additional implementations for {}: {}", (Object)work.getDisplayName(), additionalImplementations);
        }
        ImmutableSortedMap previousInputProperties = afterPreviousExecutionState.map(state -> state.getInputProperties()).orElse(ImmutableSortedMap.of());
        ImmutableSortedMap previousOutputFiles = afterPreviousExecutionState.map(state -> state.getOutputFileProperties()).orElse(ImmutableSortedMap.of());
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = CaptureStateBeforeExecutionStep.fingerprintInputProperties(work, (ImmutableSortedMap<String, ValueSnapshot>)previousInputProperties, this.valueSnapshotter);
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles = CaptureStateBeforeExecutionStep.fingerprintInputFiles(work);
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputFiles = CaptureStateBeforeExecutionStep.fingerprintOutputFiles((ImmutableSortedMap<String, FileCollectionFingerprint>)previousOutputFiles, work.getOutputFileSnapshotsBeforeExecution(), work.hasOverlappingOutputs());
        return new DefaultBeforeExecutionState(implementation, additionalImplementations, inputProperties, inputFiles, outputFiles);
    }

    private static ImmutableSortedMap<String, ValueSnapshot> fingerprintInputProperties(UnitOfWork work, ImmutableSortedMap<String, ValueSnapshot> previousSnapshots, ValueSnapshotter valueSnapshotter) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        work.visitInputProperties((propertyName, value) -> {
            try {
                ValueSnapshot previousSnapshot = (ValueSnapshot)previousSnapshots.get((Object)propertyName);
                if (previousSnapshot == null) {
                    builder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(value));
                } else {
                    builder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(value, previousSnapshot));
                }
            }
            catch (Exception e) {
                throw new UncheckedIOException(String.format("Unable to store input properties for %s. Property '%s' with value '%s' cannot be serialized.", work.getDisplayName(), propertyName, value), (Throwable)e);
            }
        });
        return builder.build();
    }

    private static ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fingerprintInputFiles(UnitOfWork work) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        work.visitInputFileProperties((propertyName, value, incremental, fingerprinter) -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Fingerprinting property {} for {}", (Object)propertyName, (Object)work.getDisplayName());
            }
            CurrentFileCollectionFingerprint result = (CurrentFileCollectionFingerprint)fingerprinter.get();
            builder.put((Object)propertyName, (Object)result);
        });
        return builder.build();
    }

    private static ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fingerprintOutputFiles(ImmutableSortedMap<String, FileCollectionFingerprint> previousOutputFingerprints, ImmutableSortedMap<String, FileSystemSnapshot> beforeExecutionOutputSnapshots, boolean hasOverlappingOutputs) {
        return ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(beforeExecutionOutputSnapshots, (key, outputSnapshot) -> {
            FileCollectionFingerprint previousOutputFingerprint = (FileCollectionFingerprint)previousOutputFingerprints.get(key);
            return previousOutputFingerprint == null ? AbsolutePathFingerprintingStrategy.IGNORE_MISSING.getEmptyFingerprint() : CaptureStateBeforeExecutionStep.fingerprintOutputSnapshot(outputSnapshot, previousOutputFingerprint, hasOverlappingOutputs);
        }));
    }

    private static CurrentFileCollectionFingerprint fingerprintOutputSnapshot(FileSystemSnapshot beforeExecutionOutputSnapshots, FileCollectionFingerprint previousOutputFingerprint, boolean hasOverlappingOutputs) {
        ImmutableList<FileSystemSnapshot> roots = hasOverlappingOutputs ? OutputFilterUtil.filterOutputSnapshotBeforeExecution(previousOutputFingerprint, beforeExecutionOutputSnapshots) : ImmutableList.of((Object)beforeExecutionOutputSnapshots);
        return DefaultCurrentFileCollectionFingerprint.from(roots, (FingerprintingStrategy)AbsolutePathFingerprintingStrategy.IGNORE_MISSING);
    }

    private static class ImplementationsBuilder
    implements UnitOfWork.ImplementationVisitor {
        private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
        private ImplementationSnapshot implementation;
        private final ImmutableList.Builder<ImplementationSnapshot> additionalImplementations = ImmutableList.builder();

        public ImplementationsBuilder(ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
            this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        }

        @Override
        public void visitImplementation(Class<?> implementation) {
            this.visitImplementation(ImplementationSnapshot.of(implementation, (ClassLoaderHierarchyHasher)this.classLoaderHierarchyHasher));
        }

        @Override
        public void visitImplementation(ImplementationSnapshot implementation) {
            if (this.implementation != null) {
                throw new IllegalStateException("Implementation already set");
            }
            this.implementation = implementation;
        }

        @Override
        public void visitAdditionalImplementation(ImplementationSnapshot implementation) {
            this.additionalImplementations.add((Object)implementation);
        }

        public ImplementationSnapshot getImplementation() {
            if (this.implementation == null) {
                throw new IllegalStateException("No implementation is set");
            }
            return this.implementation;
        }

        public ImmutableList<ImplementationSnapshot> getAdditionalImplementations() {
            return this.additionalImplementations.build();
        }
    }
}

