/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JceX448;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceX448Domain
implements TlsECDomain {
    protected final JcaTlsCrypto crypto;

    public JceX448Domain(JcaTlsCrypto jcaTlsCrypto) {
        this.crypto = jcaTlsCrypto;
    }

    public JceTlsSecret calculateECDHAgreement(PrivateKey privateKey, PublicKey publicKey) throws IOException {
        try {
            byte[] byArray = this.crypto.calculateKeyAgreement("X448", privateKey, publicKey, "TlsPremasterSecret");
            if (byArray == null || byArray.length != 56) {
                throw new TlsCryptoException("invalid secret calculated");
            }
            if (Arrays.areAllZeroes((byte[])byArray, (int)0, (int)byArray.length)) {
                throw new TlsFatalAlert(40);
            }
            return this.crypto.adoptLocalSecret(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("cannot calculate secret", generalSecurityException);
        }
    }

    public TlsAgreement createECDH() {
        return new JceX448(this);
    }

    public PublicKey decodePublicKey(byte[] byArray) throws IOException {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(EdECObjectIdentifiers.id_X448);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, byArray);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded("DER"));
            KeyFactory keyFactory = this.crypto.getHelper().createKeyFactory("X448");
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(47, (Throwable)exception);
        }
    }

    public byte[] encodePublicKey(PublicKey publicKey) throws IOException {
        try {
            if ("X.509".equals(publicKey.getFormat())) {
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
                return subjectPublicKeyInfo.getPublicKeyData().getOctets();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new TlsFatalAlert(80);
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("X448");
            keyPairGenerator.initialize(256, this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException("unable to create key pair: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }
}

