"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_konva_1 = require("react-konva");
var renderprops_konva_cjs_1 = require("react-spring/renderprops-konva.cjs");
var fast_deep_equal_1 = require("../../../../utils/fast_deep_equal");
var rendering_props_utils_1 = require("./utils/rendering_props_utils");
var rendering_1 = require("../../rendering/rendering");
var BarGeometries = /** @class */ (function (_super) {
    __extends(BarGeometries, _super);
    function BarGeometries(props) {
        var _this = _super.call(this, props) || this;
        _this.barSeriesRef = react_1.default.createRef();
        _this.renderBarGeoms = function (bars) {
            var overBar = _this.state.overBar;
            var sharedStyle = _this.props.sharedStyle;
            return bars.map(function (bar, index) {
                var x = bar.x, y = bar.y, width = bar.width, height = bar.height, color = bar.color, seriesStyle = bar.seriesStyle;
                // Properties to determine if we need to highlight individual bars depending on hover state
                var hasGeometryHover = overBar != null;
                var hasHighlight = overBar === bar;
                var individualHighlight = {
                    hasGeometryHover: hasGeometryHover,
                    hasHighlight: hasHighlight,
                };
                var geometryStyle = rendering_1.getGeometryStateStyle(bar.seriesIdentifier, _this.props.highlightedLegendItem, sharedStyle, individualHighlight);
                var key = "bar-" + index;
                if (_this.props.animated) {
                    return (react_1.default.createElement(react_konva_1.Group, { key: index },
                        react_1.default.createElement(renderprops_konva_cjs_1.Spring, { native: true, from: { y: y + height, height: 0 }, to: { y: y, height: height } }, function (props) {
                            var barPropsBorder = rendering_props_utils_1.buildBarBorderRenderProps(x, props.y, width, props.height, seriesStyle.rect, seriesStyle.rectBorder, geometryStyle);
                            var barProps = rendering_props_utils_1.buildBarRenderProps(x, props.y, width, props.height, color, seriesStyle.rect, seriesStyle.rectBorder, geometryStyle);
                            return (react_1.default.createElement(react_1.default.Fragment, { key: key },
                                react_1.default.createElement(renderprops_konva_cjs_1.animated.Rect, __assign({}, barProps)),
                                barPropsBorder && react_1.default.createElement(renderprops_konva_cjs_1.animated.Rect, __assign({}, barPropsBorder))));
                        })));
                }
                else {
                    var barPropsBorder = rendering_props_utils_1.buildBarBorderRenderProps(x, y, width, height, seriesStyle.rect, seriesStyle.rectBorder, geometryStyle);
                    var barProps = rendering_props_utils_1.buildBarRenderProps(x, y, width, height, color, seriesStyle.rect, seriesStyle.rectBorder, geometryStyle);
                    return (react_1.default.createElement(react_1.default.Fragment, { key: key },
                        react_1.default.createElement(react_konva_1.Rect, __assign({}, barProps)),
                        barPropsBorder && react_1.default.createElement(react_konva_1.Rect, __assign({}, barPropsBorder))));
                }
            });
        };
        _this.barSeriesRef = react_1.default.createRef();
        _this.state = {
            overBar: undefined,
        };
        return _this;
    }
    BarGeometries.prototype.shouldComponentUpdate = function (nextProps, nextState) {
        return !fast_deep_equal_1.deepEqual(this.props, nextProps) || !fast_deep_equal_1.deepEqual(this.state, nextState);
    };
    BarGeometries.prototype.render = function () {
        var _a = this.props, bars = _a.bars, clippings = _a.clippings;
        return (react_1.default.createElement(react_konva_1.Group, __assign({ ref: this.barSeriesRef, key: 'bar_series' }, clippings), this.renderBarGeoms(bars)));
    };
    BarGeometries.defaultProps = {
        animated: false,
    };
    return BarGeometries;
}(react_1.default.Component));
exports.BarGeometries = BarGeometries;
//# sourceMappingURL=bar_geometries.js.map