"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var specs_1 = require("../utils/specs");
var scales_1 = require("../../../utils/scales/scales");
var spec_factory_1 = require("../../../state/spec_factory");
var chart_types_1 = require("../../../chart_types");
var defaultProps = {
    chartType: chart_types_1.ChartTypes.XYAxis,
    specType: specs_1.SpecTypes.Series,
    seriesType: specs_1.SeriesTypes.Area,
    groupId: specs_1.DEFAULT_GLOBAL_ID,
    xScaleType: scales_1.ScaleType.Ordinal,
    yScaleType: scales_1.ScaleType.Linear,
    xAccessor: 'x',
    yAccessors: ['y'],
    yScaleToDataExtent: false,
    hideInLegend: false,
    histogramModeAlignment: specs_1.HistogramModeAlignments.Center,
};
exports.AreaSeries = spec_factory_1.getConnect()(spec_factory_1.specComponentFactory(defaultProps));
//# sourceMappingURL=area_series.js.map