/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import javax.swing.text.BadLocationException;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.SourceInfo;

class CreateFileWindow
implements Runnable {
    Main db;
    SourceInfo sourceInfo;
    int line;
    boolean activate;

    private CreateFileWindow() {
    }

    static Runnable action(Main db, SourceInfo sourceInfo, int line) {
        CreateFileWindow obj = new CreateFileWindow();
        obj.db = db;
        obj.sourceInfo = sourceInfo;
        obj.line = line;
        obj.activate = true;
        return obj;
    }

    static Runnable action(Main db, SourceInfo sourceInfo, int line, boolean activate) {
        CreateFileWindow obj = new CreateFileWindow();
        obj.db = db;
        obj.sourceInfo = sourceInfo;
        obj.line = line;
        obj.activate = activate;
        return obj;
    }

    @Override
    public void run() {
        String url = this.sourceInfo.getUrl();
        FileWindow w = new FileWindow(this.db, this.sourceInfo);
        this.db.fileWindows.put(url, w);
        if (this.line != -1) {
            if (this.db.currentWindow != null) {
                this.db.currentWindow.setPosition(-1);
            }
            try {
                w.setPosition(w.textArea.getLineStartOffset(this.line - 1));
            }
            catch (BadLocationException exc) {
                try {
                    w.setPosition(w.textArea.getLineStartOffset(0));
                }
                catch (BadLocationException ee) {
                    w.setPosition(-1);
                }
            }
        }
        this.db.desk.add(w);
        if (this.line != -1) {
            this.db.currentWindow = w;
        }
        w.setVisible(true);
        if (this.activate) {
            try {
                w.setMaximum(true);
                w.setSelected(true);
                w.moveToFront();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

