/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.output.pageable;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jfree.layouting.input.style.keys.border.BorderStyle;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.BorderCorner;
import org.jfree.layouting.renderer.border.BorderEdge;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.util.geom.StrictGeomUtility;
import org.jfree.layouting.util.geom.StrictInsets;

public class BorderShapeFactory {
    private static final int CORNER_RIGHT_TOP = 0;
    private static final int CORNER_TOP_RIGHT = 1;
    private static final int CORNER_TOP_LEFT = 2;
    private static final int CORNER_LEFT_TOP = 3;
    private static final int CORNER_LEFT_BOTTOM = 4;
    private static final int CORNER_BOTTOM_LEFT = 5;
    private static final int CORNER_BOTTOM_RIGHT = 6;
    private static final int CORNER_RIGHT_BOTTOM = 7;
    private static final byte[][] CORNER_FACTORS = new byte[][]{{1, 1}, {1, 1}, {-1, 1}, {-1, 1}, {1, -1}, {1, -1}, {-1, -1}, {-1, -1}};
    private Color color;
    private BasicStroke stroke;
    private double height;
    private double width;
    private double x;
    private double y;
    private Border border;
    private StrictInsets borderSizes;
    private ArrayList drawOps = new ArrayList();
    private ArrayList fillOps = new ArrayList();
    private CSSColorValue backgroundColor;

    public BorderShapeFactory(RenderBox renderBox) {
        this.border = renderBox.getBorder();
        ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
        StrictInsets strictInsets = new StrictInsets(computedLayoutProperties.getBorderTop(), computedLayoutProperties.getBorderLeft(), computedLayoutProperties.getBorderBottom(), computedLayoutProperties.getBorderRight());
        this.x = StrictGeomUtility.toExternalValue(renderBox.getX() + strictInsets.getLeft() / 2L);
        this.y = StrictGeomUtility.toExternalValue(renderBox.getY() + strictInsets.getTop() / 2L);
        this.width = StrictGeomUtility.toExternalValue(renderBox.getWidth() - (strictInsets.getLeft() + strictInsets.getRight()) / 2L);
        this.height = StrictGeomUtility.toExternalValue(renderBox.getHeight() - (strictInsets.getTop() + strictInsets.getBottom()) / 2L);
        this.borderSizes = strictInsets;
        this.backgroundColor = renderBox.getBoxDefinition().getBackgroundColor();
    }

    private Arc2D generateCorner(int n, double d, double d2, BorderCorner borderCorner, boolean bl) {
        if (borderCorner.getHeight().getValue() == 0L || borderCorner.getWidth().getValue() == 0L) {
            return null;
        }
        byte[] byArray = CORNER_FACTORS[n];
        double d3 = StrictGeomUtility.toExternalValue(borderCorner.getWidth().getValue());
        double d4 = StrictGeomUtility.toExternalValue(borderCorner.getHeight().getValue());
        int n2 = bl ? 2 : 0;
        return new Arc2D.Double(d + d3 * (double)byArray[0], d2 + d4 * (double)byArray[1], d3, d4, Math.PI * (double)n / 4.0, 0.7853981633974483, n2);
    }

    private BasicStroke createStroke(BorderEdge borderEdge, long l) {
        float f = (float)StrictGeomUtility.toExternalValue(l);
        if (BorderStyle.DASHED.equals(borderEdge.getBorderStyle())) {
            return new BasicStroke(f, 2, 0, 10.0f, new float[]{6.0f * f, 6.0f * f}, 0.0f);
        }
        if (BorderStyle.DOTTED.equals(borderEdge.getBorderStyle())) {
            return new BasicStroke(f, 2, 0, 5.0f, new float[]{0.0f, 2.0f * f}, 0.0f);
        }
        if (BorderStyle.DOT_DASH.equals(borderEdge.getBorderStyle())) {
            return new BasicStroke(f, 2, 0, 10.0f, new float[]{0.0f, 2.0f * f, 6.0f * f, 2.0f * f}, 0.0f);
        }
        if (BorderStyle.DOT_DOT_DASH.equals(borderEdge.getBorderStyle())) {
            return new BasicStroke(f, 2, 0, 10.0f, new float[]{0.0f, 2.0f * f, 0.0f, 2.0f * f, 6.0f * f, 2.0f * f}, 0.0f);
        }
        return new BasicStroke(f);
    }

    public void generateBorder(Graphics2D graphics2D) {
        BorderDrawOperation borderDrawOperation;
        int n;
        this.generateTopEdge();
        this.generateLeftEdge();
        this.generateBottomEdge();
        this.generateRightEdge();
        for (n = 0; n < this.drawOps.size(); ++n) {
            borderDrawOperation = (BorderDrawOperation)this.drawOps.get(n);
            borderDrawOperation.draw(graphics2D);
        }
        for (n = 0; n < this.fillOps.size(); ++n) {
            borderDrawOperation = (BorderDrawOperation)this.fillOps.get(n);
            borderDrawOperation.fill(graphics2D);
        }
        if (this.backgroundColor == null || this.backgroundColor.getAlpha() == 0) {
            return;
        }
        Area area = new Area(new Rectangle2D.Double(this.x, this.y, this.width, this.height));
        for (int i = 0; i < this.fillOps.size(); ++i) {
            BorderDrawOperation borderDrawOperation2 = (BorderDrawOperation)this.fillOps.get(i);
            Shape shape = borderDrawOperation2.shape;
            if (shape == null) continue;
            Area area2 = new Area(shape.getBounds2D());
            area2.subtract(new Area(shape));
            area.subtract(area2);
        }
        graphics2D.setColor(this.backgroundColor);
        graphics2D.fill(area);
    }

    private void draw(Shape shape) {
        if (shape == null) {
            return;
        }
        this.drawOps.add(new BorderDrawOperation(shape, this.color, this.stroke));
    }

    private void fill(Shape shape) {
        if (shape == null) {
            return;
        }
        this.fillOps.add(new BorderDrawOperation(shape, this.color, this.stroke));
    }

    private void generateRightEdge() {
        BorderEdge borderEdge = this.border.getRight();
        this.color = borderEdge.getColor();
        this.stroke = this.createStroke(borderEdge, this.borderSizes.getRight());
        BorderCorner borderCorner = this.border.getBottomRight();
        BorderCorner borderCorner2 = this.border.getTopRight();
        this.draw(this.generateCorner(7, this.x + this.width, this.y + this.height, borderCorner, false));
        this.draw(this.generateCorner(0, this.x + this.width, this.y, borderCorner2, false));
        this.fill(this.generateCorner(7, this.x + this.width, this.y + this.height, borderCorner, true));
        this.fill(this.generateCorner(0, this.x + this.width, this.y, borderCorner2, true));
        this.draw(new Line2D.Double(this.x + this.width - (double)borderCorner.getWidth().getValue(), this.y + this.height - (double)borderCorner.getHeight().getValue(), this.x + this.width - (double)borderCorner2.getWidth().getValue(), this.y + (double)borderCorner2.getHeight().getValue()));
    }

    private void generateBottomEdge() {
        BorderEdge borderEdge = this.border.getBottom();
        BorderCorner borderCorner = this.border.getBottomLeft();
        BorderCorner borderCorner2 = this.border.getBottomRight();
        this.color = borderEdge.getColor();
        this.stroke = this.createStroke(borderEdge, this.borderSizes.getBottom());
        this.draw(this.generateCorner(5, this.x, this.y + this.height, borderCorner, false));
        this.draw(this.generateCorner(6, this.x + this.width, this.y + this.height, borderCorner2, false));
        this.fill(this.generateCorner(5, this.x, this.y + this.height, borderCorner, true));
        this.fill(this.generateCorner(6, this.x + this.width, this.y + this.height, borderCorner2, true));
        this.draw(new Line2D.Double(this.x + (double)borderCorner.getWidth().getValue(), this.y + this.height - (double)borderCorner.getHeight().getValue(), this.x + this.width - (double)borderCorner2.getWidth().getValue(), this.y + this.height - (double)borderCorner2.getHeight().getValue()));
    }

    private void generateLeftEdge() {
        BorderEdge borderEdge = this.border.getLeft();
        BorderCorner borderCorner = this.border.getTopLeft();
        BorderCorner borderCorner2 = this.border.getBottomLeft();
        this.stroke = this.createStroke(borderEdge, this.borderSizes.getLeft());
        this.color = borderEdge.getColor();
        this.draw(this.generateCorner(3, this.x, this.y, borderCorner, false));
        this.draw(this.generateCorner(4, this.x, this.y + this.height, borderCorner2, false));
        this.fill(this.generateCorner(3, this.x, this.y, borderCorner, true));
        this.fill(this.generateCorner(4, this.x, this.y + this.height, borderCorner2, true));
        double d = StrictGeomUtility.toInternalValue(borderCorner.getWidth().getValue());
        double d2 = StrictGeomUtility.toInternalValue(borderCorner.getHeight().getValue());
        double d3 = StrictGeomUtility.toInternalValue(borderCorner2.getWidth().getValue());
        double d4 = StrictGeomUtility.toInternalValue(borderCorner2.getHeight().getValue());
        this.draw(new Line2D.Double(this.x + d, this.y + d2, this.x + d3, this.y + this.height - d4));
    }

    private boolean isSimpleStyle(CSSValue cSSValue) {
        if (BorderStyle.GROOVE.equals(cSSValue)) {
            return false;
        }
        return !BorderStyle.RIDGE.equals(cSSValue);
    }

    private void generateTopEdge() {
        BorderEdge borderEdge = this.border.getTop();
        this.stroke = this.createStroke(borderEdge, this.borderSizes.getTop());
        this.color = borderEdge.getColor();
        BorderCorner borderCorner = this.border.getTopLeft();
        BorderCorner borderCorner2 = this.border.getBottomLeft();
        this.draw(this.generateCorner(1, this.x + this.width, this.y, this.border.getTopRight(), false));
        this.draw(this.generateCorner(2, this.x, this.y, this.border.getTopLeft(), false));
        double d = StrictGeomUtility.toInternalValue(borderCorner.getWidth().getValue());
        double d2 = StrictGeomUtility.toInternalValue(borderCorner.getHeight().getValue());
        double d3 = StrictGeomUtility.toInternalValue(borderCorner2.getWidth().getValue());
        double d4 = StrictGeomUtility.toInternalValue(borderCorner2.getHeight().getValue());
        this.draw(new Line2D.Double(this.x + d, this.y + d2, this.x + this.width - d3, this.y + d4));
        this.fill(this.generateCorner(1, this.x + this.width, this.y, this.border.getTopRight(), true));
        this.fill(this.generateCorner(2, this.x, this.y, this.border.getTopLeft(), true));
    }

    public static class BorderDrawOperation {
        private Color color;
        private BasicStroke stroke;
        private Shape shape;

        public BorderDrawOperation(Shape shape, Color color, BasicStroke basicStroke) {
            this.shape = shape;
            this.color = color;
            this.stroke = basicStroke;
        }

        public void draw(Graphics2D graphics2D) {
            if (this.shape == null) {
                return;
            }
            if (this.stroke.getLineWidth() == 0.0f) {
                return;
            }
            if (this.color.getAlpha() == 0) {
                return;
            }
            graphics2D.setStroke(this.stroke);
            graphics2D.setColor(this.color);
            graphics2D.draw(this.shape);
        }

        public void fill(Graphics2D graphics2D) {
            if (this.shape == null) {
                return;
            }
            if (this.stroke.getLineWidth() == 0.0f) {
                return;
            }
            if (this.color.getAlpha() == 0) {
                return;
            }
            graphics2D.setStroke(this.stroke);
            graphics2D.setColor(this.color);
            graphics2D.fill(this.shape);
        }
    }
}

