// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _XSControl_TransferWriter_HeaderFile
#define _XSControl_TransferWriter_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_XSControl_TransferWriter.hxx>

#include <Handle_XSControl_Controller.hxx>
#include <Handle_Transfer_FinderProcess.hxx>
#include <Standard_Integer.hxx>
#include <MMgt_TShared.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_Standard_Transient.hxx>
#include <IFSelect_ReturnStatus.hxx>
#include <Handle_Interface_InterfaceModel.hxx>
class XSControl_Controller;
class Transfer_FinderProcess;
class Standard_Transient;
class Interface_InterfaceModel;
class TopoDS_Shape;
class Interface_CheckIterator;


//! TransferWriter gives help to control transfer to write a file
//! after having converted data from Cascade/Imagine
//!
//! It works with a Controller (which itself can work with an
//! Actor to Write) and a FinderProcess. It records results and
//! checks
class XSControl_TransferWriter : public MMgt_TShared
{

public:

  
  //! Creates a TransferWriter, empty, ready to run
  //! with an empty FinderProcess (but no controller, etc)
  Standard_EXPORT XSControl_TransferWriter();
  
  //! Returns the FinderProcess itself
  Standard_EXPORT   Handle(Transfer_FinderProcess) FinderProcess()  const;
  
  //! Sets a new FinderProcess and forgets the former one
  Standard_EXPORT   void SetFinderProcess (const Handle(Transfer_FinderProcess)& FP) ;
  
  //! Returns the currently used Controller
  Standard_EXPORT   Handle(XSControl_Controller) Controller()  const;
  
  //! Sets a new Controller, also sets a new FinderProcess
  Standard_EXPORT   void SetController (const Handle(XSControl_Controller)& ctl) ;
  
  //! Clears recorded data according a mode
  //! 0 clears FinderProcess (results, checks)
  //! -1 create a new FinderProcess
  Standard_EXPORT   void Clear (const Standard_Integer mode) ;
  
  //! Returns the current Transfer Mode (an Integer)
  //! It will be interpreted by the Controller to run Transfers
  //! This call form could be later replaced by more specific ones
  //! (parameters suited for each norm / transfer case)
  Standard_EXPORT   Standard_Integer TransferMode()  const;
  
  //! Changes the Transfer Mode
  Standard_EXPORT   void SetTransferMode (const Standard_Integer mode) ;
  
  //! Prints statistics on current Trace File, according what,mode
  //! See PrintStatsProcess for details
  Standard_EXPORT   void PrintStats (const Standard_Integer what, const Standard_Integer mode = 0)  const;
  
  //! Tells if a transient object (from an application) is a valid
  //! candidate for a transfer to a model
  //! Asks the Controller (RecognizeWriteTransient)
  //! If <obj> is a HShape, calls RecognizeShape
  Standard_EXPORT   Standard_Boolean RecognizeTransient (const Handle(Standard_Transient)& obj) ;
  
  //! Transfers a Transient object (from an application) to a model
  //! of current norm, according to the last call to SetTransferMode
  //! Works by calling the Controller
  //! Returns status : =0 if OK, >0 if error during transfer, <0 if
  //! transfer badly initialised
  Standard_EXPORT   IFSelect_ReturnStatus TransferWriteTransient (const Handle(Interface_InterfaceModel)& model, const Handle(Standard_Transient)& obj) ;
  
  //! Tells if a Shape is valid for a transfer to a model
  //! Asks the Controller (RecognizeWriteShape)
  Standard_EXPORT   Standard_Boolean RecognizeShape (const TopoDS_Shape& shape) ;
  
  //! Transfers a Shape from CasCade to a model of current norm,
  //! according to the last call to SetTransferMode
  //! Works by calling the Controller
  //! Returns status : =0 if OK, >0 if error during transfer, <0 if
  //! transfer badly initialised
  Standard_EXPORT   IFSelect_ReturnStatus TransferWriteShape (const Handle(Interface_InterfaceModel)& model, const TopoDS_Shape& shape) ;
  
  //! Returns the check-list of last transfer (write), i.e. the
  //! check-list currently recorded in the FinderProcess
  Standard_EXPORT   Interface_CheckIterator CheckList()  const;
  
  //! Returns the check-list of last transfer (write), but tries
  //! to bind to each check, the resulting entity in the model
  //! instead of keeping the original Mapper, whenever known
  Standard_EXPORT   Interface_CheckIterator ResultCheckList (const Handle(Interface_InterfaceModel)& model)  const;
  
  //! Forecast to print statitics about a FinderProcess
  Standard_EXPORT static   void PrintStatsProcess (const Handle(Transfer_FinderProcess)& TP, const Standard_Integer what, const Standard_Integer mode = 0) ;




  DEFINE_STANDARD_RTTI(XSControl_TransferWriter)

protected:




private: 


  Handle(XSControl_Controller) theController;
  Handle(Transfer_FinderProcess) theTransferWrite;
  Standard_Integer theTransferMode;


};







#endif // _XSControl_TransferWriter_HeaderFile
