/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.ShardParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.handler.component.CloudReplicaSource;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ReplicaSource;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.handler.component.StandaloneReplicaSource;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.util.tracing.GlobalTracer;
import org.apache.solr.util.tracing.SolrRequestCarrier;
import org.slf4j.MDC;

public class HttpShardHandler
extends ShardHandler {
    public static String ONLY_NRT_REPLICAS = "distribOnlyRealtime";
    private HttpShardHandlerFactory httpShardHandlerFactory;
    private CompletionService<ShardResponse> completionService;
    private Set<Future<ShardResponse>> pending;
    private Map<String, List<String>> shardToURLs;
    private Http2SolrClient httpClient;

    public HttpShardHandler(HttpShardHandlerFactory httpShardHandlerFactory, Http2SolrClient httpClient) {
        this.httpClient = httpClient;
        this.httpShardHandlerFactory = httpShardHandlerFactory;
        this.completionService = httpShardHandlerFactory.newCompletionService();
        this.pending = new HashSet<Future<ShardResponse>>();
        this.shardToURLs = new HashMap<String, List<String>>();
    }

    private List<String> getURLs(String shard) {
        List<String> urls = this.shardToURLs.get(shard);
        if (urls == null) {
            urls = this.httpShardHandlerFactory.buildURLList(shard);
            this.shardToURLs.put(shard, urls);
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(ShardRequest sreq, String shard, ModifiableSolrParams params) {
        List<String> urls = this.getURLs(shard);
        Tracer tracer = GlobalTracer.getTracer();
        Span span = tracer != null ? tracer.activeSpan() : null;
        Callable<ShardResponse> task = () -> {
            ShardResponse srsp = new ShardResponse();
            if (sreq.nodeName != null) {
                srsp.setNodeName(sreq.nodeName);
            }
            srsp.setShardRequest(sreq);
            srsp.setShard(shard);
            SimpleSolrResponse ssr = new SimpleSolrResponse();
            srsp.setSolrResponse(ssr);
            long startTime = System.nanoTime();
            try {
                params.remove("wt");
                params.remove("version");
                QueryRequest req = this.makeQueryRequest(sreq, params, shard);
                if (tracer != null && span != null) {
                    tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new SolrRequestCarrier((SolrRequest)req));
                }
                req.setMethod(SolrRequest.METHOD.POST);
                SolrRequestInfo requestInfo = SolrRequestInfo.getRequestInfo();
                if (requestInfo != null) {
                    req.setUserPrincipal(requestInfo.getReq().getUserPrincipal());
                }
                if (urls.size() == 0) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "no servers hosting shard: " + shard);
                }
                if (urls.size() <= 1) {
                    String url = (String)urls.get(0);
                    srsp.setShardAddress(url);
                    ssr.nl = this.request(url, (SolrRequest)req);
                } else {
                    LBSolrClient.Rsp rsp = this.httpShardHandlerFactory.makeLoadBalancedRequest(req, urls);
                    ssr.nl = rsp.getResponse();
                    srsp.setShardAddress(rsp.getServer());
                }
            }
            catch (ConnectException cex) {
                srsp.setException(cex);
            }
            catch (Exception th) {
                srsp.setException(th);
                if (th instanceof SolrException) {
                    srsp.setResponseCode(((SolrException)((Object)((Object)th))).code());
                }
                srsp.setResponseCode(-1);
            }
            ssr.elapsedTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
            return this.transfomResponse(sreq, srsp, shard);
        };
        try {
            if (shard != null) {
                MDC.put((String)"ShardRequest.shards", (String)shard);
            }
            if (urls != null && !urls.isEmpty()) {
                MDC.put((String)"ShardRequest.urlList", (String)urls.toString());
            }
            this.pending.add(this.completionService.submit(task));
        }
        finally {
            MDC.remove((String)"ShardRequest.shards");
            MDC.remove((String)"ShardRequest.urlList");
        }
    }

    protected NamedList<Object> request(String url, SolrRequest req) throws IOException, SolrServerException {
        req.setBasePath(url);
        return this.httpClient.request(req);
    }

    protected QueryRequest makeQueryRequest(ShardRequest sreq, ModifiableSolrParams params, String shard) {
        return new QueryRequest((SolrParams)params);
    }

    protected ShardResponse transfomResponse(ShardRequest sreq, ShardResponse rsp, String shard) {
        return rsp;
    }

    @Override
    public ShardResponse takeCompletedIncludingErrors() {
        return this.take(false);
    }

    @Override
    public ShardResponse takeCompletedOrError() {
        return this.take(true);
    }

    private ShardResponse take(boolean bailOnError) {
        while (this.pending.size() > 0) {
            try {
                Future<ShardResponse> future = this.completionService.take();
                this.pending.remove(future);
                ShardResponse rsp = future.get();
                if (bailOnError && rsp.getException() != null) {
                    return rsp;
                }
                rsp.getShardRequest().responses.add(rsp);
                if (rsp.getShardRequest().responses.size() != rsp.getShardRequest().actualShards.length) continue;
                return rsp;
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Impossible Exception", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void cancelAll() {
        for (Future<ShardResponse> future : this.pending) {
            future.cancel(false);
        }
    }

    @Override
    public void prepDistributed(ResponseBuilder rb) {
        String shards_start;
        ReplicaSource replicaSource;
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        String shards = params.get("shards");
        CoreDescriptor coreDescriptor = req.getCore().getCoreDescriptor();
        CloudDescriptor cloudDescriptor = coreDescriptor.getCloudDescriptor();
        ZkController zkController = req.getCore().getCoreContainer().getZkController();
        ReplicaListTransformer replicaListTransformer = this.httpShardHandlerFactory.getReplicaListTransformer(req);
        HttpShardHandlerFactory.WhitelistHostChecker hostChecker = this.httpShardHandlerFactory.getWhitelistHostChecker();
        if (shards != null && zkController == null && hostChecker.isWhitelistHostCheckingEnabled() && !hostChecker.hasExplicitWhitelist()) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "HttpShardHandlerFactory shardsWhitelist not configured but required (in lieu of ZkController and ClusterState) when using the 'shards' parameter. set -Dsolr.disable.shardsWhitelist=true to disable shards whitelist checks");
        }
        if (zkController != null) {
            boolean onlyNrt = Boolean.TRUE == req.getContext().get(ONLY_NRT_REPLICAS);
            replicaSource = new CloudReplicaSource.Builder().params(params).zkStateReader(zkController.getZkStateReader()).whitelistHostChecker(hostChecker).replicaListTransformer(replicaListTransformer).collection(cloudDescriptor.getCollectionName()).onlyNrt(onlyNrt).build();
            rb.slices = replicaSource.getSliceNames().toArray(new String[replicaSource.getSliceCount()]);
            if (this.canShortCircuit(rb.slices, onlyNrt, params, cloudDescriptor)) {
                rb.isDistrib = false;
                rb.shortCircuitedURL = ZkCoreNodeProps.getCoreUrl((String)zkController.getBaseUrl(), (String)coreDescriptor.getName());
                return;
            }
            for (int i = 0; i < rb.slices.length; ++i) {
                if (ShardParams.getShardsTolerantAsBool((SolrParams)params) || !replicaSource.getReplicasBySlice(i).isEmpty()) continue;
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "no servers hosting shard: " + rb.slices[i]);
            }
        } else {
            replicaSource = new StandaloneReplicaSource.Builder().whitelistHostChecker(hostChecker).shards(shards).build();
            rb.slices = new String[replicaSource.getSliceCount()];
        }
        rb.shards = new String[rb.slices.length];
        for (int i = 0; i < rb.slices.length; ++i) {
            rb.shards[i] = HttpShardHandler.createSliceShardsStr(replicaSource.getReplicasBySlice(i));
        }
        String shards_rows = params.get("shards.rows");
        if (shards_rows != null) {
            rb.shards_rows = Integer.parseInt(shards_rows);
        }
        if ((shards_start = params.get("shards.start")) != null) {
            rb.shards_start = Integer.parseInt(shards_start);
        }
    }

    private static String createSliceShardsStr(List<String> shardUrls) {
        StringBuilder sliceShardsStr = new StringBuilder();
        boolean first = true;
        for (String shardUrl : shardUrls) {
            if (first) {
                first = false;
            } else {
                sliceShardsStr.append('|');
            }
            sliceShardsStr.append(shardUrl);
        }
        return sliceShardsStr.toString();
    }

    private boolean canShortCircuit(String[] slices, boolean onlyNrtReplicas, SolrParams params, CloudDescriptor cloudDescriptor) {
        String ourSlice = cloudDescriptor.getShardId();
        String ourCollection = cloudDescriptor.getCollectionName();
        if (!(slices.length != 1 || slices[0] == null || !slices[0].equals(ourSlice) && !slices[0].equals(ourCollection + "_" + ourSlice) || cloudDescriptor.getLastPublished() != Replica.State.ACTIVE || onlyNrtReplicas && cloudDescriptor.getReplicaType() != Replica.Type.NRT)) {
            boolean shortCircuit = params.getBool("shortCircuit", true);
            String targetHandler = params.get("shards.qt");
            shortCircuit = shortCircuit && targetHandler == null;
            return shortCircuit;
        }
        return false;
    }

    @Override
    public ShardHandlerFactory getShardHandlerFactory() {
        return this.httpShardHandlerFactory;
    }

    private static class SimpleSolrResponse
    extends SolrResponse {
        long elapsedTime;
        NamedList<Object> nl;

        private SimpleSolrResponse() {
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public NamedList<Object> getResponse() {
            return this.nl;
        }

        public void setResponse(NamedList<Object> rsp) {
            this.nl = rsp;
        }

        public void setElapsedTime(long elapsedTime) {
            this.elapsedTime = elapsedTime;
        }
    }
}

