/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.autoupdate.members.prefs;

import au.com.trgtd.tr.autoupdate.members.MemberCheckThread;
import au.com.trgtd.tr.autoupdate.members.MemberUtils;
import au.com.trgtd.tr.autoupdate.members.prefs.MemberOptionsPanelController;
import au.com.trgtd.tr.autoupdate.members.prefs.MemberPrefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;

public class MemberPanel
extends JPanel {
    private final MemberOptionsPanelController controller;
    private JCheckBox modulesBetaCheckBox;
    private JCheckBox modulesCheckBox;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JLabel usernameLabel;
    private JTextField usernameField;
    private JButton validateButton;

    MemberPanel(MemberOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        this.modulesCheckBox = new JCheckBox(this.getMsg("MemberPanel.updates"));
        this.modulesBetaCheckBox = new JCheckBox(this.getMsg("MemberPanel.beta.updates"));
        this.usernameLabel = new JLabel(this.getMsg("MemberPanel.username"));
        this.usernameField = new JTextField();
        this.passwordLabel = new JLabel(this.getMsg("MemberPanel.password"));
        this.passwordField = new JPasswordField();
        this.validateButton = new JButton(this.getMsg("MemberPanel.validate"));
        this.validateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberPanel.this.validateButtonActionPerformed(evt);
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[200:200:400]0", "0[]2[]2[]2[]2[]0"));
        panel.add((Component)this.modulesCheckBox, "align left, span, wrap");
        panel.add((Component)this.modulesBetaCheckBox, "align left, span, wrap");
        panel.add((Component)this.usernameLabel, "align right");
        panel.add((Component)this.usernameField, "align left, w 200:200:400, wrap");
        panel.add((Component)this.passwordLabel, "align right");
        panel.add((Component)this.passwordField, "align left, w 200:200:400, wrap");
        panel.add((Component)this.validateButton, "skip, align left, wrap");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    void load() {
        this.modulesCheckBox.setSelected(MemberPrefs.isGetUpdates());
        this.modulesBetaCheckBox.setSelected(MemberPrefs.isGetBetaUpdates());
        this.usernameField.setText(MemberPrefs.getMemberUsername());
        this.passwordField.setText(MemberPrefs.getMemberPassword());
    }

    void store() {
        MemberPrefs.setGetUpdates(this.modulesCheckBox.isSelected());
        MemberPrefs.setGetBetaUpdates(this.modulesBetaCheckBox.isSelected());
        MemberPrefs.setMemberUsername(this.usernameField.getText());
        MemberPrefs.setMemberPassword(new String(this.passwordField.getPassword()));
        new MemberCheckThread().start();
    }

    boolean valid() {
        return true;
    }

    private void validateButtonActionPerformed(ActionEvent evt) {
        String username = this.usernameField.getText();
        String password = new String(this.passwordField.getPassword());
        Boolean isMember = MemberUtils.getDefault().isMember(username, password);
        if (isMember == null) {
            String t = NbBundle.getMessage(MemberPanel.class, (String)"validate.member.dialog.title");
            String m = NbBundle.getMessage(MemberPanel.class, (String)"validate.member.dialog.unknown");
            JOptionPane.showMessageDialog(this, m, t, 0);
        } else if (isMember.booleanValue()) {
            String t = NbBundle.getMessage(MemberPanel.class, (String)"validate.member.dialog.title");
            String m = NbBundle.getMessage(MemberPanel.class, (String)"validate.member.dialog.success");
            JOptionPane.showMessageDialog(this, m, t, 1);
        } else {
            String t = NbBundle.getMessage(MemberPanel.class, (String)"validate.member.dialog.title");
            String m = NbBundle.getMessage(MemberPanel.class, (String)"validate.member.dialog.failed");
            JOptionPane.showMessageDialog(this, m, t, 0);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

